/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.definition;

import apex.jorje.lsp.api.definition.DefinitionStrategy;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApexDefinitionStrategyAggregator
implements DefinitionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ApexDefinitionStrategyAggregator.class);
    private final Set<DefinitionStrategy> strategies;

    @Inject
    public ApexDefinitionStrategyAggregator(Set<DefinitionStrategy> definitionStrategies) {
        this.strategies = definitionStrategies;
    }

    @Override
    public List<? extends Location> provideDefinition(TextDocumentPositionParams params) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList<? extends Location> items = Lists.newArrayList();
        for (DefinitionStrategy strategy : this.strategies) {
            try {
                items.addAll(strategy.provideDefinition(params));
            }
            catch (Exception e) {
                logger.error(String.format("Encountered an error with strategy %s", strategy), (Throwable)e);
            }
        }
        stopwatch.stop();
        logger.info("Definition for {} took {} ms.", (Object)params.getTextDocument().getUri(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return items;
    }
}

