/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data;

import apex.common.base.ObjectHash;
import apex.jorje.data.Location;

class PositionLocation
implements Location {
    private final int line;
    private final int column;

    PositionLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int hashCode() {
        return ObjectHash.hash(this.line, this.column);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        return this.line == location.getLine() && this.column == location.getColumn();
    }

    public String toString() {
        return "(" + this.line + ", " + this.column + ")";
    }

    @Override
    public Location getLoc() {
        return this;
    }

    @Override
    public int getStartIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return 0;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }
}

