/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.emoji.Emoji;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.CreoleContext;
import net.sourceforge.plantuml.klimt.creole.CreoleHorizontalLine;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Stripe;
import net.sourceforge.plantuml.klimt.creole.StripeStyle;
import net.sourceforge.plantuml.klimt.creole.StripeStyleType;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.creole.atom.AtomEmoji;
import net.sourceforge.plantuml.klimt.creole.atom.AtomImg;
import net.sourceforge.plantuml.klimt.creole.atom.AtomMath;
import net.sourceforge.plantuml.klimt.creole.atom.AtomOpenIcon;
import net.sourceforge.plantuml.klimt.creole.atom.AtomSpace;
import net.sourceforge.plantuml.klimt.creole.atom.AtomSprite;
import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.legacy.AtomTextUtils;
import net.sourceforge.plantuml.klimt.creole.legacy.CommandCreoleBuilder;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.ImgValign;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.math.ScientificEquationSafe;
import net.sourceforge.plantuml.openiconic.OpenIcon;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.CharHidder;

public class StripeSimple
implements Stripe {
    private final Atom header;
    private final List<Atom> atoms = new ArrayList<Atom>();
    private final Map<Character, List<Command>> commands;
    private HorizontalAlignment align = HorizontalAlignment.LEFT;
    private FontConfiguration fontConfiguration;
    private final StripeStyle style;
    private final ISkinSimple skinParam;

    public void setCellAlignment(HorizontalAlignment align) {
        this.align = align;
    }

    public HorizontalAlignment getCellAlignment() {
        return this.align;
    }

    public String toString() {
        return super.toString() + " " + this.atoms.toString();
    }

    @Override
    public Atom getLHeader() {
        return this.header;
    }

    public StripeSimple(FontConfiguration fontConfiguration, StripeStyle style, CreoleContext context, ISkinSimple skinParam, CreoleMode modeSimpleLine) {
        this.fontConfiguration = fontConfiguration;
        this.style = style;
        this.skinParam = skinParam;
        this.commands = modeSimpleLine == CreoleMode.FULL ? CommandCreoleBuilder.FULL.getMap() : CommandCreoleBuilder.OTHER.getMap();
        this.header = style.getHeader(fontConfiguration, context);
        if (this.header != null) {
            this.atoms.add(this.header);
        }
    }

    @Override
    public List<Atom> getAtoms() {
        if (this.atoms.size() == 0) {
            this.atoms.add(AtomTextUtils.createLegacy(" ", this.fontConfiguration));
        }
        return Collections.unmodifiableList(this.atoms);
    }

    public FontConfiguration getActualFontConfiguration() {
        return this.fontConfiguration;
    }

    public void setActualFontConfiguration(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    public void analyzeAndAdd(String line) {
        if (line.indexOf(57600) != -1) {
            throw new IllegalArgumentException(line);
        }
        line = CharHidder.hide(line);
        if (this.style.getType() == StripeStyleType.HEADING) {
            this.fontConfiguration = StripeSimple.fontConfigurationForHeading(this.fontConfiguration, this.style.getOrder());
            this.modifyStripe(line);
        } else if (this.style.getType() == StripeStyleType.HORIZONTAL_LINE) {
            this.atoms.add(CreoleHorizontalLine.create(this.fontConfiguration, line, this.style.getStyle(), this.skinParam));
        } else {
            this.modifyStripe(line);
        }
    }

    private static FontConfiguration fontConfigurationForHeading(FontConfiguration fontConfiguration, int order) {
        switch (order) {
            case 0: {
                return fontConfiguration.bigger(4.0).bold();
            }
            case 1: {
                return fontConfiguration.bigger(2.0).bold();
            }
            case 2: {
                return fontConfiguration.bigger(1.0).bold();
            }
        }
        return fontConfiguration.italic();
    }

    public void addImage(String src, double scale) {
        this.atoms.add(AtomImg.create(src, ImgValign.TOP, 0, scale, null));
    }

    public void addQrcode(String src, double scale) {
        this.atoms.add(AtomImg.createQrcode(src, scale));
    }

    public void addSpace(int size) {
        this.atoms.add(AtomSpace.create(size));
    }

    public void addUrl(Url url) {
        this.atoms.add(AtomTextUtils.createUrl(url, this.fontConfiguration, this.skinParam));
    }

    public void addSprite(String src, double scale, HColor forcedColor) {
        Sprite sprite = this.skinParam.getSprite(src);
        if (sprite != null) {
            this.atoms.add(new AtomSprite(this.fontConfiguration.getColor(), forcedColor, scale, sprite, null));
        }
    }

    public void addOpenIcon(String src, double scale, HColor color) {
        OpenIcon openIcon = OpenIcon.retrieve(src);
        if (openIcon != null) {
            this.atoms.add(new AtomOpenIcon(color, scale, openIcon, this.fontConfiguration, null));
        }
    }

    public void addEmoji(String emojiName, double scale, String forcedColor) {
        Emoji emoji = Emoji.retrieve(emojiName);
        if (emoji == null) {
            this.atoms.add(AtomTextUtils.create("\u00bf" + emojiName + "?", this.fontConfiguration.changeColor(HColors.RED)));
            return;
        }
        HColor col = null;
        if (forcedColor == null) {
            col = null;
        } else if (forcedColor.equals("#0") || forcedColor.equals("#000") || forcedColor.equals("#black")) {
            col = this.fontConfiguration.getColor();
        } else {
            try {
                col = this.skinParam.getIHtmlColorSet().getColor(forcedColor);
            }
            catch (NoSuchColorException e) {
                col = null;
            }
        }
        this.atoms.add(new AtomEmoji(emoji, scale, this.fontConfiguration.getSize2D(), col));
    }

    public void addMath(ScientificEquationSafe math) {
        this.atoms.add(new AtomMath(math, this.fontConfiguration.getColor(), this.fontConfiguration.getExtendedColor()));
    }

    private void modifyStripe(String line) {
        StringBuilder pending = new StringBuilder();
        while (line.length() > 0) {
            Command cmd = this.searchCommand(line);
            if (cmd == null) {
                pending.append(line.charAt(0));
                line = line.substring(1);
                continue;
            }
            this.addPending(pending);
            line = cmd.executeAndGetRemaining(line, this);
        }
        this.addPending(pending);
    }

    private void addPending(StringBuilder pending) {
        if (pending.length() == 0) {
            return;
        }
        this.atoms.add(AtomTextUtils.createLegacy(pending.toString(), this.fontConfiguration));
        pending.setLength(0);
    }

    private Command searchCommand(String line) {
        List<Command> localList = this.commands.get(Character.valueOf(line.charAt(0)));
        if (localList != null) {
            for (Command cmd : localList) {
                if (cmd.matchingSize(line) == 0) continue;
                return cmd;
            }
        }
        return null;
    }

    public ISkinSimple getSkinParam() {
        return this.skinParam;
    }
}

