/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.emoji;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.atmp.PixelImage;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SImageIO;

public class SpriteSvgNanoParser
implements Sprite {
    private final UImage img;

    public SpriteSvgNanoParser(BufferedImage img) {
        this.img = new UImage(new PixelImage(Objects.requireNonNull(img), AffineTransformType.TYPE_BILINEAR));
    }

    @Override
    public TextBlock asTextBlock(HColor fontColor, final HColor forcedColor, final double scale) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                ColorMapper colorMapper = ug.getColorMapper();
                if (colorMapper == ColorMapper.MONOCHROME) {
                    ug.draw(SpriteSvgNanoParser.this.img.monochrome().scale(scale));
                } else if (forcedColor == null) {
                    ug.draw(SpriteSvgNanoParser.this.img.scale(scale));
                } else {
                    ug.draw(SpriteSvgNanoParser.this.img.muteColor(forcedColor.toColor(colorMapper)).scale(scale));
                }
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D((double)SpriteSvgNanoParser.this.img.getWidth() * scale, (double)SpriteSvgNanoParser.this.img.getHeight() * scale);
            }
        };
    }

    public static Sprite fromInternal(String name) {
        if (name.endsWith(".png")) {
            throw new IllegalArgumentException();
        }
        InputStream is = SpriteSvgNanoParser.getInternalSprite(name + ".png");
        if (is == null) {
            return null;
        }
        try {
            return new SpriteSvgNanoParser(SImageIO.read(is));
        }
        catch (IOException e) {
            Logme.error(e);
            return null;
        }
    }

    public static InputStream getInternalSprite(String inner) {
        String path = "/sprites/" + inner;
        InputStream is = SpriteSvgNanoParser.class.getResourceAsStream(path);
        return is;
    }
}

