/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.argon2.algorithm;

import net.sourceforge.plantuml.argon2.Argon2;
import net.sourceforge.plantuml.argon2.Util;
import net.sourceforge.plantuml.argon2.algorithm.Functions;
import net.sourceforge.plantuml.argon2.model.Instance;

public class Initialize {
    public static void initialize(Instance instance, Argon2 argon2) {
        byte[] initialHash = Functions.initialHash(Util.intToLittleEndianBytes(argon2.getLanes()), Util.intToLittleEndianBytes(argon2.getOutputLength()), Util.intToLittleEndianBytes(argon2.getMemory()), Util.intToLittleEndianBytes(argon2.getIterations()), Util.intToLittleEndianBytes(argon2.getVersion()), Util.intToLittleEndianBytes(argon2.getType().ordinal()), Util.intToLittleEndianBytes(argon2.getPasswordLength()), argon2.getPassword(), Util.intToLittleEndianBytes(argon2.getSaltLength()), argon2.getSalt(), Util.intToLittleEndianBytes(argon2.getSecretLength()), argon2.getSecret(), Util.intToLittleEndianBytes(argon2.getAdditionalLength()), argon2.getAdditional());
        Initialize.fillFirstBlocks(instance, initialHash);
    }

    private static void fillFirstBlocks(Instance instance, byte[] initialHash) {
        byte[] zeroBytes = new byte[]{0, 0, 0, 0};
        byte[] oneBytes = new byte[]{1, 0, 0, 0};
        byte[] initialHashWithZeros = Initialize.getInitialHashLong(initialHash, zeroBytes);
        byte[] initialHashWithOnes = Initialize.getInitialHashLong(initialHash, oneBytes);
        for (int i = 0; i < instance.getLanes(); ++i) {
            byte[] iBytes = Util.intToLittleEndianBytes(i);
            System.arraycopy(iBytes, 0, initialHashWithZeros, 68, 4);
            System.arraycopy(iBytes, 0, initialHashWithOnes, 68, 4);
            byte[] blockhashBytes = Functions.blake2bLong(initialHashWithZeros, 1024);
            instance.memory[i * instance.getLaneLength() + 0].fromBytes(blockhashBytes);
            blockhashBytes = Functions.blake2bLong(initialHashWithOnes, 1024);
            instance.memory[i * instance.getLaneLength() + 1].fromBytes(blockhashBytes);
        }
    }

    private static byte[] getInitialHashLong(byte[] initialHash, byte[] appendix) {
        byte[] initialHashLong = new byte[72];
        System.arraycopy(initialHash, 0, initialHashLong, 0, 64);
        System.arraycopy(appendix, 0, initialHashLong, 64, 4);
        return initialHashLong;
    }
}

