/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.io.File;

public enum ExeState {
    NULL_UNDEFINED,
    OK,
    DOES_NOT_EXIST,
    IS_A_DIRECTORY,
    NOT_A_FILE,
    CANNOT_BE_READ;


    public static ExeState checkFile(File dotExe) {
        if (dotExe == null) {
            return NULL_UNDEFINED;
        }
        if (!dotExe.exists()) {
            return DOES_NOT_EXIST;
        }
        if (dotExe.isDirectory()) {
            return IS_A_DIRECTORY;
        }
        if (!dotExe.isFile()) {
            return NOT_A_FILE;
        }
        if (!dotExe.canRead()) {
            return CANNOT_BE_READ;
        }
        return OK;
    }

    public String getTextMessage() {
        switch (this) {
            case OK: {
                return "File OK";
            }
            case NULL_UNDEFINED: {
                return "No dot executable found";
            }
            case DOES_NOT_EXIST: {
                return "File does not exist";
            }
            case IS_A_DIRECTORY: {
                return "It should be an executable, not a directory";
            }
            case NOT_A_FILE: {
                return "Not a valid file";
            }
            case CANNOT_BE_READ: {
                return "File cannot be read";
            }
        }
        throw new IllegalStateException();
    }

    public String getTextMessage(File exe) {
        switch (this) {
            case OK: {
                return "File " + exe.getAbsolutePath() + " OK";
            }
            case NULL_UNDEFINED: {
                return NULL_UNDEFINED.getTextMessage();
            }
            case DOES_NOT_EXIST: {
                return "File " + exe.getAbsolutePath() + " does not exist";
            }
            case IS_A_DIRECTORY: {
                return "File " + exe.getAbsolutePath() + " should be an executable, not a directory";
            }
            case NOT_A_FILE: {
                return "File " + exe.getAbsolutePath() + " is not a valid file";
            }
            case CANNOT_BE_READ: {
                return "File " + exe.getAbsolutePath() + " cannot be read";
            }
        }
        throw new IllegalStateException();
    }
}

