/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.swing.LicenseWindow;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.version.Version;

class AboutWindow
extends JFrame {
    public AboutWindow() {
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.setTitle("About PlantUML (" + Version.versionString() + ")");
        JPanel panel1 = new JPanel(new GridLayout(2, 1));
        panel1.add(this.getInfoVersion());
        panel1.add(this.getInfoAuthors());
        this.getContentPane().add((Component)this.getNorthLabel(), "North");
        this.getContentPane().add((Component)panel1, "Center");
        this.getContentPane().add((Component)this.getSouthLabel(), "South");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    private JComponent getNorthLabel() {
        JLabel text = new JLabel("PlantUML (" + Version.versionString() + ")");
        Font font = text.getFont().deriveFont(1, 20.0f);
        text.setFont(font);
        JPanel ptext = new JPanel();
        ptext.add(text);
        JLabel icon = new JLabel(new ImageIcon(PSystemVersion.getPlantumlImage()));
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)ptext, "Center");
        result.add((Component)icon, "East");
        return result;
    }

    private JComponent getSouthLabel() {
        JPanel result = new JPanel();
        JButton license = new JButton("License");
        license.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                new LicenseWindow();
            }
        });
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AboutWindow.this.dispose();
            }
        });
        result.add(license);
        result.add(ok);
        return result;
    }

    private JComponent getInfoVersion() {
        PSystemVersion p1 = PSystemVersion.createShowVersion2(UmlSource.create(new ArrayList<StringLocated>(), false));
        return this.getJComponent(this.skip(p1.getLines()));
    }

    private JComponent getInfoAuthors() {
        PSystemVersion p1 = PSystemVersion.createShowAuthors2(UmlSource.create(new ArrayList<StringLocated>(), false));
        return this.getJComponent(this.skip(p1.getLines()));
    }

    private List<String> skip(List<String> lines) {
        return lines.subList(2, lines.size());
    }

    private JComponent getJComponent(List<String> lines) {
        StringBuilder sb = new StringBuilder("<html>");
        for (String s : lines) {
            sb.append(s + "</b></i></u>");
            sb.append("<br>");
        }
        sb.append("</html>");
        JEditorPane text = new JEditorPane("text/html", sb.toString());
        text.setEditable(false);
        CompoundBorder border = new CompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        border = new CompoundBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, this.getBackground()), border);
        text.setBorder(border);
        return text;
    }

    public static void main(String[] arg) {
        new AboutWindow();
    }
}

