/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.xml.sax.Locator;

public class LayoutMasterSet
extends FObj {
    private Map<String, SimplePageMaster> simplePageMasters;
    private Map<String, PageSequenceMaster> pageSequenceMasters;

    public LayoutMasterSet(FONode parent) {
        super(parent);
    }

    @Override
    public void bind(PropertyList pList) throws FOPException {
    }

    @Override
    public void startOfNode() throws FOPException {
        this.getRoot().setLayoutMasterSet(this);
        this.simplePageMasters = new HashMap<String, SimplePageMaster>();
        this.pageSequenceMasters = new HashMap<String, PageSequenceMaster>();
    }

    @Override
    public void endOfNode() throws FOPException {
        if (this.firstChild == null) {
            this.missingChildElementError("(simple-page-master|page-sequence-master)+");
        }
        this.checkRegionNames();
        this.resolveSubSequenceReferences();
    }

    @Override
    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && !localName.equals("simple-page-master") && !localName.equals("page-sequence-master")) {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    private void checkRegionNames() throws ValidationException {
        HashMap<String, String> allRegions = new HashMap<String, String>();
        for (SimplePageMaster simplePageMaster : this.simplePageMasters.values()) {
            Map<String, Region> spmRegions = simplePageMaster.getRegions();
            for (Region region : spmRegions.values()) {
                String defaultRegionName;
                if (allRegions.containsKey(region.getRegionName()) && !(defaultRegionName = (String)allRegions.get(region.getRegionName())).equals(region.getDefaultRegionName())) {
                    this.getFOValidationEventProducer().regionNameMappedToMultipleRegionClasses(this, region.getRegionName(), defaultRegionName, region.getDefaultRegionName(), this.getLocator());
                }
                allRegions.put(region.getRegionName(), region.getDefaultRegionName());
            }
        }
    }

    private void resolveSubSequenceReferences() throws ValidationException {
        for (PageSequenceMaster psm : this.pageSequenceMasters.values()) {
            for (SubSequenceSpecifier subSequenceSpecifier : psm.getSubSequenceSpecifier()) {
                subSequenceSpecifier.resolveReferences(this);
            }
        }
    }

    protected void addSimplePageMaster(SimplePageMaster sPM) throws ValidationException {
        String masterName = sPM.getMasterName();
        if (this.existsName(masterName)) {
            this.getFOValidationEventProducer().masterNameNotUnique(this, this.getName(), masterName, sPM.getLocator());
        }
        this.simplePageMasters.put(masterName, sPM);
    }

    private boolean existsName(String masterName) {
        return this.simplePageMasters.containsKey(masterName) || this.pageSequenceMasters.containsKey(masterName);
    }

    public SimplePageMaster getSimplePageMaster(String masterName) {
        return this.simplePageMasters.get(masterName);
    }

    protected void addPageSequenceMaster(String masterName, PageSequenceMaster pSM) throws ValidationException {
        if (this.existsName(masterName)) {
            this.getFOValidationEventProducer().masterNameNotUnique(this, this.getName(), masterName, pSM.getLocator());
        }
        this.pageSequenceMasters.put(masterName, pSM);
    }

    public PageSequenceMaster getPageSequenceMaster(String masterName) {
        return this.pageSequenceMasters.get(masterName);
    }

    public boolean regionNameExists(String regionName) {
        for (SimplePageMaster spm : this.simplePageMasters.values()) {
            if (!spm.regionNameExists(regionName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getLocalName() {
        return "layout-master-set";
    }

    @Override
    public int getNameId() {
        return 38;
    }

    public String getDefaultRegionNameFor(String flowName) {
        for (SimplePageMaster spm : this.simplePageMasters.values()) {
            for (Region region : spm.getRegions().values()) {
                if (!region.getRegionName().equals(flowName)) continue;
                return region.getDefaultRegionName();
            }
        }
        assert (flowName.equals("xsl-before-float-separator") || flowName.equals("xsl-footnote-separator"));
        return flowName;
    }
}

