/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.util.ColorWithFallback;
import org.apache.fop.util.OCAColor;
import org.apache.xmlgraphics.java2d.color.CIELabColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorSpaceOrigin;
import org.apache.xmlgraphics.java2d.color.ColorSpaces;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;
import org.apache.xmlgraphics.java2d.color.DeviceCMYKColorSpace;
import org.apache.xmlgraphics.java2d.color.NamedColorSpace;
import org.apache.xmlgraphics.java2d.color.RenderingIntent;
import org.apache.xmlgraphics.java2d.color.profile.NamedColorProfile;
import org.apache.xmlgraphics.java2d.color.profile.NamedColorProfileParser;

public final class ColorUtil {
    public static final String CMYK_PSEUDO_PROFILE = "#CMYK";
    public static final String SEPARATION_PSEUDO_PROFILE = "#Separation";
    private static Map<String, Color> colorMap;
    private static final Log log;

    private ColorUtil() {
    }

    public static Color parseColorString(FOUserAgent foUserAgent, String value) throws PropertyException {
        if (value == null) {
            return null;
        }
        Color parsedColor = colorMap.get(value.toLowerCase());
        if (parsedColor == null) {
            if (value.startsWith("#")) {
                parsedColor = ColorUtil.parseWithHash(value);
            } else if (value.startsWith("rgb(")) {
                parsedColor = ColorUtil.parseAsRGB(value);
            } else {
                if (value.startsWith("url(")) {
                    throw new PropertyException("Colors starting with url( are not yet supported!");
                }
                if (value.startsWith("java.awt.Color")) {
                    parsedColor = ColorUtil.parseAsJavaAWTColor(value);
                } else if (value.startsWith("system-color(")) {
                    parsedColor = ColorUtil.parseAsSystemColor(value);
                } else if (value.startsWith("fop-rgb-icc")) {
                    parsedColor = ColorUtil.parseAsFopRgbIcc(foUserAgent, value);
                } else if (value.startsWith("fop-rgb-named-color")) {
                    parsedColor = ColorUtil.parseAsFopRgbNamedColor(foUserAgent, value);
                } else if (value.startsWith("cie-lab-color")) {
                    parsedColor = ColorUtil.parseAsCIELabColor(foUserAgent, value);
                } else if (value.startsWith("cmyk")) {
                    parsedColor = ColorUtil.parseAsCMYK(value);
                } else if (value.startsWith("oca")) {
                    parsedColor = ColorUtil.parseAsOCA(value);
                }
            }
            if (parsedColor == null) {
                throw new PropertyException("Unknown Color: " + value);
            }
            colorMap.put(value, parsedColor);
        }
        return parsedColor;
    }

    private static Color parseAsSystemColor(String value) throws PropertyException {
        int poss = value.indexOf("(");
        int pose = value.indexOf(")");
        if (poss == -1 || pose == -1) {
            throw new PropertyException("Unknown color format: " + value + ". Must be system-color(x)");
        }
        value = value.substring(poss + 1, pose);
        return colorMap.get(value);
    }

    private static Color parseAsJavaAWTColor(String value) throws PropertyException {
        float blue;
        float green;
        float red;
        block5: {
            red = 0.0f;
            green = 0.0f;
            blue = 0.0f;
            int poss = value.indexOf("[");
            int pose = value.indexOf("]");
            try {
                if (poss != -1 && pose != -1) {
                    String[] args = (value = value.substring(poss + 1, pose)).split(",");
                    if (args.length != 3) {
                        throw new PropertyException("Invalid number of arguments for a java.awt.Color: " + value);
                    }
                    red = Float.parseFloat(args[0].trim().substring(2)) / 255.0f;
                    green = Float.parseFloat(args[1].trim().substring(2)) / 255.0f;
                    blue = Float.parseFloat(args[2].trim().substring(2)) / 255.0f;
                    if ((double)red < 0.0 || (double)red > 1.0 || (double)green < 0.0 || (double)green > 1.0 || (double)blue < 0.0 || (double)blue > 1.0) {
                        throw new PropertyException("Color values out of range");
                    }
                    break block5;
                }
                throw new IllegalArgumentException("Invalid format for a java.awt.Color: " + value);
            }
            catch (RuntimeException re) {
                throw new PropertyException(re);
            }
        }
        return new Color(red, green, blue);
    }

    private static Color parseAsRGB(String value) throws PropertyException {
        Color parsedColor;
        int poss = value.indexOf("(");
        int pose = value.indexOf(")");
        if (poss != -1 && pose != -1) {
            value = value.substring(poss + 1, pose);
            try {
                String[] args = value.split(",");
                if (args.length != 3) {
                    throw new PropertyException("Invalid number of arguments: rgb(" + value + ")");
                }
                float red = ColorUtil.parseComponent255(args[0], value);
                float green = ColorUtil.parseComponent255(args[1], value);
                float blue = ColorUtil.parseComponent255(args[2], value);
                int r = (int)((double)(red * 255.0f) + 0.5);
                int g = (int)((double)(green * 255.0f) + 0.5);
                int b = (int)((double)(blue * 255.0f) + 0.5);
                parsedColor = new Color(r, g, b);
            }
            catch (RuntimeException re) {
                throw new PropertyException(re);
            }
        } else {
            throw new PropertyException("Unknown color format: " + value + ". Must be rgb(r,g,b)");
        }
        return parsedColor;
    }

    private static float parseComponent255(String str, String function) throws PropertyException {
        float component = (str = str.trim()).endsWith("%") ? Float.parseFloat(str.substring(0, str.length() - 1)) / 100.0f : Float.parseFloat(str) / 255.0f;
        if ((double)component < 0.0 || (double)component > 1.0) {
            throw new PropertyException("Color value out of range for " + function + ": " + str + ". Valid range: [0..255] or [0%..100%]");
        }
        return component;
    }

    private static float parseComponent1(String argument, String function) throws PropertyException {
        return ColorUtil.parseComponent(argument, 0.0f, 1.0f, function);
    }

    private static float parseComponent(String argument, float min, float max, String function) throws PropertyException {
        float component = Float.parseFloat(argument.trim());
        if (component < min || component > max) {
            throw new PropertyException("Color value out of range for " + function + ": " + argument + ". Valid range: [" + min + ".." + max + "]");
        }
        return component;
    }

    private static Color parseFallback(String[] args, String value) throws PropertyException {
        float red = ColorUtil.parseComponent1(args[0], value);
        float green = ColorUtil.parseComponent1(args[1], value);
        float blue = ColorUtil.parseComponent1(args[2], value);
        Color sRGB = new Color(red, green, blue);
        return sRGB;
    }

    private static Color parseWithHash(String value) throws PropertyException {
        Color parsedColor;
        try {
            int len = value.length();
            int alpha = len == 5 || len == 9 ? Integer.parseInt(value.substring(len == 5 ? 3 : 7), 16) : 255;
            int red = 0;
            int green = 0;
            int blue = 0;
            if (len == 4 || len == 5) {
                red = Integer.parseInt(value.substring(1, 2), 16) * 17;
                green = Integer.parseInt(value.substring(2, 3), 16) * 17;
                blue = Integer.parseInt(value.substring(3, 4), 16) * 17;
            } else if (len == 7 || len == 9) {
                red = Integer.parseInt(value.substring(1, 3), 16);
                green = Integer.parseInt(value.substring(3, 5), 16);
                blue = Integer.parseInt(value.substring(5, 7), 16);
            } else {
                throw new NumberFormatException();
            }
            parsedColor = new Color(red, green, blue, alpha);
        }
        catch (RuntimeException re) {
            throw new PropertyException("Unknown color format: " + value + ". Must be #RGB. #RGBA, #RRGGBB, or #RRGGBBAA");
        }
        return parsedColor;
    }

    private static Color parseAsFopRgbIcc(FOUserAgent foUserAgent, String value) throws PropertyException {
        Color parsedColor;
        int poss = value.indexOf("(");
        int pose = value.indexOf(")");
        if (poss != -1 && pose != -1) {
            String[] args = value.substring(poss + 1, pose).split(",");
            try {
                if (args.length < 5) {
                    throw new PropertyException("Too few arguments for rgb-icc() function");
                }
                Color sRGB = ColorUtil.parseFallback(args, value);
                String iccProfileName = args[3].trim();
                if (iccProfileName == null || "".equals(iccProfileName)) {
                    throw new PropertyException("ICC profile name missing");
                }
                ColorSpace colorSpace = null;
                String iccProfileSrc = null;
                if (ColorUtil.isPseudoProfile(iccProfileName)) {
                    if (CMYK_PSEUDO_PROFILE.equalsIgnoreCase(iccProfileName)) {
                        colorSpace = ColorSpaces.getDeviceCMYKColorSpace();
                    } else if (SEPARATION_PSEUDO_PROFILE.equalsIgnoreCase(iccProfileName)) {
                        colorSpace = new NamedColorSpace(args[5], sRGB, SEPARATION_PSEUDO_PROFILE, null);
                    } else assert (false) : "Incomplete implementation";
                } else {
                    iccProfileSrc = args[4].trim();
                    if (iccProfileSrc == null || "".equals(iccProfileSrc)) {
                        throw new PropertyException("ICC profile source missing");
                    }
                    iccProfileSrc = ColorUtil.unescapeString(iccProfileSrc);
                }
                int componentStart = 4;
                if (colorSpace instanceof NamedColorSpace) {
                    ++componentStart;
                }
                float[] iccComponents = new float[args.length - componentStart - 1];
                int ix = componentStart;
                while (++ix < args.length) {
                    iccComponents[ix - componentStart - 1] = Float.parseFloat(args[ix].trim());
                }
                if (colorSpace instanceof NamedColorSpace && iccComponents.length == 0) {
                    iccComponents = new float[]{1.0f};
                }
                if (foUserAgent != null && iccProfileSrc != null) {
                    RenderingIntent renderingIntent = RenderingIntent.AUTO;
                    colorSpace = foUserAgent.getColorSpaceCache().get(iccProfileName, iccProfileSrc, renderingIntent);
                }
                if (colorSpace != null) {
                    if (ColorSpaces.isDeviceColorSpace(colorSpace)) {
                        Color deviceColor = new Color(colorSpace, iccComponents, 1.0f);
                        float[] rgbComps = sRGB.getRGBColorComponents(null);
                        parsedColor = new ColorWithAlternatives(rgbComps[0], rgbComps[1], rgbComps[2], new Color[]{deviceColor});
                    }
                    parsedColor = new ColorWithFallback(colorSpace, iccComponents, 1.0f, null, sRGB);
                }
                log.warn("Color profile '" + iccProfileSrc + "' not found. Using sRGB replacement values.");
                parsedColor = sRGB;
            }
            catch (RuntimeException re) {
                throw new PropertyException(re);
            }
        } else {
            throw new PropertyException("Unknown color format: " + value + ". Must be fop-rgb-icc(r,g,b,NCNAME,src,....)");
        }
        return parsedColor;
    }

    private static Color parseAsFopRgbNamedColor(FOUserAgent foUserAgent, String value) throws PropertyException {
        Color parsedColor;
        int poss = value.indexOf("(");
        int pose = value.indexOf(")");
        if (poss != -1 && pose != -1) {
            String[] args = value.substring(poss + 1, pose).split(",");
            try {
                if (args.length != 6) {
                    throw new PropertyException("rgb-named-color() function must have 6 arguments");
                }
                Color sRGB = ColorUtil.parseFallback(args, value);
                String iccProfileName = args[3].trim();
                if (iccProfileName == null || "".equals(iccProfileName)) {
                    throw new PropertyException("ICC profile name missing");
                }
                ICC_ColorSpace colorSpace = null;
                if (ColorUtil.isPseudoProfile(iccProfileName)) {
                    throw new IllegalArgumentException("Pseudo-profiles are not allowed with fop-rgb-named-color()");
                }
                String iccProfileSrc = args[4].trim();
                if (iccProfileSrc == null || "".equals(iccProfileSrc)) {
                    throw new PropertyException("ICC profile source missing");
                }
                iccProfileSrc = ColorUtil.unescapeString(iccProfileSrc);
                String colorName = ColorUtil.unescapeString(args[5].trim());
                if (foUserAgent != null && iccProfileSrc != null) {
                    RenderingIntent renderingIntent = RenderingIntent.AUTO;
                    colorSpace = (ICC_ColorSpace)foUserAgent.getColorSpaceCache().get(iccProfileName, iccProfileSrc, renderingIntent);
                }
                if (colorSpace != null) {
                    ICC_Profile profile = colorSpace.getProfile();
                    if (NamedColorProfileParser.isNamedColorProfile(profile)) {
                        NamedColorProfileParser parser = new NamedColorProfileParser();
                        NamedColorProfile ncp = parser.parseProfile(profile, iccProfileName, iccProfileSrc);
                        NamedColorSpace ncs = ncp.getNamedColor(colorName);
                        if (ncs != null) {
                            parsedColor = new ColorWithFallback(ncs, new float[]{1.0f}, 1.0f, null, sRGB);
                        }
                        log.warn("Color '" + colorName + "' does not exist in named color profile: " + iccProfileSrc);
                        parsedColor = sRGB;
                    }
                    log.warn("ICC profile is no named color profile: " + iccProfileSrc);
                    parsedColor = sRGB;
                }
                log.warn("Color profile '" + iccProfileSrc + "' not found. Using sRGB replacement values.");
                parsedColor = sRGB;
            }
            catch (IOException ioe) {
                throw new PropertyException(ioe);
            }
            catch (RuntimeException re) {
                throw new PropertyException(re);
            }
        } else {
            throw new PropertyException("Unknown color format: " + value + ". Must be fop-rgb-named-color(r,g,b,NCNAME,src,color-name)");
        }
        return parsedColor;
    }

    private static Color parseAsCIELabColor(FOUserAgent foUserAgent, String value) throws PropertyException {
        ColorWithFallback parsedColor;
        int poss = value.indexOf("(");
        int pose = value.indexOf(")");
        if (poss != -1 && pose != -1) {
            try {
                String[] args = value.substring(poss + 1, pose).split(",");
                if (args.length != 6) {
                    throw new PropertyException("cie-lab-color() function must have 6 arguments");
                }
                float red = ColorUtil.parseComponent255(args[0], value);
                float green = ColorUtil.parseComponent255(args[1], value);
                float blue = ColorUtil.parseComponent255(args[2], value);
                Color sRGB = new Color(red, green, blue);
                float l = ColorUtil.parseComponent(args[3], 0.0f, 100.0f, value);
                float a = ColorUtil.parseComponent(args[4], -127.0f, 127.0f, value);
                float b = ColorUtil.parseComponent(args[5], -127.0f, 127.0f, value);
                CIELabColorSpace cs = ColorSpaces.getCIELabColorSpaceD50();
                Color labColor = cs.toColor(l, a, b, 1.0f);
                parsedColor = new ColorWithFallback(labColor, sRGB);
            }
            catch (RuntimeException re) {
                throw new PropertyException(re);
            }
        } else {
            throw new PropertyException("Unknown color format: " + value + ". Must be cie-lab-color(r,g,b,Lightness,a-value,b-value)");
        }
        return parsedColor;
    }

    private static String unescapeString(String iccProfileSrc) {
        if (iccProfileSrc.startsWith("\"") || iccProfileSrc.startsWith("'")) {
            iccProfileSrc = iccProfileSrc.substring(1);
        }
        if (iccProfileSrc.endsWith("\"") || iccProfileSrc.endsWith("'")) {
            iccProfileSrc = iccProfileSrc.substring(0, iccProfileSrc.length() - 1);
        }
        return iccProfileSrc;
    }

    private static Color parseAsCMYK(String value) throws PropertyException {
        ColorWithAlternatives parsedColor;
        int poss = value.indexOf("(");
        int pose = value.indexOf(")");
        if (poss != -1 && pose != -1) {
            value = value.substring(poss + 1, pose);
            String[] args = value.split(",");
            try {
                if (args.length != 4) {
                    throw new PropertyException("Invalid number of arguments: cmyk(" + value + ")");
                }
                float cyan = ColorUtil.parseComponent1(args[0], value);
                float magenta = ColorUtil.parseComponent1(args[1], value);
                float yellow = ColorUtil.parseComponent1(args[2], value);
                float black = ColorUtil.parseComponent1(args[3], value);
                float[] comps = new float[]{cyan, magenta, yellow, black};
                Color cmykColor = DeviceCMYKColorSpace.createCMYKColor(comps);
                float[] rgbComps = cmykColor.getRGBColorComponents(null);
                parsedColor = new ColorWithAlternatives(rgbComps[0], rgbComps[1], rgbComps[2], new Color[]{cmykColor});
            }
            catch (RuntimeException re) {
                throw new PropertyException(re);
            }
        } else {
            throw new PropertyException("Unknown color format: " + value + ". Must be cmyk(c,m,y,k)");
        }
        return parsedColor;
    }

    private static Color parseAsOCA(String value) throws PropertyException {
        int poss = value.indexOf("(");
        int pose = value.indexOf(")");
        if (poss != -1 && pose != -1) {
            OCAColor.OCAColorValue colorValue;
            if ((value = value.substring(poss + 1, pose)).equals("blue")) {
                colorValue = OCAColor.OCAColorValue.BLUE;
            } else if (value.equals("red")) {
                colorValue = OCAColor.OCAColorValue.RED;
            } else if (value.equals("magenta")) {
                colorValue = OCAColor.OCAColorValue.MAGENTA;
            } else if (value.equals("green")) {
                colorValue = OCAColor.OCAColorValue.GREEN;
            } else if (value.equals("cyan")) {
                colorValue = OCAColor.OCAColorValue.CYAN;
            } else if (value.equals("yellow")) {
                colorValue = OCAColor.OCAColorValue.YELLOW;
            } else if (value.equals("black")) {
                colorValue = OCAColor.OCAColorValue.BLACK;
            } else if (value.equals("brown")) {
                colorValue = OCAColor.OCAColorValue.BROWN;
            } else if (value.equals("medium-color")) {
                colorValue = OCAColor.OCAColorValue.MEDIUM_COLOR;
            } else if (value.equals("device-default")) {
                colorValue = OCAColor.OCAColorValue.DEVICE_DEFAULT;
            } else {
                throw new PropertyException("Unknwon OCA color: " + value);
            }
            return new OCAColor(colorValue);
        }
        throw new PropertyException("Unknown color format: " + value + ". Must be oca(color-name)");
    }

    public static String colorToString(Color color) {
        ColorSpace cs = color.getColorSpace();
        if (color instanceof ColorWithAlternatives) {
            return ColorUtil.toFunctionCall((ColorWithAlternatives)color);
        }
        if (cs != null && cs.getType() == 9) {
            StringBuffer sbuf = new StringBuffer(24);
            float[] cmyk = color.getColorComponents(null);
            sbuf.append("cmyk(").append(cmyk[0]).append(",").append(cmyk[1]).append(",").append(cmyk[2]).append(",").append(cmyk[3]).append(")");
            return sbuf.toString();
        }
        return ColorUtil.toRGBFunctionCall(color);
    }

    private static String toRGBFunctionCall(Color color) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('#');
        String s = Integer.toHexString(color.getRed());
        if (s.length() == 1) {
            sbuf.append('0');
        }
        sbuf.append(s);
        s = Integer.toHexString(color.getGreen());
        if (s.length() == 1) {
            sbuf.append('0');
        }
        sbuf.append(s);
        s = Integer.toHexString(color.getBlue());
        if (s.length() == 1) {
            sbuf.append('0');
        }
        sbuf.append(s);
        if (color.getAlpha() != 255) {
            s = Integer.toHexString(color.getAlpha());
            if (s.length() == 1) {
                sbuf.append('0');
            }
            sbuf.append(s);
        }
        return sbuf.toString();
    }

    private static Color getsRGBFallback(ColorWithAlternatives color) {
        Color fallbackColor;
        if (color instanceof ColorWithFallback) {
            fallbackColor = ((ColorWithFallback)color).getFallbackColor();
            if (!fallbackColor.getColorSpace().isCS_sRGB()) {
                fallbackColor = ColorUtil.toSRGBColor(fallbackColor);
            }
        } else {
            fallbackColor = ColorUtil.toSRGBColor(color);
        }
        return fallbackColor;
    }

    private static Color toSRGBColor(Color color) {
        ColorSpace sRGB = ColorSpace.getInstance(1000);
        float[] comps = color.getRGBColorComponents(null);
        float[] allComps = color.getComponents(null);
        float alpha = allComps[allComps.length - 1];
        return new Color(sRGB, comps, alpha);
    }

    private static String toFunctionCall(ColorWithAlternatives color) {
        String functionName;
        Color alt;
        ColorSpace cs = color.getColorSpace();
        if (cs.isCS_sRGB() && !color.hasAlternativeColors()) {
            return ColorUtil.toRGBFunctionCall(color);
        }
        if (cs instanceof CIELabColorSpace) {
            return ColorUtil.toCIELabFunctionCall(color);
        }
        Color specColor = color;
        if (color.hasAlternativeColors() && ColorSpaces.isDeviceColorSpace((alt = color.getAlternativeColors()[0]).getColorSpace())) {
            cs = alt.getColorSpace();
            specColor = alt;
        }
        ColorSpaceOrigin origin = ColorSpaces.getColorSpaceOrigin(cs);
        Color fallbackColor = ColorUtil.getsRGBFallback(color);
        float[] rgb = fallbackColor.getColorComponents(null);
        assert (rgb.length == 3);
        StringBuffer sb = new StringBuffer(40);
        sb.append("(");
        sb.append(rgb[0]).append(",");
        sb.append(rgb[1]).append(",");
        sb.append(rgb[2]).append(",");
        String profileName = origin.getProfileName();
        sb.append(profileName).append(",");
        if (origin.getProfileURI() != null) {
            sb.append("\"").append(origin.getProfileURI()).append("\"");
        }
        if (cs instanceof NamedColorSpace) {
            NamedColorSpace ncs = (NamedColorSpace)cs;
            functionName = SEPARATION_PSEUDO_PROFILE.equalsIgnoreCase(profileName) ? "fop-rgb-icc" : "fop-rgb-named-color";
            sb.append(",").append(ncs.getColorName());
        } else {
            float[] colorComponents;
            functionName = "fop-rgb-icc";
            for (float colorComponent : colorComponents = specColor.getColorComponents(null)) {
                sb.append(",");
                sb.append(colorComponent);
            }
        }
        sb.append(")");
        return functionName + sb;
    }

    private static String toCIELabFunctionCall(ColorWithAlternatives color) {
        Color fallbackColor = ColorUtil.getsRGBFallback(color);
        StringBuffer sb = new StringBuffer("cie-lab-color(");
        sb.append(fallbackColor.getRed()).append(',');
        sb.append(fallbackColor.getGreen()).append(',');
        sb.append(fallbackColor.getBlue());
        CIELabColorSpace cs = (CIELabColorSpace)color.getColorSpace();
        float[] lab = cs.toNativeComponents(color.getColorComponents(null));
        for (int i = 0; i < 3; ++i) {
            sb.append(',').append(lab[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    private static Color createColor(int r, int g, int b) {
        return new Color(r, g, b);
    }

    private static void initializeColorMap() {
        colorMap = Collections.synchronizedMap(new HashMap());
        colorMap.put("aliceblue", ColorUtil.createColor(240, 248, 255));
        colorMap.put("antiquewhite", ColorUtil.createColor(250, 235, 215));
        colorMap.put("aqua", ColorUtil.createColor(0, 255, 255));
        colorMap.put("aquamarine", ColorUtil.createColor(127, 255, 212));
        colorMap.put("azure", ColorUtil.createColor(240, 255, 255));
        colorMap.put("beige", ColorUtil.createColor(245, 245, 220));
        colorMap.put("bisque", ColorUtil.createColor(255, 228, 196));
        colorMap.put("black", ColorUtil.createColor(0, 0, 0));
        colorMap.put("blanchedalmond", ColorUtil.createColor(255, 235, 205));
        colorMap.put("blue", ColorUtil.createColor(0, 0, 255));
        colorMap.put("blueviolet", ColorUtil.createColor(138, 43, 226));
        colorMap.put("brown", ColorUtil.createColor(165, 42, 42));
        colorMap.put("burlywood", ColorUtil.createColor(222, 184, 135));
        colorMap.put("cadetblue", ColorUtil.createColor(95, 158, 160));
        colorMap.put("chartreuse", ColorUtil.createColor(127, 255, 0));
        colorMap.put("chocolate", ColorUtil.createColor(210, 105, 30));
        colorMap.put("coral", ColorUtil.createColor(255, 127, 80));
        colorMap.put("cornflowerblue", ColorUtil.createColor(100, 149, 237));
        colorMap.put("cornsilk", ColorUtil.createColor(255, 248, 220));
        colorMap.put("crimson", ColorUtil.createColor(220, 20, 60));
        colorMap.put("cyan", ColorUtil.createColor(0, 255, 255));
        colorMap.put("darkblue", ColorUtil.createColor(0, 0, 139));
        colorMap.put("darkcyan", ColorUtil.createColor(0, 139, 139));
        colorMap.put("darkgoldenrod", ColorUtil.createColor(184, 134, 11));
        colorMap.put("darkgray", ColorUtil.createColor(169, 169, 169));
        colorMap.put("darkgreen", ColorUtil.createColor(0, 100, 0));
        colorMap.put("darkgrey", ColorUtil.createColor(169, 169, 169));
        colorMap.put("darkkhaki", ColorUtil.createColor(189, 183, 107));
        colorMap.put("darkmagenta", ColorUtil.createColor(139, 0, 139));
        colorMap.put("darkolivegreen", ColorUtil.createColor(85, 107, 47));
        colorMap.put("darkorange", ColorUtil.createColor(255, 140, 0));
        colorMap.put("darkorchid", ColorUtil.createColor(153, 50, 204));
        colorMap.put("darkred", ColorUtil.createColor(139, 0, 0));
        colorMap.put("darksalmon", ColorUtil.createColor(233, 150, 122));
        colorMap.put("darkseagreen", ColorUtil.createColor(143, 188, 143));
        colorMap.put("darkslateblue", ColorUtil.createColor(72, 61, 139));
        colorMap.put("darkslategray", ColorUtil.createColor(47, 79, 79));
        colorMap.put("darkslategrey", ColorUtil.createColor(47, 79, 79));
        colorMap.put("darkturquoise", ColorUtil.createColor(0, 206, 209));
        colorMap.put("darkviolet", ColorUtil.createColor(148, 0, 211));
        colorMap.put("deeppink", ColorUtil.createColor(255, 20, 147));
        colorMap.put("deepskyblue", ColorUtil.createColor(0, 191, 255));
        colorMap.put("dimgray", ColorUtil.createColor(105, 105, 105));
        colorMap.put("dimgrey", ColorUtil.createColor(105, 105, 105));
        colorMap.put("dodgerblue", ColorUtil.createColor(30, 144, 255));
        colorMap.put("firebrick", ColorUtil.createColor(178, 34, 34));
        colorMap.put("floralwhite", ColorUtil.createColor(255, 250, 240));
        colorMap.put("forestgreen", ColorUtil.createColor(34, 139, 34));
        colorMap.put("fuchsia", ColorUtil.createColor(255, 0, 255));
        colorMap.put("gainsboro", ColorUtil.createColor(220, 220, 220));
        colorMap.put("ghostwhite", ColorUtil.createColor(248, 248, 255));
        colorMap.put("gold", ColorUtil.createColor(255, 215, 0));
        colorMap.put("goldenrod", ColorUtil.createColor(218, 165, 32));
        colorMap.put("gray", ColorUtil.createColor(128, 128, 128));
        colorMap.put("green", ColorUtil.createColor(0, 128, 0));
        colorMap.put("greenyellow", ColorUtil.createColor(173, 255, 47));
        colorMap.put("grey", ColorUtil.createColor(128, 128, 128));
        colorMap.put("honeydew", ColorUtil.createColor(240, 255, 240));
        colorMap.put("hotpink", ColorUtil.createColor(255, 105, 180));
        colorMap.put("indianred", ColorUtil.createColor(205, 92, 92));
        colorMap.put("indigo", ColorUtil.createColor(75, 0, 130));
        colorMap.put("ivory", ColorUtil.createColor(255, 255, 240));
        colorMap.put("khaki", ColorUtil.createColor(240, 230, 140));
        colorMap.put("lavender", ColorUtil.createColor(230, 230, 250));
        colorMap.put("lavenderblush", ColorUtil.createColor(255, 240, 245));
        colorMap.put("lawngreen", ColorUtil.createColor(124, 252, 0));
        colorMap.put("lemonchiffon", ColorUtil.createColor(255, 250, 205));
        colorMap.put("lightblue", ColorUtil.createColor(173, 216, 230));
        colorMap.put("lightcoral", ColorUtil.createColor(240, 128, 128));
        colorMap.put("lightcyan", ColorUtil.createColor(224, 255, 255));
        colorMap.put("lightgoldenrodyellow", ColorUtil.createColor(250, 250, 210));
        colorMap.put("lightgray", ColorUtil.createColor(211, 211, 211));
        colorMap.put("lightgreen", ColorUtil.createColor(144, 238, 144));
        colorMap.put("lightgrey", ColorUtil.createColor(211, 211, 211));
        colorMap.put("lightpink", ColorUtil.createColor(255, 182, 193));
        colorMap.put("lightsalmon", ColorUtil.createColor(255, 160, 122));
        colorMap.put("lightseagreen", ColorUtil.createColor(32, 178, 170));
        colorMap.put("lightskyblue", ColorUtil.createColor(135, 206, 250));
        colorMap.put("lightslategray", ColorUtil.createColor(119, 136, 153));
        colorMap.put("lightslategrey", ColorUtil.createColor(119, 136, 153));
        colorMap.put("lightsteelblue", ColorUtil.createColor(176, 196, 222));
        colorMap.put("lightyellow", ColorUtil.createColor(255, 255, 224));
        colorMap.put("lime", ColorUtil.createColor(0, 255, 0));
        colorMap.put("limegreen", ColorUtil.createColor(50, 205, 50));
        colorMap.put("linen", ColorUtil.createColor(250, 240, 230));
        colorMap.put("magenta", ColorUtil.createColor(255, 0, 255));
        colorMap.put("maroon", ColorUtil.createColor(128, 0, 0));
        colorMap.put("mediumaquamarine", ColorUtil.createColor(102, 205, 170));
        colorMap.put("mediumblue", ColorUtil.createColor(0, 0, 205));
        colorMap.put("mediumorchid", ColorUtil.createColor(186, 85, 211));
        colorMap.put("mediumpurple", ColorUtil.createColor(147, 112, 219));
        colorMap.put("mediumseagreen", ColorUtil.createColor(60, 179, 113));
        colorMap.put("mediumslateblue", ColorUtil.createColor(123, 104, 238));
        colorMap.put("mediumspringgreen", ColorUtil.createColor(0, 250, 154));
        colorMap.put("mediumturquoise", ColorUtil.createColor(72, 209, 204));
        colorMap.put("mediumvioletred", ColorUtil.createColor(199, 21, 133));
        colorMap.put("midnightblue", ColorUtil.createColor(25, 25, 112));
        colorMap.put("mintcream", ColorUtil.createColor(245, 255, 250));
        colorMap.put("mistyrose", ColorUtil.createColor(255, 228, 225));
        colorMap.put("moccasin", ColorUtil.createColor(255, 228, 181));
        colorMap.put("navajowhite", ColorUtil.createColor(255, 222, 173));
        colorMap.put("navy", ColorUtil.createColor(0, 0, 128));
        colorMap.put("oldlace", ColorUtil.createColor(253, 245, 230));
        colorMap.put("olive", ColorUtil.createColor(128, 128, 0));
        colorMap.put("olivedrab", ColorUtil.createColor(107, 142, 35));
        colorMap.put("orange", ColorUtil.createColor(255, 165, 0));
        colorMap.put("orangered", ColorUtil.createColor(255, 69, 0));
        colorMap.put("orchid", ColorUtil.createColor(218, 112, 214));
        colorMap.put("palegoldenrod", ColorUtil.createColor(238, 232, 170));
        colorMap.put("palegreen", ColorUtil.createColor(152, 251, 152));
        colorMap.put("paleturquoise", ColorUtil.createColor(175, 238, 238));
        colorMap.put("palevioletred", ColorUtil.createColor(219, 112, 147));
        colorMap.put("papayawhip", ColorUtil.createColor(255, 239, 213));
        colorMap.put("peachpuff", ColorUtil.createColor(255, 218, 185));
        colorMap.put("peru", ColorUtil.createColor(205, 133, 63));
        colorMap.put("pink", ColorUtil.createColor(255, 192, 203));
        colorMap.put("plum ", ColorUtil.createColor(221, 160, 221));
        colorMap.put("plum", ColorUtil.createColor(221, 160, 221));
        colorMap.put("powderblue", ColorUtil.createColor(176, 224, 230));
        colorMap.put("purple", ColorUtil.createColor(128, 0, 128));
        colorMap.put("red", ColorUtil.createColor(255, 0, 0));
        colorMap.put("rosybrown", ColorUtil.createColor(188, 143, 143));
        colorMap.put("royalblue", ColorUtil.createColor(65, 105, 225));
        colorMap.put("saddlebrown", ColorUtil.createColor(139, 69, 19));
        colorMap.put("salmon", ColorUtil.createColor(250, 128, 114));
        colorMap.put("sandybrown", ColorUtil.createColor(244, 164, 96));
        colorMap.put("seagreen", ColorUtil.createColor(46, 139, 87));
        colorMap.put("seashell", ColorUtil.createColor(255, 245, 238));
        colorMap.put("sienna", ColorUtil.createColor(160, 82, 45));
        colorMap.put("silver", ColorUtil.createColor(192, 192, 192));
        colorMap.put("skyblue", ColorUtil.createColor(135, 206, 235));
        colorMap.put("slateblue", ColorUtil.createColor(106, 90, 205));
        colorMap.put("slategray", ColorUtil.createColor(112, 128, 144));
        colorMap.put("slategrey", ColorUtil.createColor(112, 128, 144));
        colorMap.put("snow", ColorUtil.createColor(255, 250, 250));
        colorMap.put("springgreen", ColorUtil.createColor(0, 255, 127));
        colorMap.put("steelblue", ColorUtil.createColor(70, 130, 180));
        colorMap.put("tan", ColorUtil.createColor(210, 180, 140));
        colorMap.put("teal", ColorUtil.createColor(0, 128, 128));
        colorMap.put("thistle", ColorUtil.createColor(216, 191, 216));
        colorMap.put("tomato", ColorUtil.createColor(255, 99, 71));
        colorMap.put("turquoise", ColorUtil.createColor(64, 224, 208));
        colorMap.put("violet", ColorUtil.createColor(238, 130, 238));
        colorMap.put("wheat", ColorUtil.createColor(245, 222, 179));
        colorMap.put("white", ColorUtil.createColor(255, 255, 255));
        colorMap.put("whitesmoke", ColorUtil.createColor(245, 245, 245));
        colorMap.put("yellow", ColorUtil.createColor(255, 255, 0));
        colorMap.put("yellowgreen", ColorUtil.createColor(154, 205, 50));
        colorMap.put("transparent", new ColorWithAlternatives(0, 0, 0, 0, null));
    }

    public static Color lightenColor(Color col, float factor) {
        return org.apache.xmlgraphics.java2d.color.ColorUtil.lightenColor(col, factor);
    }

    public static boolean isPseudoProfile(String colorProfileName) {
        return CMYK_PSEUDO_PROFILE.equalsIgnoreCase(colorProfileName) || SEPARATION_PSEUDO_PROFILE.equalsIgnoreCase(colorProfileName);
    }

    public static boolean isGray(Color col) {
        return org.apache.xmlgraphics.java2d.color.ColorUtil.isGray(col);
    }

    public static Color toCMYKGrayColor(float black) {
        return org.apache.xmlgraphics.java2d.color.ColorUtil.toCMYKGrayColor(black);
    }

    static {
        log = LogFactory.getLog(ColorUtil.class);
        ColorUtil.initializeColorMap();
    }
}

