/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.html5;

import java.awt.geom.Line2D;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.html5.Html5Drawer;

public class DriverLineHtml5
implements UDriver<ULine, Html5Drawer> {
    private final ClipContainer clipContainer;

    public DriverLineHtml5(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(ULine shape, double x, double y, ColorMapper mapper, UParam param, Html5Drawer html) {
        double x2 = x + shape.getDX();
        double y2 = y + shape.getDY();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Line2D.Double line = clip.getClippedLine(new Line2D.Double(x, y, x2, y2));
            if (line == null) {
                return;
            }
            x = line.x1;
            y = line.y1;
            x2 = line.x2;
            y2 = line.y2;
        }
        String color = param.getColor() == null ? null : param.getColor().toRGB(mapper);
        html.setStrokeColor(color);
        html.htmlLine(x, y, x2, y2, 0.0);
    }
}

