/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.utils.LineLocation;

public class VariableManager {
    private final TMemory memory;
    private final TContext context;
    private final LineLocation location;

    public VariableManager(TContext context, TMemory memory, LineLocation location) {
        this.memory = memory;
        this.context = context;
        this.location = location;
    }

    public int replaceVariables(String str, int i, StringBuilder result) throws EaterException, EaterExceptionLocated {
        String presentVariable = this.getVarnameAt(str, i);
        if (result.toString().endsWith("##")) {
            result.setLength(result.length() - 2);
        }
        TValue value = this.memory.getVariable(presentVariable);
        i += presentVariable.length() - 1;
        if (value.isJson()) {
            if (value.toJson().isString()) {
                result.append(value.toJson().asString());
            } else if (value.toJson().isNumber()) {
                result.append(value.toJson().toString());
            } else {
                JsonObject jsonValue = (JsonObject)value.toJson();
                ++i;
                i = this.replaceJson(jsonValue, str, i, result) - 1;
            }
        } else {
            result.append(value.toString());
        }
        if (i + 2 < str.length() && str.charAt(i + 1) == '#' && str.charAt(i + 2) == '#') {
            i += 2;
        }
        return i;
    }

    private int replaceJson(JsonValue jsonValue, String str, int i, StringBuilder result) throws EaterException, EaterExceptionLocated {
        while (i < str.length()) {
            char n = str.charAt(i);
            if (n == '.') {
                ++i;
                StringBuilder fieldName = new StringBuilder();
                while (i < str.length() && Character.isJavaIdentifierPart(str.charAt(i))) {
                    fieldName.append(str.charAt(i));
                    ++i;
                }
                jsonValue = ((JsonObject)jsonValue).get(fieldName.toString());
                continue;
            }
            if (n != '[') break;
            ++i;
            StringBuilder inBracket = new StringBuilder();
            int level = 0;
            while (true) {
                if (str.charAt(i) == '[') {
                    ++level;
                }
                if (str.charAt(i) == ']') {
                    if (level == 0) break;
                    --level;
                }
                inBracket.append(str.charAt(i));
                ++i;
            }
            String nbString = this.context.applyFunctionsAndVariables(this.memory, this.location, inBracket.toString());
            if (jsonValue instanceof JsonArray) {
                int nb = Integer.parseInt(nbString);
                jsonValue = ((JsonArray)jsonValue).get(nb);
            } else if (jsonValue instanceof JsonObject) {
                jsonValue = ((JsonObject)jsonValue).get(nbString);
            } else {
                throw EaterException.unlocated("Major parsing error");
            }
            if (jsonValue == null) {
                throw EaterException.unlocated("Data parsing error");
            }
            ++i;
        }
        if (jsonValue != null) {
            if (jsonValue.isString()) {
                result.append(jsonValue.asString());
            } else {
                result.append(jsonValue.toString());
            }
        }
        return i;
    }

    public String getVarnameAt(String s, int pos) {
        if (pos > 0 && TLineType.isLetterOrUnderscoreOrDigit(s.charAt(pos - 1)) && !VariableManager.justAfterBackslashN(s, pos)) {
            return null;
        }
        String varname = this.memory.variablesNames3().getLonguestMatchStartingIn(s.substring(pos));
        if (varname.length() == 0) {
            return null;
        }
        if (pos + varname.length() == s.length() || !TLineType.isLetterOrUnderscoreOrDigit(s.charAt(pos + varname.length()))) {
            return varname;
        }
        return null;
    }

    public static boolean justAfterBackslashN(String s, int pos) {
        return pos > 1 && s.charAt(pos - 2) == '\\' && s.charAt(pos - 1) == 'n';
    }
}

