/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.mindmap.Branch;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class MindMap
implements UDrawable {
    private final Branch regular = new Branch();
    private final Branch reverse = new Branch();
    private final ISkinParam skinParam;
    private int multiplier = 0;

    public MindMap(ISkinParam skinParam) {
        this.skinParam = skinParam;
    }

    private void computeFinger() {
        if (!this.reverse.hasFinger() && !this.regular.hasFinger()) {
            if (this.reverse.hasChildren()) {
                this.reverse.initFinger(this.skinParam, false);
            }
            if (!this.reverse.hasFinger() || this.regular.hasChildren()) {
                this.regular.initFinger(this.skinParam, true);
            }
            if (this.reverse.hasFinger() && this.regular.hasFinger()) {
                this.reverse.doNotDrawFirstPhalanx();
            }
        }
    }

    XDimension2D calculateDimension(StringBounder stringBounder) {
        this.computeFinger();
        double y1 = this.regular.getHalfThickness(stringBounder);
        double y2 = this.reverse.getHalfThickness(stringBounder);
        double y = Math.max(y1, y2);
        double width = this.reverse.getX12(stringBounder) + this.regular.getX12(stringBounder);
        double height = y + Math.max(this.reverse.getHalfThickness(stringBounder), this.regular.getHalfThickness(stringBounder));
        if (this.skinParam.getRankdir() == Rankdir.TOP_TO_BOTTOM) {
            return new XDimension2D(height, width);
        }
        return new XDimension2D(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        if (!this.reverse.hasRoot() && !this.regular.hasRoot()) {
            return;
        }
        this.computeFinger();
        StringBounder stringBounder = ug.getStringBounder();
        double y1 = this.regular.getHalfThickness(stringBounder);
        double y2 = this.reverse.getHalfThickness(stringBounder);
        double y = Math.max(y1, y2);
        double x = this.reverse.getX12(stringBounder);
        ug = this.skinParam.getRankdir() == Rankdir.TOP_TO_BOTTOM ? ug.apply(new UTranslate(y, x)) : ug.apply(new UTranslate(x, y));
        this.regular.drawU(ug);
        this.reverse.drawU(ug);
    }

    CommandExecutionResult addIdeaInternal(String stereotype, HColor backColor, int level, Display label, IdeaShape shape, boolean direction) {
        try {
            if (!this.reverse.hasRoot() && !this.regular.hasRoot()) {
                level = 0;
            }
            if (level == 0) {
                this.regular.initRoot(this.skinParam.getCurrentStyleBuilder(), backColor, label, shape, stereotype);
                this.reverse.initRoot(this.skinParam.getCurrentStyleBuilder(), backColor, label, shape, stereotype);
                return CommandExecutionResult.ok();
            }
            if (this.multiplier == 0) {
                this.multiplier = level;
            }
            assert (this.multiplier > 0);
            if (level % this.multiplier != 0) {
                return CommandExecutionResult.error("Bad indentation");
            }
            level /= this.multiplier;
            if (!direction) {
                return this.reverse.add(this.skinParam.getCurrentStyleBuilder(), backColor, level, label, shape, stereotype);
            }
            return this.regular.add(this.skinParam.getCurrentStyleBuilder(), backColor, level, label, shape, stereotype);
        }
        catch (NoStyleAvailableException e) {
            return CommandExecutionResult.error("General failure: no style available.");
        }
    }

    boolean isFull(int level) {
        return level == 0 && this.regular.hasRoot();
    }
}

