/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.io.IOException;
import net.sourceforge.plantuml.webp.BoolDecoder;
import net.sourceforge.plantuml.webp.DeltaQ;
import net.sourceforge.plantuml.webp.SegmentQuant;

public class SegmentQuants {
    private int qIndex;
    private SegmentQuant[] segQuants = new SegmentQuant[4];

    private static DeltaQ get_delta_q(BoolDecoder bc, int prev) throws IOException {
        DeltaQ ret = new DeltaQ();
        ret.v = 0;
        ret.update = false;
        if (bc.readBit() > 0) {
            ret.v = bc.readLiteral(4);
            if (bc.readBit() > 0) {
                ret.v = -ret.v;
            }
        }
        if (ret.v != prev) {
            ret.update = true;
        }
        return ret;
    }

    public SegmentQuants() {
        for (int x = 0; x < 4; ++x) {
            this.segQuants[x] = new SegmentQuant();
        }
    }

    public int getqIndex() {
        return this.qIndex;
    }

    public SegmentQuant[] getSegQuants() {
        return this.segQuants;
    }

    public void parse(BoolDecoder bc, boolean segmentation_enabled, boolean mb_segement_abs_delta) throws IOException {
        this.qIndex = bc.readLiteral(7);
        boolean q_update = false;
        DeltaQ v = SegmentQuants.get_delta_q(bc, 0);
        int y1dc_delta_q = v.v;
        q_update = q_update || v.update;
        v = SegmentQuants.get_delta_q(bc, 0);
        int y2dc_delta_q = v.v;
        q_update = q_update || v.update;
        v = SegmentQuants.get_delta_q(bc, 0);
        int y2ac_delta_q = v.v;
        q_update = q_update || v.update;
        v = SegmentQuants.get_delta_q(bc, 0);
        int uvdc_delta_q = v.v;
        q_update = q_update || v.update;
        v = SegmentQuants.get_delta_q(bc, 0);
        int uvac_delta_q = v.v;
        q_update = q_update || v.update;
        for (SegmentQuant s : this.segQuants) {
            if (!segmentation_enabled) {
                s.setQindex(this.qIndex);
            } else if (!mb_segement_abs_delta) {
                s.setQindex(s.getQindex() + this.qIndex);
            }
            s.setY1dc(y1dc_delta_q);
            s.setY2dc(y2dc_delta_q);
            s.setY2ac_delta_q(y2ac_delta_q);
            s.setUvdc_delta_q(uvdc_delta_q);
            s.setUvac_delta_q(uvac_delta_q);
        }
    }

    public void setSegQuants(SegmentQuant[] segQuants) {
        this.segQuants = segQuants;
    }
}

