/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.iterator;

import java.util.List;
import net.sourceforge.plantuml.tim.EaterElseIf;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.EaterIf;
import net.sourceforge.plantuml.tim.EaterIfdef;
import net.sourceforge.plantuml.tim.EaterIfndef;
import net.sourceforge.plantuml.tim.ExecutionContextIf;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.iterator.AbstractCodeIterator;
import net.sourceforge.plantuml.tim.iterator.CodeIterator;
import net.sourceforge.plantuml.utils.StringLocated;

public class CodeIteratorIf
extends AbstractCodeIterator {
    private final TContext context;
    private final TMemory memory;
    private final List<StringLocated> logs;

    public CodeIteratorIf(CodeIterator source, TContext context, TMemory memory, List<StringLocated> logs) {
        super(source);
        this.context = context;
        this.memory = memory;
        this.logs = logs;
    }

    @Override
    public StringLocated peek() throws EaterException, EaterExceptionLocated {
        StringLocated result;
        while (true) {
            if ((result = this.source.peek()) == null) {
                return null;
            }
            if (result.getType() == TLineType.IF) {
                this.logs.add(result);
                this.executeIf(this.context, this.memory, result.getTrimmed());
                this.next();
                continue;
            }
            if (result.getType() == TLineType.IFDEF) {
                this.logs.add(result);
                this.executeIfdef(this.context, this.memory, result.getTrimmed());
                this.next();
                continue;
            }
            if (result.getType() == TLineType.IFNDEF) {
                this.logs.add(result);
                this.executeIfndef(this.context, this.memory, result.getTrimmed());
                this.next();
                continue;
            }
            if (result.getType() == TLineType.ELSE) {
                this.logs.add(result);
                this.executeElse(this.context, this.memory, result.getTrimmed());
                this.next();
                continue;
            }
            if (result.getType() == TLineType.ELSEIF) {
                this.logs.add(result);
                this.executeElseIf(this.context, this.memory, result.getTrimmed());
                this.next();
                continue;
            }
            if (result.getType() == TLineType.ENDIF) {
                this.logs.add(result);
                this.executeEndif(this.context, this.memory, result.getTrimmed());
                this.next();
                continue;
            }
            if (this.memory.peekIf() == null || this.memory.areAllIfOk(this.context, this.memory)) break;
            this.logs.add(result);
            this.next();
        }
        return result;
    }

    private void executeIf(TContext context, TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        EaterIf condition = new EaterIf(s);
        condition.analyze(context, memory);
        boolean isTrue = condition.isTrue();
        memory.addIf(ExecutionContextIf.fromValue(isTrue));
    }

    private void executeElseIf(TContext context, TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        ExecutionContextIf poll = memory.peekIf();
        if (poll == null) {
            throw EaterException.located("No if related to this else");
        }
        poll.enteringElseIf();
        if (!poll.hasBeenBurn()) {
            EaterElseIf condition = new EaterElseIf(s);
            condition.analyze(context, memory);
            boolean isTrue = condition.isTrue();
            if (isTrue) {
                poll.nowInSomeElseIf();
            }
        }
    }

    private void executeIfdef(TContext context, TMemory memory, StringLocated s) throws EaterException {
        EaterIfdef condition = new EaterIfdef(s);
        condition.analyze(context, memory);
        boolean isTrue = condition.isTrue(context, memory);
        memory.addIf(ExecutionContextIf.fromValue(isTrue));
    }

    private void executeIfndef(TContext context, TMemory memory, StringLocated s) throws EaterException {
        EaterIfndef condition = new EaterIfndef(s);
        condition.analyze(context, memory);
        boolean isTrue = condition.isTrue(context, memory);
        memory.addIf(ExecutionContextIf.fromValue(isTrue));
    }

    private void executeElse(TContext context, TMemory memory, StringLocated s) throws EaterException {
        ExecutionContextIf poll = memory.peekIf();
        if (poll == null) {
            throw EaterException.located("No if related to this else");
        }
        poll.nowInElse();
    }

    private void executeEndif(TContext context, TMemory memory, StringLocated s) throws EaterException {
        ExecutionContextIf poll = memory.pollIf();
        if (poll == null) {
            throw EaterException.located("No if related to this endif");
        }
    }
}

