/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.UrlMode;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.legacy.CreoleParser;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockSprited;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueNull;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.StringLocated;

public class Display
implements Iterable<CharSequence> {
    private final List<CharSequence> displayData;
    private final HorizontalAlignment naturalHorizontalAlignment;
    private final boolean isNull;
    private final CreoleMode defaultCreoleMode;
    private final boolean showStereotype;
    public static final Display NULL = new Display(true, null, null, true, CreoleMode.FULL);
    public static final Pattern2 patternStereotype = MyPattern.cmpile("^(.*?)(?:\\<\\<\\s*(.*)\\s*\\>\\>)\\s*$");

    public boolean equalsLike(Display other) {
        return this.displayData.equals(other.displayData);
    }

    public boolean showStereotype() {
        return this.showStereotype;
    }

    public Display withoutStereotypeIfNeeded(Style usedStyle) {
        if (this == NULL) {
            return NULL;
        }
        Value showStereotype = usedStyle.value(PName.ShowStereotype);
        if (showStereotype instanceof ValueNull || showStereotype.asBoolean()) {
            return this;
        }
        return new Display(false, this, this.defaultCreoleMode);
    }

    public Stereotype getStereotypeIfAny() {
        for (CharSequence cs : this.displayData) {
            if (!(cs instanceof Stereotype)) continue;
            return (Stereotype)cs;
        }
        return null;
    }

    public Display replaceBackslashT() {
        Display result = new Display(this.showStereotype, this, this.defaultCreoleMode);
        for (int i = 0; i < result.displayData.size(); ++i) {
            CharSequence s = this.displayData.get(i);
            if (!s.toString().contains("\\t")) continue;
            result.displayData.set(i, s.toString().replace("\\t", "\t"));
        }
        return result;
    }

    public Display replace(String src, String dest) {
        ArrayList<CharSequence> newDisplay = new ArrayList<CharSequence>();
        for (CharSequence cs : this.displayData) {
            if (cs.toString().contains(src)) {
                cs = cs.toString().replace(src, dest);
            }
            newDisplay.add(cs);
        }
        return new Display(this.showStereotype, newDisplay, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public boolean isWhite() {
        return this.displayData == null || this.displayData.size() == 0 || this.displayData.size() == 1 && this.displayData.get(0).toString().matches("\\s*");
    }

    public static Display empty() {
        return new Display(true, null, false, CreoleMode.FULL);
    }

    public static Display create(CharSequence ... s) {
        return Display.create(Arrays.asList(s));
    }

    public static Display createFoo(List<StringLocated> data) throws NoSuchColorException {
        ArrayList<String> tmp = new ArrayList<String>();
        for (StringLocated s : data) {
            tmp.add(s.getString());
        }
        Display result = Display.create(tmp);
        CreoleParser.checkColor(result);
        return result;
    }

    public static Display create(Collection<? extends CharSequence> other) {
        return new Display(true, other, null, false, CreoleMode.FULL);
    }

    public static Display getWithNewlines(Code s) {
        return Display.getWithNewlines(s.getName());
    }

    public static Display getWithNewlines2(String s) throws NoSuchColorException {
        Display result = Display.getWithNewlines(s);
        CreoleParser.checkColor(result);
        return result;
    }

    public static Display getWithNewlines(String s) {
        if (s == null) {
            return NULL;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        HorizontalAlignment naturalHorizontalAlignment = null;
        boolean rawMode = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String sub = s.substring(i);
            if (sub.startsWith("<math>") || sub.startsWith("<latex>") || sub.startsWith("[[")) {
                rawMode = true;
            } else if (sub.startsWith("</math>") || sub.startsWith("</latex>") || sub.startsWith("]]")) {
                rawMode = false;
            }
            if (!rawMode && c == '\\' && i < s.length() - 1) {
                char c2 = s.charAt(i + 1);
                ++i;
                if (c2 == 'n' || c2 == 'r' || c2 == 'l') {
                    if (c2 == 'r') {
                        naturalHorizontalAlignment = HorizontalAlignment.RIGHT;
                    } else if (c2 == 'l') {
                        naturalHorizontalAlignment = HorizontalAlignment.LEFT;
                    }
                    result.add(current.toString());
                    current.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    current.append('\t');
                    continue;
                }
                if (c2 == '\\') {
                    current.append(c2);
                    continue;
                }
                current.append(c);
                current.append(c2);
                continue;
            }
            if (c == BackSlash.hiddenNewLine()) {
                result.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        result.add(current.toString());
        return new Display(true, result, naturalHorizontalAlignment, false, CreoleMode.FULL);
    }

    private Display(boolean showStereotype, Display other, CreoleMode mode) {
        this(showStereotype, other.naturalHorizontalAlignment, other.isNull, mode);
        this.displayData.addAll(other.displayData);
    }

    private Display(boolean showStereotype, HorizontalAlignment naturalHorizontalAlignment, boolean isNull, CreoleMode defaultCreoleMode) {
        this.showStereotype = showStereotype;
        this.defaultCreoleMode = defaultCreoleMode;
        this.isNull = isNull;
        this.displayData = isNull ? null : new ArrayList();
        this.naturalHorizontalAlignment = isNull ? null : naturalHorizontalAlignment;
    }

    private Display(boolean showStereotype, Collection<? extends CharSequence> other, HorizontalAlignment naturalHorizontalAlignment, boolean isNull, CreoleMode defaultCreoleMode) {
        this(showStereotype, naturalHorizontalAlignment, isNull, defaultCreoleMode);
        if (!isNull) {
            this.displayData.addAll(other);
        }
    }

    public Display manageGuillemet(boolean manageVisibilityModifier) {
        ArrayList<String> result = new ArrayList<String>();
        boolean first = true;
        for (CharSequence line : this.displayData) {
            String lineString = line.toString();
            if (manageVisibilityModifier && first && VisibilityModifier.isVisibilityCharacter(line)) {
                lineString = lineString.substring(1).trim();
            }
            String withGuillement = Guillemet.GUILLEMET.manageGuillemet(lineString);
            result.add(withGuillement);
            first = false;
        }
        return new Display(this.showStereotype, result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display withPage(int page, int lastpage) {
        if (this.displayData == null) {
            return this;
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (CharSequence line : this.displayData) {
            line = line.toString().replace("%page%", "" + page);
            line = line.toString().replace("%lastpage%", "" + lastpage);
            result.add(line);
        }
        return new Display(this.showStereotype, result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display removeEndingStereotype() {
        Matcher2 m = patternStereotype.matcher(this.displayData.get(this.displayData.size() - 1));
        if (m.matches()) {
            ArrayList<CharSequence> result = new ArrayList<CharSequence>(this.displayData);
            result.set(result.size() - 1, m.group(1));
            return new Display(this.showStereotype, result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
        }
        return this;
    }

    public String getEndingStereotype() {
        Matcher2 m = patternStereotype.matcher(this.displayData.get(this.displayData.size() - 1));
        if (m.matches()) {
            return m.group(2);
        }
        return null;
    }

    public Display underlined() {
        ArrayList<String> result = new ArrayList<String>();
        for (CharSequence line : this.displayData) {
            result.add("<u>" + line);
        }
        return new Display(this.showStereotype, result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display underlinedName() {
        Pattern p = Pattern.compile("^([^:]+?)(\\s*:.+)$");
        ArrayList<String> result = new ArrayList<String>();
        for (CharSequence line : this.displayData) {
            if (result.size() == 0) {
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    result.add("<u>" + m.group(1) + "</u>" + m.group(2));
                    continue;
                }
                result.add("<u>" + line);
                continue;
            }
            result.add("<u>" + line);
        }
        return new Display(this.showStereotype, result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display withCreoleMode(CreoleMode mode) {
        if (this.isNull) {
            throw new IllegalArgumentException();
        }
        return new Display(this.showStereotype, this, mode);
    }

    public String toString() {
        if (this.isNull) {
            return "NULL";
        }
        return this.displayData.toString();
    }

    public Display addAll(Display other) {
        Display result = new Display(this.showStereotype, this, this.defaultCreoleMode);
        result.displayData.addAll(other.displayData);
        return result;
    }

    public Display addFirst(CharSequence s) {
        Display result = new Display(this.showStereotype, this, this.defaultCreoleMode);
        result.displayData.add(0, s);
        return result;
    }

    public Display add(CharSequence s) {
        Display result = new Display(this.showStereotype, this, this.defaultCreoleMode);
        result.displayData.add(s);
        return result;
    }

    public Display addGeneric(CharSequence s) {
        Display result = new Display(this.showStereotype, this, this.defaultCreoleMode);
        int size = this.displayData.size();
        if (size == 0) {
            result.displayData.add("<" + s + ">");
        } else {
            result.displayData.set(size - 1, this.displayData.get(size - 1) + "<" + s + ">");
        }
        return result;
    }

    public int size() {
        if (this.isNull) {
            return 0;
        }
        return this.displayData.size();
    }

    public CharSequence get(int i) {
        return this.displayData.get(i);
    }

    @Override
    public ListIterator<CharSequence> iterator() {
        return Collections.unmodifiableList(this.displayData).listIterator();
    }

    public Display subList(int i, int size) {
        return new Display(this.showStereotype, this.displayData.subList(i, size), this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public List<? extends CharSequence> asList() {
        return Collections.unmodifiableList(this.displayData);
    }

    public boolean hasUrl() {
        UrlBuilder urlBuilder = new UrlBuilder(null, UrlMode.ANYWHERE);
        for (CharSequence s : this) {
            if (urlBuilder.getUrl(s.toString()) == null) continue;
            return true;
        }
        return false;
    }

    public HorizontalAlignment getNaturalHorizontalAlignment() {
        return this.naturalHorizontalAlignment;
    }

    public List<Display> splitMultiline(Pattern2 separator) {
        ArrayList<Display> result = new ArrayList<Display>();
        Display pending = new Display(this.showStereotype, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
        result.add(pending);
        for (CharSequence line : this.displayData) {
            Matcher2 m = separator.matcher(line);
            if (m.find()) {
                CharSequence s1 = line.subSequence(0, m.start());
                pending.displayData.add(s1);
                CharSequence s2 = line.subSequence(m.end(), line.length());
                pending = new Display(this.showStereotype, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
                result.add(pending);
                pending.displayData.add(s2);
                continue;
            }
            pending.displayData.add(line);
        }
        return Collections.unmodifiableList(result);
    }

    public static boolean isNull(Display display) {
        return display == null || display.isNull;
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer) {
        return this.create7(fontConfiguration, horizontalAlignment, spriteContainer, CreoleMode.FULL);
    }

    public TextBlock create7(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, CreoleMode creoleMode) {
        return this.create0(fontConfiguration, horizontalAlignment, spriteContainer, LineBreakStrategy.NONE, creoleMode, null, null);
    }

    public TextBlock create8(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, CreoleMode modeSimpleLine, LineBreakStrategy maxMessageSize) {
        return this.create0(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, modeSimpleLine, null, null);
    }

    public TextBlock create9(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize) {
        return this.create0(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, this.defaultCreoleMode, null, null);
    }

    public TextBlock create0(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, CreoleMode creoleMode, UFont fontForStereotype, HColor htmlColorForStereotype) {
        return this.create0(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, creoleMode, fontForStereotype, htmlColorForStereotype, 0.0, 0.0);
    }

    public TextBlock create0(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, CreoleMode creoleMode, UFont fontForStereotype, HColor htmlColorForStereotype, double marginX1, double marginX2) {
        Objects.requireNonNull(maxMessageSize);
        if (this.getNaturalHorizontalAlignment() != null) {
            horizontalAlignment = this.getNaturalHorizontalAlignment();
        }
        FontConfiguration stereotypeConfiguration = fontConfiguration.forceFont(fontForStereotype, htmlColorForStereotype);
        if (this.size() > 0) {
            if (this.get(0) instanceof Stereotype) {
                return this.createStereotype(fontConfiguration, horizontalAlignment, spriteContainer, 0, fontForStereotype, htmlColorForStereotype, maxMessageSize, creoleMode, marginX1, marginX2);
            }
            if (this.get(this.size() - 1) instanceof Stereotype) {
                return this.createStereotype(fontConfiguration, horizontalAlignment, spriteContainer, this.size() - 1, fontForStereotype, htmlColorForStereotype, maxMessageSize, creoleMode, marginX1, marginX2);
            }
            if (this.get(0) instanceof MessageNumber) {
                return this.createMessageNumber(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, stereotypeConfiguration, marginX1, marginX2);
            }
        }
        return this.getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, creoleMode, stereotypeConfiguration, marginX1, marginX2);
    }

    private TextBlock createStereotype(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer, int position, UFont fontForStereotype, HColor htmlColorForStereotype, LineBreakStrategy maxMessageSize, CreoleMode creoleMode, double marginX1, double marginX2) {
        Stereotype stereotype = (Stereotype)this.get(position);
        TextBlock circledCharacter = null;
        circledCharacter = stereotype.isSpotted() ? new CircledCharacter(stereotype.getCharacter(), stereotype.getRadius(), stereotype.getCircledFont(), stereotype.getHtmlColor(), null, fontConfiguration.getColor()) : stereotype.getSprite(spriteContainer);
        FontConfiguration stereotypeConfiguration = fontConfiguration.forceFont(fontForStereotype, htmlColorForStereotype);
        TextBlock result = this.getCreole(fontConfiguration, horizontalAlignment, (ISkinSimple)spriteContainer, maxMessageSize, creoleMode, stereotypeConfiguration, marginX1, marginX2);
        if (circledCharacter != null) {
            return new TextBlockSprited(circledCharacter, result);
        }
        return result;
    }

    private TextBlock getCreole(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, CreoleMode creoleMode, FontConfiguration stereotypeConfiguration, double marginX1, double marginX2) {
        Sheet sheet = spriteContainer.sheet(fontConfiguration, horizontalAlignment, creoleMode, stereotypeConfiguration).createSheet(this);
        double padding = spriteContainer == null ? 0.0 : spriteContainer.getPadding();
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, maxMessageSize, padding, marginX1, marginX2);
        return new SheetBlock2(sheetBlock1, sheetBlock1, new UStroke(1.5));
    }

    private TextBlock createMessageNumber(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, FontConfiguration stereotypeConfiguration, double marginX1, double marginX2) {
        TextBlock tb1 = this.subList(0, 1).getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL, stereotypeConfiguration, marginX1, marginX2);
        tb1 = TextBlockUtils.withMargin(tb1, 0.0, 4.0, 0.0, 0.0);
        TextBlock tb2 = this.subList(1, this.size()).getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL, stereotypeConfiguration, marginX1, marginX2);
        return TextBlockUtils.mergeLR(tb1, tb2, VerticalAlignment.CENTER);
    }

    public boolean hasSeveralGuideLines() {
        return Display.hasSeveralGuideLines(this.displayData);
    }

    public static boolean hasSeveralGuideLines(String s) {
        List<String> splitted = Arrays.asList(s.split("\\\\n"));
        return Display.hasSeveralGuideLines(splitted);
    }

    private static boolean hasSeveralGuideLines(Collection<? extends CharSequence> all) {
        if (all.size() <= 1) {
            return false;
        }
        for (CharSequence charSequence : all) {
            String s = charSequence.toString();
            if (s.startsWith("< ")) {
                return true;
            }
            if (s.startsWith("> ")) {
                return true;
            }
            if (s.endsWith(" <")) {
                return true;
            }
            if (!s.endsWith(" >")) continue;
            return true;
        }
        return false;
    }
}

