/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileHeightFixedCentered
extends AbstractFtile {
    private final Ftile tile;
    private final double fixedHeight;

    public FtileHeightFixedCentered(Ftile tile, double fixedHeight) {
        super(tile.skinParam());
        this.tile = tile;
        this.fixedHeight = fixedHeight;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.singleton(this.tile);
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return this.tile.getOutLinkRendering();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        return this.tile.calculateDimension(stringBounder).translate(this.getTranslate(stringBounder)).fixedHeight(this.fixedHeight);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        FtileGeometry dim = this.tile.calculateDimension(stringBounder);
        if (((XDimension2D)dim).getHeight() > this.fixedHeight) {
            throw new IllegalStateException();
        }
        return UTranslate.dy((this.fixedHeight - ((XDimension2D)dim).getHeight()) / 2.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(this.getTranslate(ug.getStringBounder())).draw(this.tile);
    }
}

