/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.BlocLines;

public class NewpagedDiagram
extends AbstractPSystem {
    private final List<Diagram> diagrams = new ArrayList<Diagram>();

    public NewpagedDiagram(UmlSource source, AbstractPSystem diag1, AbstractPSystem diag2) {
        super(source);
        if (diag1 instanceof NewpagedDiagram) {
            throw new IllegalArgumentException();
        }
        if (diag2 instanceof NewpagedDiagram) {
            throw new IllegalArgumentException();
        }
        this.diagrams.add(diag1);
        this.diagrams.add(diag2);
    }

    public String toString() {
        return super.toString() + " SIZE=" + this.diagrams.size() + " " + this.diagrams;
    }

    public Diagram getLastDiagram() {
        return this.diagrams.get(this.diagrams.size() - 1);
    }

    @Override
    public CommandExecutionResult executeCommand(Command cmd, BlocLines lines) {
        int nb = this.diagrams.size();
        try {
            CommandExecutionResult tmp = cmd.execute(this.diagrams.get(nb - 1), lines);
            if (tmp.getNewDiagram() instanceof NewpagedDiagram) {
                NewpagedDiagram new1 = (NewpagedDiagram)tmp.getNewDiagram();
                if (new1.size() != 2) {
                    throw new IllegalStateException();
                }
                if (new1.diagrams.get(0) != this.diagrams.get(nb - 1)) {
                    throw new IllegalStateException();
                }
                this.diagrams.add(new1.diagrams.get(1));
                return tmp.withDiagram(this);
            }
            return tmp;
        }
        catch (NoSuchColorException e) {
            return CommandExecutionResult.badColor();
        }
    }

    private int size() {
        return this.diagrams.size();
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        return this.diagrams.get(num).exportDiagram(os, 0, fileFormat);
    }

    @Override
    public int getNbImages() {
        int nb = 0;
        for (Diagram d : this.diagrams) {
            nb += d.getNbImages();
        }
        return nb;
    }

    @Override
    public DiagramDescription getDescription() {
        StringBuilder sb = new StringBuilder();
        for (Diagram d : this.diagrams) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(d.getDescription());
        }
        return new DiagramDescription(sb.toString());
    }

    @Override
    public String getWarningOrError() {
        StringBuilder sb = new StringBuilder();
        for (Diagram d : this.diagrams) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (d.getWarningOrError() == null) continue;
            sb.append(d.getWarningOrError());
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    @Override
    public void makeDiagramReady() {
        super.makeDiagramReady();
        for (Diagram diagram : this.diagrams) {
            ((AbstractPSystem)diagram).makeDiagramReady();
        }
    }

    @Override
    public String checkFinalError() {
        for (Diagram p : this.getDiagrams()) {
            String check = ((AbstractPSystem)p).checkFinalError();
            if (check == null) continue;
            return check;
        }
        return super.checkFinalError();
    }

    public final List<Diagram> getDiagrams() {
        return Collections.unmodifiableList(this.diagrams);
    }
}

