/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.AffineTransform;
import java.util.Arrays;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.ugraphic.USegmentType;

public class USegment {
    private final double[] coord;
    private final USegmentType pathType;

    public USegment(double[] coord, USegmentType pathType) {
        this.coord = (double[])coord.clone();
        this.pathType = pathType;
    }

    public String toString() {
        return this.pathType.toString() + " " + Arrays.toString(this.coord);
    }

    public final double[] getCoord() {
        return this.coord;
    }

    public final USegmentType getSegmentType() {
        return this.pathType;
    }

    public USegment translate(double dx, double dy) {
        if (this.pathType == USegmentType.SEG_ARCTO) {
            return new USegment(new double[]{this.coord[0], this.coord[1], this.coord[2], this.coord[3], this.coord[4], this.coord[5] + dx, this.coord[6] + dy}, this.pathType);
        }
        if (this.coord.length != 2) {
            throw new UnsupportedOperationException();
        }
        XPoint2D p1 = new XPoint2D(this.coord[0] + dx, this.coord[1] + dy);
        return new USegment(new double[]{p1.getX(), p1.getY()}, this.pathType);
    }

    public USegment rotate(double theta) {
        if (this.coord.length != 2) {
            throw new UnsupportedOperationException();
        }
        XPoint2D p1 = new XPoint2D(this.coord[0], this.coord[1]);
        AffineTransform rotate = AffineTransform.getRotateInstance(theta);
        p1 = p1.transform(rotate);
        return new USegment(new double[]{p1.getX(), p1.getY()}, this.pathType);
    }

    public USegment affine(AffineTransform transform, double angle, double scale) {
        if (this.pathType == USegmentType.SEG_ARCTO) {
            XPoint2D p1 = new XPoint2D(this.coord[5], this.coord[6]);
            p1 = p1.transform(transform);
            double large_arc_flag = this.coord[3];
            double sweep_flag = this.coord[4];
            return new USegment(new double[]{this.coord[0] * scale, this.coord[1] * scale, this.coord[2] + angle, large_arc_flag, sweep_flag, p1.getX(), p1.getY()}, this.pathType);
        }
        if (this.coord.length != 2) {
            throw new UnsupportedOperationException();
        }
        XPoint2D p1 = new XPoint2D(this.coord[0], this.coord[1]);
        p1 = p1.transform(transform);
        return new USegment(new double[]{p1.getX(), p1.getY()}, this.pathType);
    }
}

