/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.AnnotatedBuilder;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.DisplayPositioned;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.DecorateEntityImage;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;

public class AnnotatedWorker {
    private final Annotated annotated;
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    private final AnnotatedBuilder builder;

    public AnnotatedWorker(Annotated annotated, ISkinParam skinParam, StringBounder stringBounder, AnnotatedBuilder builder) {
        this.annotated = annotated;
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
        this.builder = builder;
    }

    public TextBlockBackcolored addAdd(TextBlock result) {
        result = this.builder.decoreWithFrame(result);
        result = this.addLegend(result);
        result = this.addTitle(result);
        result = this.addCaption(result);
        result = this.builder.addHeaderAndFooter(result);
        return (TextBlockBackcolored)result;
    }

    public TextBlock addLegend(TextBlock original) {
        DisplayPositioned legend = this.annotated.getLegend();
        if (legend.isNull()) {
            return original;
        }
        return DecorateEntityImage.add(original, this.builder.getLegend(), legend.getHorizontalAlignment(), legend.getVerticalAlignment());
    }

    public TextBlock addTitle(TextBlock original) {
        DisplayPositioned title = (DisplayPositioned)this.annotated.getTitle();
        if (title.isNull()) {
            return original;
        }
        return DecorateEntityImage.addTop(original, this.builder.getTitle(), HorizontalAlignment.CENTER);
    }

    private TextBlock addCaption(TextBlock original) {
        DisplayPositioned caption = this.annotated.getCaption();
        if (caption.isNull()) {
            return original;
        }
        return DecorateEntityImage.addBottom(original, this.builder.getCaption(), HorizontalAlignment.CENTER);
    }
}

