/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace PostgreSql.Data.PgTypes
{
	[Serializable]
	public struct PgLine
	{
		#region Fields

		private PgPoint startPoint;
		private PgPoint	endPoint;

		#endregion

		#region Properties

		public PgPoint StartPoint
		{
			get { return startPoint; }
		}
		
		public PgPoint EndPoint
		{
			get { return endPoint; }
		}

		#endregion

		#region Constructors

		public PgLine(PgPoint startPoint, PgPoint endPoint)
		{
			this.startPoint = startPoint;
			this.endPoint	= endPoint;
		}

		public PgLine(double x1, double y1, double x2, double y2)
		{
			this.startPoint	= new PgPoint(x1, y1);
			this.endPoint	= new PgPoint(x2, y2);
		}

		#endregion

		#region Operators

		public static bool operator ==(PgLine left, PgLine right)
		{
			if (left.StartPoint == right.StartPoint && 
				left.EndPoint == right.EndPoint)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		public static bool operator !=(PgLine left, PgLine right)
		{
			if (left.StartPoint != right.StartPoint ||
				left.EndPoint != right.EndPoint)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		#endregion

		#region Overriden Methods

		public override string ToString()
		{
			System.Text.StringBuilder b = new System.Text.StringBuilder();
			b.AppendFormat("(({0},{1}),({2},{3}))", 
				this.startPoint.X	, this.startPoint.Y,
				this.endPoint.X		, this.endPoint.Y);

			return b.ToString();
		}

		public override int GetHashCode()
		{
			return base.GetHashCode();
		}

		public override bool Equals(object obj)
		{
			if (obj is PgLine)
			{
				return ((PgLine)obj) == this;
			}
			else
			{
				return false;
			}
		}

		#endregion

		#region Static Methods

		public static PgLine Parse(string s)
		{
			throw new NotSupportedException();
		}

		#endregion
	}
}
