/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentTermPositionVector;
import org.apache.lucene.index.SegmentTermVector;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;

class TermVectorsReader
implements Cloneable {
    private FieldInfos fieldInfos;
    private IndexInput tvx;
    private IndexInput tvd;
    private IndexInput tvf;
    private int size;
    private int tvdFormat;
    private int tvfFormat;

    TermVectorsReader(Directory d, String segment, FieldInfos fieldInfos) throws IOException {
        if (d.fileExists(segment + ".tvx")) {
            this.tvx = d.openInput(segment + ".tvx");
            this.checkValidFormat(this.tvx);
            this.tvd = d.openInput(segment + ".tvd");
            this.tvdFormat = this.checkValidFormat(this.tvd);
            this.tvf = d.openInput(segment + ".tvf");
            this.tvfFormat = this.checkValidFormat(this.tvf);
            this.size = (int)this.tvx.length() / 8;
        }
        this.fieldInfos = fieldInfos;
    }

    private int checkValidFormat(IndexInput in) throws IOException {
        int format = in.readInt();
        if (format > 2) {
            throw new IOException("Incompatible format version: " + format + " expected " + 2 + " or less");
        }
        return format;
    }

    void close() throws IOException {
        IOException keep;
        block12: {
            block11: {
                block10: {
                    keep = null;
                    if (this.tvx != null) {
                        try {
                            this.tvx.close();
                        }
                        catch (IOException e) {
                            if (keep != null) break block10;
                            keep = e;
                        }
                    }
                }
                if (this.tvd != null) {
                    try {
                        this.tvd.close();
                    }
                    catch (IOException e) {
                        if (keep != null) break block11;
                        keep = e;
                    }
                }
            }
            if (this.tvf != null) {
                try {
                    this.tvf.close();
                }
                catch (IOException e) {
                    if (keep != null) break block12;
                    keep = e;
                }
            }
        }
        if (keep != null) {
            throw (IOException)keep.fillInStackTrace();
        }
    }

    int size() {
        return this.size;
    }

    TermFreqVector get(int docNum, String field) throws IOException {
        int fieldNumber = this.fieldInfos.fieldNumber(field);
        SegmentTermVector result = null;
        if (this.tvx != null) {
            int i;
            this.tvx.seek((long)docNum * 8L + 4L);
            long position = this.tvx.readLong();
            this.tvd.seek(position);
            int fieldCount = this.tvd.readVInt();
            int number = 0;
            int found = -1;
            for (i = 0; i < fieldCount; ++i) {
                number = this.tvdFormat == 2 ? this.tvd.readVInt() : (number += this.tvd.readVInt());
                if (number != fieldNumber) continue;
                found = i;
            }
            if (found != -1) {
                position = 0L;
                for (i = 0; i <= found; ++i) {
                    position += this.tvd.readVLong();
                }
                result = this.readTermVector(field, position);
            }
        }
        return result;
    }

    TermFreqVector[] get(int docNum) throws IOException {
        SegmentTermVector[] result = null;
        if (this.tvx != null) {
            this.tvx.seek((long)docNum * 8L + 4L);
            long position = this.tvx.readLong();
            this.tvd.seek(position);
            int fieldCount = this.tvd.readVInt();
            if (fieldCount != 0) {
                int number = 0;
                String[] fields = new String[fieldCount];
                for (int i = 0; i < fieldCount; ++i) {
                    number = this.tvdFormat == 2 ? this.tvd.readVInt() : (number += this.tvd.readVInt());
                    fields[i] = this.fieldInfos.fieldName(number);
                }
                position = 0L;
                long[] tvfPointers = new long[fieldCount];
                for (int i = 0; i < fieldCount; ++i) {
                    tvfPointers[i] = position += this.tvd.readVLong();
                }
                result = this.readTermVectors(fields, tvfPointers);
            }
        }
        return result;
    }

    private SegmentTermVector[] readTermVectors(String[] fields, long[] tvfPointers) throws IOException {
        SegmentTermVector[] res = new SegmentTermVector[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            res[i] = this.readTermVector(fields[i], tvfPointers[i]);
        }
        return res;
    }

    private SegmentTermVector readTermVector(String field, long tvfPointer) throws IOException {
        boolean storeOffsets;
        boolean storePositions;
        this.tvf.seek(tvfPointer);
        int numTerms = this.tvf.readVInt();
        if (numTerms == 0) {
            return new SegmentTermVector(field, null, null);
        }
        if (this.tvfFormat == 2) {
            byte bits = this.tvf.readByte();
            storePositions = (bits & 1) != 0;
            storeOffsets = (bits & 2) != 0;
        } else {
            this.tvf.readVInt();
            storePositions = false;
            storeOffsets = false;
        }
        String[] terms = new String[numTerms];
        int[] termFreqs = new int[numTerms];
        Object positions = null;
        TermVectorOffsetInfo[][] offsets = null;
        if (storePositions) {
            positions = new int[numTerms][];
        }
        if (storeOffsets) {
            offsets = new TermVectorOffsetInfo[numTerms][];
        }
        int start = 0;
        int deltaLength = 0;
        int totalLength = 0;
        char[] buffer = new char[10];
        char[] previousBuffer = new char[]{};
        for (int i = 0; i < numTerms; ++i) {
            int j;
            int freq;
            start = this.tvf.readVInt();
            totalLength = start + (deltaLength = this.tvf.readVInt());
            if (buffer.length < totalLength) {
                buffer = null;
                buffer = new char[totalLength];
                if (start > 0) {
                    System.arraycopy(previousBuffer, 0, buffer, 0, start);
                }
            }
            this.tvf.readChars(buffer, start, deltaLength);
            terms[i] = new String(buffer, 0, totalLength);
            previousBuffer = buffer;
            termFreqs[i] = freq = this.tvf.readVInt();
            if (storePositions) {
                int[] pos = new int[freq];
                positions[i] = pos;
                int prevPosition = 0;
                for (j = 0; j < freq; ++j) {
                    pos[j] = prevPosition + this.tvf.readVInt();
                    prevPosition = pos[j];
                }
            }
            if (!storeOffsets) continue;
            TermVectorOffsetInfo[] offs = new TermVectorOffsetInfo[freq];
            offsets[i] = offs;
            int prevOffset = 0;
            for (j = 0; j < freq; ++j) {
                int startOffset = prevOffset + this.tvf.readVInt();
                int endOffset = startOffset + this.tvf.readVInt();
                offs[j] = new TermVectorOffsetInfo(startOffset, endOffset);
                prevOffset = endOffset;
            }
        }
        SegmentTermVector tv = storePositions || storeOffsets ? new SegmentTermPositionVector(field, terms, termFreqs, (int[][])positions, offsets) : new SegmentTermVector(field, terms, termFreqs);
        return tv;
    }

    protected Object clone() {
        if (this.tvx == null || this.tvd == null || this.tvf == null) {
            return null;
        }
        TermVectorsReader clone = null;
        try {
            clone = (TermVectorsReader)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.tvx = (IndexInput)this.tvx.clone();
        clone.tvd = (IndexInput)this.tvd.clone();
        clone.tvf = (IndexInput)this.tvf.clone();
        return clone;
    }
}

