/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.logging.smart;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectExecutionEvent;
import org.apache.maven.execution.ProjectExecutionListener;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.eclipse.sisu.Typed;
import org.mvndaemon.mvnd.logging.smart.BuildEventListener;
import org.mvndaemon.mvnd.logging.smart.ProjectBuildLogAppender;

@Singleton
@Named
@Typed(value={LoggingExecutionListener.class, ExecutionListener.class, ProjectExecutionListener.class})
public class LoggingExecutionListener
implements ExecutionListener,
ProjectExecutionListener {
    private ExecutionListener delegate;
    private BuildEventListener buildEventListener;

    public void init(ExecutionListener delegate, BuildEventListener buildEventListener) {
        this.delegate = delegate;
        this.buildEventListener = buildEventListener;
    }

    public void beforeProjectExecution(ProjectExecutionEvent projectExecutionEvent) throws LifecycleExecutionException {
    }

    public void beforeProjectLifecycleExecution(ProjectExecutionEvent projectExecutionEvent) throws LifecycleExecutionException {
    }

    public void afterProjectExecutionSuccess(ProjectExecutionEvent projectExecutionEvent) throws LifecycleExecutionException {
    }

    public void afterProjectExecutionFailure(ProjectExecutionEvent projectExecutionEvent) {
        MavenSession session = projectExecutionEvent.getSession();
        ReactorBuildStatus status = (ReactorBuildStatus)session.getRepositorySession().getData().get(ReactorBuildStatus.class);
        Throwable cause = projectExecutionEvent.getCause();
        this.buildEventListener.executionFailure(projectExecutionEvent.getProject().getArtifactId(), status.isHalted(), cause != null ? cause.toString() : null);
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.projectDiscoveryStarted(event);
    }

    public void sessionStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.buildEventListener.sessionStarted(event);
        this.delegate.sessionStarted(event);
    }

    public void sessionEnded(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.sessionEnded(event);
    }

    public void projectStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.buildEventListener.projectStarted(event.getProject().getArtifactId());
        this.delegate.projectStarted(event);
    }

    public void projectSucceeded(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.projectSucceeded(event);
        this.buildEventListener.projectFinished(event.getProject().getArtifactId());
    }

    public void projectFailed(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.projectFailed(event);
        this.buildEventListener.projectFinished(event.getProject().getArtifactId());
    }

    public void projectSkipped(ExecutionEvent event) {
        this.setMdc(event);
        this.buildEventListener.projectStarted(event.getProject().getArtifactId());
        this.delegate.projectSkipped(event);
        this.buildEventListener.projectFinished(event.getProject().getArtifactId());
    }

    public void mojoStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.buildEventListener.mojoStarted(event);
        this.delegate.mojoStarted(event);
    }

    public void mojoSucceeded(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.mojoSucceeded(event);
    }

    public void mojoFailed(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.mojoFailed(event);
    }

    public void mojoSkipped(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.mojoSkipped(event);
    }

    public void forkStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.forkStarted(event);
        ProjectBuildLogAppender.setForkingProjectId(event.getProject().getArtifactId());
    }

    public void forkSucceeded(ExecutionEvent event) {
        this.delegate.forkSucceeded(event);
        ProjectBuildLogAppender.setForkingProjectId(null);
    }

    public void forkFailed(ExecutionEvent event) {
        this.delegate.forkFailed(event);
        ProjectBuildLogAppender.setForkingProjectId(null);
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.forkedProjectStarted(event);
    }

    public void forkedProjectSucceeded(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.forkedProjectSucceeded(event);
        ProjectBuildLogAppender.setProjectId(null);
    }

    public void forkedProjectFailed(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.forkedProjectFailed(event);
        ProjectBuildLogAppender.setProjectId(null);
    }

    private void setMdc(ExecutionEvent event) {
        if (event.getProject() != null) {
            ProjectBuildLogAppender.setProjectId(event.getProject().getArtifactId());
        }
    }
}

