/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli;

import groovy.lang.Closure;
import groovy.lang.Delegate;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import groovy.util.ConfigSlurper;
import io.micronaut.cli.config.CodeGenConfig;
import io.micronaut.cli.config.ConfigMap;
import io.micronaut.cli.config.NavigableMap;
import io.micronaut.cli.console.logging.MicronautConsole;
import io.micronaut.cli.console.proxy.SystemPropertiesAuthenticator;
import io.micronaut.cli.interactive.completers.EscapingFileNameCompletor;
import io.micronaut.cli.interactive.completers.RegexCompletor;
import io.micronaut.cli.interactive.completers.SortedAggregateCompleter;
import io.micronaut.cli.io.support.SystemStreamsRedirector;
import io.micronaut.cli.profile.Command;
import io.micronaut.cli.profile.CommandCancellationListener;
import io.micronaut.cli.profile.ExecutionContext;
import io.micronaut.cli.profile.Profile;
import io.micronaut.cli.profile.ProfileRepository;
import io.micronaut.cli.profile.ProjectContext;
import io.micronaut.cli.profile.commands.ArgumentCompletingCommand;
import io.micronaut.cli.profile.commands.CommandRegistry;
import io.micronaut.cli.profile.commands.CommonOptionsMixin;
import io.micronaut.cli.profile.commands.PicocliCompleter;
import io.micronaut.cli.profile.repository.MavenProfileRepository;
import io.micronaut.cli.profile.repository.RepositoryConfiguration;
import io.micronaut.cli.util.CliSettings;
import java.io.File;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jline.Terminal;
import jline.UnixTerminal;
import jline.console.ConsoleReader;
import jline.console.UserInterruptException;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.history.History;
import jline.internal.NonBlockingInputStream;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;
import picocli.CommandLine;

@CommandLine.Command(synopsisHeading="@|bold,underline Usage:|@ ", optionListHeading="%n@|bold,underline Options:|@%n", commandListHeading="%n@|bold,underline Commands:|@%n", name="mn", description={"Micronaut CLI command line interface for generating projects and services.", "Commonly used commands are:", "  @|bold create-app|@ @|yellow NAME|@", "  @|bold create-cli-app|@ @|yellow NAME|@", "  @|bold create-federation|@ @|yellow NAME|@ @|yellow --services|@ @|yellow,italic SERVICE_NAME[,SERVICE_NAME]...|@", "  @|bold create-function|@ @|yellow NAME|@"})
public class MicronautCli
implements GroovyObject {
    public static final String DEFAULT_PROFILE_NAME = "service";
    private static final int KEYPRESS_CTRL_C = 3;
    private static final int KEYPRESS_ESC = 27;
    private static final String APP_USAGE_MESSAGE = "create-app [NAME]";
    private static final String CLI_APP_USAGE_MESSAGE = "create-cli-app [NAME]";
    private static final String FEDERATION_USAGE_MESSAGE = "create-federation [NAME] --services SERVICE_NAME[,SERVICE_NAME]...";
    private static final String FUNCTION_USAGE_MESSAGE = "create-function [NAME]";
    private final SystemStreamsRedirector originalStreams;
    private static ExecutionContext currentExecutionContext;
    private static boolean interactiveModeActive;
    private static boolean tiggerAppLoad;
    private static final NavigableMap SETTINGS_MAP;
    private SortedAggregateCompleter aggregateCompleter;
    private boolean keepRunning;
    private boolean integrateGradle;
    private Character defaultInputMask;
    private ProfileRepository profileRepository;
    private CodeGenConfig applicationConfig;
    private ProjectContext projectContext;
    private Profile profile;
    private List<RepositoryConfiguration> profileRepositories;
    private CommandLine parser;
    @CommandLine.Mixin
    private CommonOptionsMixin commonOptions;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ long $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public MicronautCli() {
        MetaClass metaClass;
        CommonOptionsMixin commonOptionsMixin;
        List list;
        boolean bl;
        boolean bl2;
        SortedAggregateCompleter sortedAggregateCompleter;
        SystemStreamsRedirector systemStreamsRedirector;
        this.originalStreams = systemStreamsRedirector = SystemStreamsRedirector.original();
        this.aggregateCompleter = sortedAggregateCompleter = new SortedAggregateCompleter();
        this.keepRunning = bl2 = true;
        this.integrateGradle = bl = true;
        Object var5_5 = null;
        this.defaultInputMask = (Character)ScriptBytecodeAdapter.castToType(var5_5, Character.class);
        Object var6_6 = null;
        this.profile = (Profile)ScriptBytecodeAdapter.castToType(var6_6, Profile.class);
        this.profileRepositories = list = ScriptBytecodeAdapter.createList(new Object[]{MavenProfileRepository.DEFAULT_REPO});
        this.commonOptions = commonOptionsMixin = new CommonOptionsMixin();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        NavigableMap navigableMap;
        boolean bl;
        MicronautCli.__$swapInit();
        tiggerAppLoad = bl = false;
        Object var1_1 = null;
        currentExecutionContext = (ExecutionContext)ScriptBytecodeAdapter.castToType(var1_1, ExecutionContext.class);
        SETTINGS_MAP = navigableMap = new NavigableMap();
        if (CliSettings.SETTINGS_FILE.exists()) {
            try {
                SETTINGS_MAP.merge(new ConfigSlurper().parse(CliSettings.SETTINGS_FILE.toURI().toURL()));
            }
            catch (Throwable e) {
                e.printStackTrace();
                DefaultGroovyMethods.println(System.err, (Object)new GStringImpl(new Object[]{CliSettings.SETTINGS_FILE, e.getMessage()}, new String[]{"ERROR: Problem loading ", ": ", ""}));
            }
            try {
                public final class __clinit__closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        public final class _closure7
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure7(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                Object v0;
                                ExecutionContext executionContext = currentExecutionContext;
                                if (executionContext != null) {
                                    executionContext.cancel();
                                    v0 = null;
                                } else {
                                    v0 = null;
                                }
                                return v0;
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Override
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _closure7.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        DefaultGroovyStaticMethods.start(null, new _closure7(this, this.getThisObject())).join(1000);
                        Object var2_2 = null;
                        try {
                            return var2_2;
                        }
                        catch (Throwable e) {
                            Object var4_4 = null;
                            return var4_4;
                        }
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != __clinit__closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.addShutdownHook(Runtime.class, new __clinit__closure1(MicronautCli.class, MicronautCli.class));
            }
            catch (Exception e) {
            }
        }
    }

    public static <T> T getSetting(String key, Class<T> targetType, T defaultValue) {
        Object value = DefaultGroovyMethods.get(SETTINGS_MAP, key, defaultValue);
        if (value == null) {
            return null;
        }
        if (targetType.isInstance(value)) {
            return (T)value;
        }
        T t = DefaultGroovyMethods.asType(value, targetType);
        try {
            return t;
        }
        catch (Throwable e) {
            T t2 = null;
            return t2;
        }
    }

    public static void main(String ... args) {
        Authenticator.setDefault((Authenticator)ScriptBytecodeAdapter.castToType(MicronautCli.getSetting(CliSettings.AUTHENTICATOR, Authenticator.class, new SystemPropertiesAuthenticator()), Authenticator.class));
        ProxySelector proxySelector = (ProxySelector)ScriptBytecodeAdapter.castToType(MicronautCli.getSetting(CliSettings.PROXY_SELECTOR, ProxySelector.class), ProxySelector.class);
        if (proxySelector != null) {
            ProxySelector.setDefault(proxySelector);
        }
        MicronautCli cli = new MicronautCli();
        if (ScriptBytecodeAdapter.compareEqual(MavenProfileRepository.DEFAULT_REPO, MavenProfileRepository.SNAPSHOT_REPO)) {
            cli.getProfileRepositories().add(MavenProfileRepository.RELEASE_REPO);
        }
        try {
            MicronautCli.exit(cli.execute(args));
        }
        catch (CommandLine.ParameterException e) {
            MicronautConsole console = MicronautConsole.getInstance();
            console.error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Error occurred running Micronaut CLI: ", ""})));
            if (!CommandLine.UnmatchedArgumentException.printSuggestions(e, console.getOut())) {
                console.append(e.getCommandLine().getUsageMessage(console.isAnsiEnabled() ? CommandLine.Help.Ansi.ON : CommandLine.Help.Ansi.OFF));
            }
            MicronautCli.exit(1);
        }
        catch (Throwable e) {
            while (DefaultTypeTransformation.booleanUnbox(e.getCause()) && ScriptBytecodeAdapter.compareNotEqual(e, e.getCause())) {
                Throwable throwable;
                e = throwable = e.getCause();
            }
            MicronautConsole.getInstance().error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Error occurred running Micronaut CLI: ", ""})), e);
            MicronautCli.exit(1);
        }
    }

    public static void exit(int code) {
        MicronautConsole.getInstance().cleanlyExit(code);
    }

    public static boolean isInteractiveModeActive() {
        return interactiveModeActive;
    }

    public static void tiggerAppLoad() {
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty(bl, null, MicronautCli.class, "tiggerAppLoad");
    }

    private int getBaseUsage() {
        DefaultGroovyMethods.println(System.out, (Object)new GStringImpl(new Object[]{APP_USAGE_MESSAGE, CLI_APP_USAGE_MESSAGE, FEDERATION_USAGE_MESSAGE, FUNCTION_USAGE_MESSAGE}, new String[]{"Usage: \n\t ", " \n\t ", " \\n\\t ", " \n\t ", "  \n\n"}));
        this.execute("list-profiles");
        System.out.println("\nType 'mn help' or 'mn -h' for more information.");
        return 1;
    }

    public int execute(String ... args) {
        if (!DefaultTypeTransformation.booleanUnbox(this.parser)) {
            CommandLine commandLine;
            this.parser = commandLine = this.createParser();
        }
        CommandLine.ParseResult parseResult = this.parser.parseArgs(args);
        MicronautConsole console = this.initConsole(parseResult);
        if (this.printHelpIfRequested(parseResult)) {
            MicronautCli.exit(0);
        }
        if (!MicronautCli.isRunningInProject()) {
            Profile profile;
            boolean bl;
            if (parseResult.hasSubcommand()) {
                CommandLine.ParseResult pr = parseResult;
                while (pr.hasSubcommand()) {
                    CommandLine.ParseResult parseResult2;
                    pr = parseResult2 = pr.subcommand();
                }
                return this.executeCommand((Command)ScriptBytecodeAdapter.asType(pr.commandSpec().userObject(), Command.class), pr) ? 0 : 1;
            }
            if (DefaultTypeTransformation.booleanUnbox(parseResult.unmatched())) {
                return this.getBaseUsage();
            }
            this.integrateGradle = bl = false;
            console.getReader().addCompleter(new PicocliCompleter(this.parser.getCommandSpec()));
            public final class _execute_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _execute_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(ExecutionContext context) {
                    CommandLine.ParseResult pr = context.getParseResult();
                    ((MicronautCli)ScriptBytecodeAdapter.castToType(this.getThisObject(), MicronautCli.class)).assertNoUnmatchedArguments(pr);
                    while (pr.hasSubcommand()) {
                        CommandLine.ParseResult parseResult;
                        pr = parseResult = pr.subcommand();
                    }
                    return InvokerHelper.invokeMethodSafe((MicronautCli)this.getThisObject(), "executeCommand", new Object[]{(Command)ScriptBytecodeAdapter.asType(pr.commandSpec().userObject(), Command.class), pr});
                }

                public Object call(ExecutionContext context) {
                    return this.doCall(context);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _execute_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            this.profile = profile = (Profile)ScriptBytecodeAdapter.asType(ScriptBytecodeAdapter.createMap(new Object[]{"handleCommand", new _execute_closure2(this, this)}), Profile.class);
            this.startInteractiveMode(console);
            return 0;
        }
        if (parseResult.hasSubcommand()) {
            Boolean bl = this.handleCommand(parseResult);
            return (bl == null ? false : bl) ? 0 : 1;
        }
        if (DefaultTypeTransformation.booleanUnbox(parseResult.unmatched())) {
            MicronautConsole.getInstance().error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{parseResult.unmatched().get(0)}, new String[]{"The command '", "' was not found. Some commands like 'create-app' are only available outside of a project."})));
            return 1;
        }
        this.handleInteractiveMode();
        return 0;
    }

    private static boolean isRunningInProject() {
        return new File("micronaut-cli.yml").exists() || new File("profile.yml").exists();
    }

    private CommandLine createParser() {
        Reference<CommandLine> result = new Reference<CommandLine>(new CommandLine(this));
        result.get().getCommandSpec().parser().unmatchedArgumentsAllowed(true);
        if (MicronautCli.isRunningInProject()) {
            this.initializeApplication();
            public final class _createParser_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _createParser_closure3(Object _outerInstance, Object _thisObject, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.result = reference = result;
                }

                public Object doCall(Command cmd) {
                    return ((CommandLine)this.result.get()).addSubcommand(cmd.getName(), new CommandLine(cmd));
                }

                public Object call(Command cmd) {
                    return this.doCall(cmd);
                }

                public CommandLine getResult() {
                    return (CommandLine)ScriptBytecodeAdapter.castToType(this.result.get(), CommandLine.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _createParser_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(this.profile.getCommands(this.projectContext), (Closure)new _createParser_closure3(this, this, result));
        } else {
            MavenProfileRepository mavenProfileRepository = this.createMavenProfileRepository();
            this.profileRepository = mavenProfileRepository;
            this.profileRepository.getAllProfiles();
            public final class _createParser_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _createParser_closure4(Object _outerInstance, Object _thisObject, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.result = reference = result;
                }

                public Object doCall(Command cmd) {
                    if (!((CommandLine)this.result.get()).getSubcommands().containsKey(cmd.getName())) {
                        return ((CommandLine)this.result.get()).addSubcommand(cmd.getName(), new CommandLine(cmd));
                    }
                    return null;
                }

                public Object call(Command cmd) {
                    return this.doCall(cmd);
                }

                public CommandLine getResult() {
                    return (CommandLine)ScriptBytecodeAdapter.castToType(this.result.get(), CommandLine.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _createParser_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(CommandRegistry.findCommands(this.profileRepository), (Closure)new _createParser_closure4(this, this, result));
        }
        result.get().addSubcommand("!", new CommandLine(new BangCommand(this)));
        result.get().addSubcommand("exit", new CommandLine(new ExitCommand(this)), "quit");
        result.get().setUsageHelpWidth(100);
        return result.get();
    }

    private boolean printHelpIfRequested(CommandLine.ParseResult parseResult) {
        CommandLine.ParseResult p = parseResult;
        while (DefaultTypeTransformation.booleanUnbox(p)) {
            CommandLine.ParseResult parseResult2;
            if (p.isVersionHelpRequested()) {
                public final class _printHelpIfRequested_closure5
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _printHelpIfRequested_closure5(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        MicronautConsole.getInstance().addStatus(ShortTypeHandling.castToString(it));
                        return null;
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _printHelpIfRequested_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.each((Object[])ScriptBytecodeAdapter.castToType(p.commandSpec().version(), Object[].class), (Closure)new _printHelpIfRequested_closure5(this, this));
                return true;
            }
            if (p.isUsageHelpRequested()) {
                MicronautConsole console = MicronautConsole.getInstance();
                CommandLine.Help.Ansi ansi = console.isAnsiEnabled() ? CommandLine.Help.Ansi.ON : CommandLine.Help.Ansi.OFF;
                console.append(p.commandSpec().commandLine().getUsageMessage(ansi));
                return true;
            }
            p = parseResult2 = p.subcommand();
        }
        return false;
    }

    private MicronautConsole initConsole(CommandLine.ParseResult parseResult) {
        CommandLine.ParseResult parseResult2;
        CommandLine.ParseResult parseResult3;
        CommandLine.ParseResult parseResult4;
        boolean showStack = this.commonOptions.isShowStacktrace() || DefaultTypeTransformation.booleanUnbox((parseResult4 = parseResult.subcommand()) != null ? parseResult4.matchedOptionValue("stacktrace", Boolean.valueOf(false)) : null);
        boolean verbose = this.commonOptions.isVerbose() || DefaultTypeTransformation.booleanUnbox((parseResult3 = parseResult.subcommand()) != null ? parseResult3.matchedOptionValue("verbose", Boolean.valueOf(false)) : null);
        boolean ansiEnabled = this.commonOptions.isAnsiEnabled() && !DefaultTypeTransformation.booleanUnbox((parseResult2 = parseResult.subcommand()) != null ? parseResult2.matchedOptionValue("plain-output", Boolean.valueOf(false)) : null);
        System.setProperty("micronaut.show.stacktrace", ShortTypeHandling.castToString(new GStringImpl(new Object[]{showStack}, new String[]{"", ""})));
        System.setProperty("micronaut.verbose", ShortTypeHandling.castToString(new GStringImpl(new Object[]{verbose}, new String[]{"", ""})));
        System.setProperty("micronaut.full.stacktrace", ShortTypeHandling.castToString(new GStringImpl(new Object[]{verbose}, new String[]{"", ""})));
        MicronautConsole console = MicronautConsole.getInstance();
        boolean bl = verbose;
        console.setVerbose(bl);
        boolean bl2 = showStack;
        console.setStacktrace(bl2);
        boolean bl3 = ansiEnabled;
        console.setAnsiEnabled(bl3);
        return console;
    }

    private void assertNoUnmatchedArguments(CommandLine.ParseResult parseResult) {
        if (!parseResult.hasSubcommand() && DefaultTypeTransformation.booleanUnbox(parseResult.unmatched()) && !DefaultGroovyMethods.getAt(parseResult.unmatched(), 0).startsWith("!")) {
            throw (Throwable)new CommandLine.UnmatchedArgumentException(parseResult.commandSpec().commandLine(), parseResult.unmatched());
        }
    }

    protected boolean executeCommand(Command cmd, CommandLine.ParseResult parseResult) {
        return cmd.handle(this.createExecutionContext(parseResult));
    }

    protected void initializeApplication() {
        CodeGenConfig codeGenConfig;
        this.applicationConfig = codeGenConfig = this.loadApplicationConfig();
        File profileYml = new File("profile.yml");
        if (profileYml.exists()) {
            this.applicationConfig.put(CliSettings.PROFILE, (Object)"profile");
        }
        MicronautConsole console = MicronautConsole.getInstance();
        boolean bl = this.commonOptions.isAnsiEnabled();
        console.setAnsiEnabled(bl);
        Character c = this.defaultInputMask;
        console.setDefaultInputMask(c);
        File baseDir = new File(".").getCanonicalFile();
        ProjectContextImpl projectContextImpl = new ProjectContextImpl(console, baseDir, this.applicationConfig);
        this.projectContext = projectContextImpl;
        this.initializeProfile();
    }

    protected MavenProfileRepository createMavenProfileRepository() {
        Map profileRepos = (Map)ScriptBytecodeAdapter.castToType(MicronautCli.getSetting(CliSettings.PROFILE_REPOSITORIES, Map.class, Collections.emptyMap()), Map.class);
        if (!profileRepos.isEmpty()) {
            this.profileRepositories.clear();
            Object repoName2 = null;
            for (Object repoName2 : profileRepos.keySet()) {
                RepositoryConfiguration repositoryConfiguration;
                RepositoryConfiguration repositoryConfiguration2;
                Object data = profileRepos.get(repoName2);
                if (!(data instanceof Map)) continue;
                Object uri = ((Map)data).get("url");
                Object snapshots = ((Map)data).get("snapshotsEnabled");
                if (!(uri != null)) continue;
                boolean enableSnapshots = DefaultTypeTransformation.booleanUnbox(snapshots != null ? Boolean.valueOf(DefaultGroovyMethods.toString(snapshots)) : Boolean.valueOf(false));
                RepositoryConfiguration repositoryConfiguration3 = null;
                String username = ShortTypeHandling.castToString(((Map)data).get("username"));
                String password = ShortTypeHandling.castToString(((Map)data).get("password"));
                repositoryConfiguration3 = username != null && password != null ? (repositoryConfiguration2 = new RepositoryConfiguration(DefaultGroovyMethods.toString(repoName2), new URI(DefaultGroovyMethods.toString(uri)), enableSnapshots, username, password)) : (repositoryConfiguration = new RepositoryConfiguration(DefaultGroovyMethods.toString(repoName2), new URI(DefaultGroovyMethods.toString(uri)), enableSnapshots));
                this.profileRepositories.add(repositoryConfiguration3);
            }
        }
        return new MavenProfileRepository(this.profileRepositories);
    }

    public ExecutionContext createExecutionContext(CommandLine.ParseResult parseResult) {
        return new ExecutionContextImpl(parseResult, this.projectContext);
    }

    public Boolean handleCommand(CommandLine.ParseResult parseResult) {
        return this.handleCommand(this.createExecutionContext(parseResult));
    }

    /*
     * Exception decompiling
     */
    public Boolean handleCommand(ExecutionContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 17[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleInteractiveMode() {
        MicronautConsole console = this.setupCompleters();
        this.startInteractiveMode(console);
    }

    protected MicronautConsole setupCompleters() {
        MicronautConsole console = DefaultTypeTransformation.booleanUnbox(this.projectContext) ? this.projectContext.getConsole() : MicronautConsole.getInstance();
        ConsoleReader consoleReader = console.getReader();
        consoleReader.setHandleUserInterrupt(true);
        Collection<Completer> completers = this.aggregateCompleter.getCompleters();
        console.resetCompleters();
        completers.add(new ArgumentCompleter(new RegexCompletor("!\\w+"), new EscapingFileNameCompletor()));
        completers.add(new PicocliCompleter(this.parser.getCommandSpec()));
        consoleReader.addCompleter(this.aggregateCompleter);
        return console;
    }

    protected void startInteractiveMode(MicronautConsole console) {
        console.addStatus("Starting interactive mode...");
        ExecutorService commandExecutor = Executors.newFixedThreadPool(1);
        try {
            this.interactiveModeLoop(console, commandExecutor);
        }
        finally {
            commandExecutor.shutdownNow();
        }
    }

    private void interactiveModeLoop(MicronautConsole console, ExecutorService commandExecutor) {
        boolean bl;
        NonBlockingInputStream nonBlockingInput = (NonBlockingInputStream)ScriptBytecodeAdapter.castToType(console.getReader().getInput(), NonBlockingInputStream.class);
        interactiveModeActive = bl = true;
        boolean firstRun = true;
        while (this.keepRunning) {
            try {
                if (firstRun) {
                    boolean bl2;
                    console.addStatus("Enter a command name to run. Use TAB for completion:");
                    firstRun = bl2 = false;
                }
                String commandLine = console.showPrompt();
                if (commandLine == null) {
                    this.exitInteractiveMode();
                    continue;
                }
                if (!DefaultTypeTransformation.booleanUnbox(commandLine.trim())) continue;
                try {
                    CommandLine.ParseResult parseResult = this.parser.parseArgs(MicronautCli.splitCommandLine(commandLine));
                    this.initConsole(parseResult);
                    if (!(!CommandLine.printHelpIfRequested(parseResult.asCommandLineList(), System.out, System.err, console.isAnsiEnabled() ? CommandLine.Help.Ansi.ON : CommandLine.Help.Ansi.OFF))) continue;
                    if (nonBlockingInput.isNonBlockingEnabled()) {
                        this.handleCommandWithCancellationSupport(console, parseResult, commandExecutor, nonBlockingInput);
                        continue;
                    }
                    this.handleCommand(parseResult);
                }
                catch (CommandLine.ParameterException invalidInput) {
                    console.error(invalidInput.getMessage());
                    if (!(!CommandLine.UnmatchedArgumentException.printSuggestions(invalidInput, console.getOut()))) continue;
                    CommandLine.Help.Ansi ansi = console.isAnsiEnabled() ? CommandLine.Help.Ansi.ON : CommandLine.Help.Ansi.OFF;
                    console.append(invalidInput.getCommandLine().getUsageMessage(ansi));
                }
            }
            catch (UserInterruptException e) {
                this.exitInteractiveMode();
            }
            catch (Throwable e) {
                console.error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Caught exception ", ""})), e);
            }
        }
    }

    private Boolean handleCommandWithCancellationSupport(MicronautConsole console, CommandLine.ParseResult parseResult, ExecutorService commandExecutor, NonBlockingInputStream nonBlockingInput) {
        Reference<ExecutionContext> executionContext = new Reference<ExecutionContext>(this.createExecutionContext(parseResult));
        public final class _handleCommandWithCancellationSupport_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executionContext;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handleCommandWithCancellationSupport_closure6(Object _outerInstance, Object _thisObject, Reference executionContext) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.executionContext = reference = executionContext;
            }

            public Object doCall(Object it) {
                return ((MicronautCli)ScriptBytecodeAdapter.castToType(this.getThisObject(), MicronautCli.class)).handleCommand((ExecutionContext)ScriptBytecodeAdapter.castToType(this.executionContext.get(), ExecutionContext.class));
            }

            public ExecutionContext getExecutionContext() {
                return (ExecutionContext)ScriptBytecodeAdapter.castToType(this.executionContext.get(), ExecutionContext.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            @Override
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _handleCommandWithCancellationSupport_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Future commandFuture = commandExecutor.submit(new _handleCommandWithCancellationSupport_closure6(this, this, executionContext));
        Terminal terminal = console.getReader().getTerminal();
        if (terminal instanceof UnixTerminal) {
            ((UnixTerminal)ScriptBytecodeAdapter.castToType(terminal, UnixTerminal.class)).disableInterruptCharacter();
        }
        try {
            while (!commandFuture.isDone()) {
                if (!nonBlockingInput.isNonBlockingEnabled()) continue;
                int peeked = nonBlockingInput.peek($const$0);
                if (!(peeked > 0)) continue;
                nonBlockingInput.read(1L);
                if (!(peeked == KEYPRESS_CTRL_C || peeked == KEYPRESS_ESC)) continue;
                executionContext.get().getConsole().log("  ");
                executionContext.get().getConsole().updateStatus("Stopping build. Please wait...");
                executionContext.get().cancel();
            }
        }
        finally {
            if (terminal instanceof UnixTerminal) {
                ((UnixTerminal)ScriptBytecodeAdapter.castToType(terminal, UnixTerminal.class)).enableInterruptCharacter();
            }
        }
        if (!commandFuture.isCancelled()) {
            Boolean bl = (Boolean)ScriptBytecodeAdapter.castToType(commandFuture.get(), Boolean.class);
            try {
                return bl;
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
        return false;
    }

    private Object initializeProfile() {
        Profile profile;
        File file = CliSettings.TARGET_DIR;
        Boolean bl = file != null ? Boolean.valueOf(file.mkdirs()) : null;
        MavenProfileRepository mavenProfileRepository = this.createMavenProfileRepository();
        this.profileRepository = mavenProfileRepository;
        Object object = this.applicationConfig.get(CliSettings.PROFILE);
        String profileName = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(object) ? object : MicronautCli.getSetting(CliSettings.PROFILE, String.class, DEFAULT_PROFILE_NAME));
        this.profile = profile = this.profileRepository.getProfile(profileName);
        if (this.profile == null) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString(new GStringImpl(new Object[]{profileName}, new String[]{"No profile found for name [", "]."})));
        }
        return null;
    }

    private CodeGenConfig loadApplicationConfig() {
        CodeGenConfig config = new CodeGenConfig();
        File cliYml = new File("micronaut-cli.yml");
        if (cliYml.exists()) {
            config.loadYml(cliYml);
        }
        return config;
    }

    private boolean handleBuiltInCommands(ExecutionContext context) {
        CommandLine.ParseResult parseResult = context.getParseResult();
        if (!parseResult.unmatched().isEmpty() && DefaultGroovyMethods.getAt(parseResult.unmatched(), 0).startsWith("!")) {
            return this.executeProcess(context, (String[])ScriptBytecodeAdapter.asType(parseResult.unmatched(), String[].class));
        }
        return false;
    }

    protected boolean executeProcess(ExecutionContext context, String ... args) {
        MicronautConsole console = context.getConsole();
        String string = ((String)BytecodeInterface8.objectArrayGet(args, 0)).substring(1);
        BytecodeInterface8.objectArraySet(args, 0, string);
        Process process = new ProcessBuilder(args).redirectErrorStream(true).start();
        console.log(IOGroovyMethods.getText(process.getInputStream(), "UTF-8"));
        boolean bl = true;
        try {
            return bl;
        }
        catch (Exception e) {
            console.error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Error occurred executing process: ", ""})));
            boolean bl2 = false;
            return bl2;
        }
    }

    private String unescape(String str) {
        return str.replace("\\", "");
    }

    private static String[] splitCommandLine(String commandLine) {
        return new ArgumentCompleter.WhitespaceArgumentDelimiter().delimit(commandLine, commandLine.length()).getArguments();
    }

    private void exitInteractiveMode() {
        boolean bl;
        this.keepRunning = bl = false;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MicronautCli.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MicronautCli.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, MicronautCli.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(MicronautCli.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public static <T> T getSetting(String key, Class<T> targetType) {
        return MicronautCli.getSetting(key, targetType, null);
    }

    @Generated
    public static <T> T getSetting(String key) {
        return MicronautCli.getSetting(key, Object.class, null);
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty(this, string);
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty(this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        long l;
        $const$0 = l = 100L;
    }

    @Generated
    public SortedAggregateCompleter getAggregateCompleter() {
        return this.aggregateCompleter;
    }

    @Generated
    public void setAggregateCompleter(SortedAggregateCompleter sortedAggregateCompleter) {
        this.aggregateCompleter = sortedAggregateCompleter;
    }

    @Generated
    public boolean getKeepRunning() {
        return this.keepRunning;
    }

    @Generated
    public boolean isKeepRunning() {
        return this.keepRunning;
    }

    @Generated
    public void setKeepRunning(boolean bl) {
        this.keepRunning = bl;
    }

    @Generated
    public boolean getIntegrateGradle() {
        return this.integrateGradle;
    }

    @Generated
    public boolean isIntegrateGradle() {
        return this.integrateGradle;
    }

    @Generated
    public void setIntegrateGradle(boolean bl) {
        this.integrateGradle = bl;
    }

    @Generated
    public Character getDefaultInputMask() {
        return this.defaultInputMask;
    }

    @Generated
    public void setDefaultInputMask(Character c) {
        this.defaultInputMask = c;
    }

    @Generated
    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    @Generated
    public void setProfileRepository(ProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
    }

    @Generated
    public CodeGenConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    @Generated
    public void setApplicationConfig(CodeGenConfig codeGenConfig) {
        this.applicationConfig = codeGenConfig;
    }

    @Generated
    public ProjectContext getProjectContext() {
        return this.projectContext;
    }

    @Generated
    public void setProjectContext(ProjectContext projectContext) {
        this.projectContext = projectContext;
    }

    @Generated
    public Profile getProfile() {
        return this.profile;
    }

    @Generated
    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    @Generated
    public List<RepositoryConfiguration> getProfileRepositories() {
        return this.profileRepositories;
    }

    @Generated
    public void setProfileRepositories(List<RepositoryConfiguration> list) {
        this.profileRepositories = list;
    }

    @Generated
    public CommandLine getParser() {
        return this.parser;
    }

    @Generated
    public void setParser(CommandLine commandLine) {
        this.parser = commandLine;
    }

    @Generated
    public CommonOptionsMixin getCommonOptions() {
        return this.commonOptions;
    }

    @Generated
    public void setCommonOptions(CommonOptionsMixin commonOptionsMixin) {
        this.commonOptions = commonOptionsMixin;
    }

    @ToString
    @EqualsAndHashCode
    @CommandLine.Command(hidden=true, name="!", description={"Rerun a previously executed command"})
    public static class BangCommand
    extends ArgumentCompletingCommand {
        private MicronautCli micronautCli;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public BangCommand(MicronautCli micronautCli) {
            MicronautCli micronautCli2;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.micronautCli = micronautCli2 = micronautCli;
        }

        @Generated
        public BangCommand() {
            this(null);
        }

        @Override
        public String getName() {
            return "!";
        }

        @Override
        public boolean handle(ExecutionContext context) {
            MicronautConsole console = context.getConsole();
            History history = console.getReader().getHistory();
            history.previous();
            if (!history.previous()) {
                console.error("! not valid. Can not repeat without history");
            }
            String historicalCommand = ShortTypeHandling.castToString(history.current());
            if (!historicalCommand.startsWith("!")) {
                CommandLine.ParseResult parseResult = this.micronautCli.getParser().parseArgs(MicronautCli.splitCommandLine(historicalCommand));
                this.micronautCli.initConsole(parseResult);
                return DefaultTypeTransformation.booleanUnbox(this.micronautCli.handleCommand(parseResult));
            }
            console.error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{historicalCommand}, new String[]{"Can not repeat command: ", ""})));
            return false;
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != BangCommand.class) {
                return ScriptBytecodeAdapter.initMetaClass(this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("io.micronaut.cli.MicronautCli$BangCommand(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getMicronautCli()));
            Boolean bl3 = $toStringFirst;
            if (bl3 == null ? false : bl3) {
                Boolean bl4;
                $toStringFirst = bl4 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getName()));
            Boolean bl5 = $toStringFirst;
            if (bl5 == null ? false : bl5) {
                Boolean bl6;
                $toStringFirst = bl6 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getCommandSpec()));
            _result.append(")");
            return _result.toString();
        }

        @Generated
        public int hashCode() {
            int _result = HashCodeHelper.initHash();
            if (!(this.getMicronautCli() == this)) {
                int n;
                _result = n = HashCodeHelper.updateHash(_result, this.getMicronautCli());
            }
            return _result;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof BangCommand;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof BangCommand)) {
                return false;
            }
            BangCommand otherTyped = (BangCommand)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual(this.getMicronautCli(), otherTyped.getMicronautCli()));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(BangCommand.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(BangCommand.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(BangCommand.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(BangCommand.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        public MicronautCli getMicronautCli() {
            return this.micronautCli;
        }

        @Generated
        public void setMicronautCli(MicronautCli micronautCli) {
            this.micronautCli = micronautCli;
        }
    }

    @ToString
    @EqualsAndHashCode
    @CommandLine.Command(hidden=true, name="exit", aliases={"quit"}, description={"Exit interactive mode"})
    public static class ExitCommand
    extends ArgumentCompletingCommand {
        private MicronautCli micronautCli;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public ExitCommand(MicronautCli micronautCli) {
            MicronautCli micronautCli2;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.micronautCli = micronautCli2 = micronautCli;
        }

        @Generated
        public ExitCommand() {
            this(null);
        }

        @Override
        public String getName() {
            return "exit";
        }

        @Override
        public boolean handle(ExecutionContext context) {
            boolean bl = false;
            this.micronautCli.setKeepRunning(bl);
            return true;
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ExitCommand.class) {
                return ScriptBytecodeAdapter.initMetaClass(this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("io.micronaut.cli.MicronautCli$ExitCommand(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getMicronautCli()));
            Boolean bl3 = $toStringFirst;
            if (bl3 == null ? false : bl3) {
                Boolean bl4;
                $toStringFirst = bl4 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getName()));
            Boolean bl5 = $toStringFirst;
            if (bl5 == null ? false : bl5) {
                Boolean bl6;
                $toStringFirst = bl6 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getCommandSpec()));
            _result.append(")");
            return _result.toString();
        }

        @Generated
        public int hashCode() {
            int _result = HashCodeHelper.initHash();
            if (!(this.getMicronautCli() == this)) {
                int n;
                _result = n = HashCodeHelper.updateHash(_result, this.getMicronautCli());
            }
            return _result;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof ExitCommand;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExitCommand)) {
                return false;
            }
            ExitCommand otherTyped = (ExitCommand)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual(this.getMicronautCli(), otherTyped.getMicronautCli()));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ExitCommand.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ExitCommand.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ExitCommand.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ExitCommand.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        public MicronautCli getMicronautCli() {
            return this.micronautCli;
        }

        @Generated
        public void setMicronautCli(MicronautCli micronautCli) {
            this.micronautCli = micronautCli;
        }
    }

    @ToString
    @EqualsAndHashCode
    public static class ExecutionContextImpl
    implements ExecutionContext,
    GroovyObject {
        private CommandLine.ParseResult parseResult;
        @Delegate(excludes={"getConsole", "getBaseDir"})
        private ProjectContext projectContext;
        private MicronautConsole console;
        private List<CommandCancellationListener> cancelListeners;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ExecutionContextImpl(CodeGenConfig config) {
            this(CommandLine.ParseResult.builder(CommandLine.Model.CommandSpec.create()).build(), new ProjectContextImpl(MicronautConsole.getInstance(), new File("."), config));
        }

        public ExecutionContextImpl(CommandLine.ParseResult parseResult, ProjectContext projectContext) {
            ProjectContext projectContext2;
            CommandLine.ParseResult parseResult2;
            MetaClass metaClass;
            List list;
            MicronautConsole micronautConsole;
            this.console = micronautConsole = MicronautConsole.getInstance();
            this.cancelListeners = list = ScriptBytecodeAdapter.createList(new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.parseResult = parseResult2 = parseResult;
            this.projectContext = projectContext2 = projectContext;
            ProjectContext projectContext3 = projectContext;
            if (DefaultTypeTransformation.booleanUnbox(projectContext3 != null ? projectContext3.getConsole() : null)) {
                MicronautConsole micronautConsole2;
                this.console = micronautConsole2 = projectContext.getConsole();
            }
        }

        @Override
        public void addCancelledListener(CommandCancellationListener listener) {
            DefaultGroovyMethods.leftShift(this.cancelListeners, listener);
        }

        @Override
        public void cancel() {
            CommandCancellationListener listener = null;
            Iterator<CommandCancellationListener> iterator = this.cancelListeners.iterator();
            while (iterator.hasNext()) {
                listener = (CommandCancellationListener)ScriptBytecodeAdapter.castToType(iterator.next(), CommandCancellationListener.class);
                try {
                    listener.commandCancelled();
                }
                catch (Exception e) {
                    this.console.error("Error notifying listener about cancelling command", e);
                }
            }
        }

        @Override
        public File getBaseDir() {
            ProjectContext projectContext = this.projectContext;
            File file = projectContext != null ? projectContext.getBaseDir() : null;
            return DefaultTypeTransformation.booleanUnbox(file) ? file : new File(".");
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ExecutionContextImpl.class) {
                return ScriptBytecodeAdapter.initMetaClass(this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("io.micronaut.cli.MicronautCli$ExecutionContextImpl(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getParseResult()));
            Boolean bl3 = $toStringFirst;
            if (bl3 == null ? false : bl3) {
                Boolean bl4;
                $toStringFirst = bl4 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getProjectContext()));
            Boolean bl5 = $toStringFirst;
            if (bl5 == null ? false : bl5) {
                Boolean bl6;
                $toStringFirst = bl6 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getConsole()));
            Boolean bl7 = $toStringFirst;
            if (bl7 == null ? false : bl7) {
                Boolean bl8;
                $toStringFirst = bl8 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getConfig()));
            Boolean bl9 = $toStringFirst;
            if (bl9 == null ? false : bl9) {
                Boolean bl10;
                $toStringFirst = bl10 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getBaseDir()));
            _result.append(")");
            return _result.toString();
        }

        @Generated
        public int hashCode() {
            int _result = HashCodeHelper.initHash();
            if (!(this.getParseResult() == this)) {
                int n;
                _result = n = HashCodeHelper.updateHash(_result, this.getParseResult());
            }
            if (!(this.getProjectContext() == this)) {
                int n;
                _result = n = HashCodeHelper.updateHash(_result, this.getProjectContext());
            }
            if (!(this.getConsole() == this)) {
                int n;
                _result = n = HashCodeHelper.updateHash(_result, this.getConsole());
            }
            return _result;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof ExecutionContextImpl;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExecutionContextImpl)) {
                return false;
            }
            ExecutionContextImpl otherTyped = (ExecutionContextImpl)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual(this.getParseResult(), otherTyped.getParseResult())) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual(this.getProjectContext(), otherTyped.getProjectContext())) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual(this.getConsole(), otherTyped.getConsole()));
        }

        @Override
        @Generated
        public ConfigMap getConfig() {
            return this.projectContext.getConfig();
        }

        @Override
        @Generated
        public String navigateConfig(String ... path) {
            return this.projectContext.navigateConfig(path);
        }

        @Override
        @Generated
        public <T> T navigateConfigForType(Class<T> requiredType, String ... path) {
            return this.projectContext.navigateConfigForType(requiredType, path);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ExecutionContextImpl.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ExecutionContextImpl.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ExecutionContextImpl.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ExecutionContextImpl.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty(this, string);
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty(this, string, object);
        }

        @Override
        @Generated
        public CommandLine.ParseResult getParseResult() {
            return this.parseResult;
        }

        @Generated
        public void setParseResult(CommandLine.ParseResult parseResult) {
            this.parseResult = parseResult;
        }

        @Generated
        public ProjectContext getProjectContext() {
            return this.projectContext;
        }

        @Generated
        public void setProjectContext(ProjectContext projectContext) {
            this.projectContext = projectContext;
        }

        @Override
        @Generated
        public MicronautConsole getConsole() {
            return this.console;
        }

        @Generated
        public void setConsole(MicronautConsole micronautConsole) {
            this.console = micronautConsole;
        }
    }

    @ToString
    @EqualsAndHashCode
    static class ProjectContextImpl
    implements ProjectContext,
    GroovyObject {
        private MicronautConsole console;
        private File baseDir;
        private CodeGenConfig cliConfig;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public ProjectContextImpl(MicronautConsole console, File baseDir, CodeGenConfig cliConfig) {
            CodeGenConfig codeGenConfig;
            File file;
            MicronautConsole micronautConsole;
            MetaClass metaClass;
            MicronautConsole micronautConsole2;
            this.console = micronautConsole2 = MicronautConsole.getInstance();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.console = micronautConsole = console;
            this.baseDir = file = baseDir;
            this.cliConfig = codeGenConfig = cliConfig;
        }

        @Generated
        public ProjectContextImpl(MicronautConsole console, File baseDir) {
            this(console, baseDir, null);
        }

        @Generated
        public ProjectContextImpl(MicronautConsole console) {
            this(console, null, null);
        }

        @Generated
        public ProjectContextImpl() {
            this(MicronautConsole.getInstance(), null, null);
        }

        @Override
        public String navigateConfig(String ... path) {
            return ShortTypeHandling.castToString(this.cliConfig.navigate(path));
        }

        @Override
        public ConfigMap getConfig() {
            return this.cliConfig;
        }

        @Override
        public <T> T navigateConfigForType(Class<T> requiredType, String ... path) {
            return this.cliConfig.navigate(requiredType, path);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ProjectContextImpl.class) {
                return ScriptBytecodeAdapter.initMetaClass(this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("io.micronaut.cli.MicronautCli$ProjectContextImpl(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getConsole()));
            Boolean bl3 = $toStringFirst;
            if (bl3 == null ? false : bl3) {
                Boolean bl4;
                $toStringFirst = bl4 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getBaseDir()));
            Boolean bl5 = $toStringFirst;
            if (bl5 == null ? false : bl5) {
                Boolean bl6;
                $toStringFirst = bl6 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getCliConfig()));
            Boolean bl7 = $toStringFirst;
            if (bl7 == null ? false : bl7) {
                Boolean bl8;
                $toStringFirst = bl8 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString(this.getConfig()));
            _result.append(")");
            return _result.toString();
        }

        @Generated
        public int hashCode() {
            int _result = HashCodeHelper.initHash();
            if (!(this.getConsole() == this)) {
                int n;
                _result = n = HashCodeHelper.updateHash(_result, this.getConsole());
            }
            if (!(this.getBaseDir() == this)) {
                int n;
                _result = n = HashCodeHelper.updateHash(_result, this.getBaseDir());
            }
            if (!(this.getCliConfig() == this)) {
                int n;
                _result = n = HashCodeHelper.updateHash(_result, this.getCliConfig());
            }
            return _result;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof ProjectContextImpl;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectContextImpl)) {
                return false;
            }
            ProjectContextImpl otherTyped = (ProjectContextImpl)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual(this.getConsole(), otherTyped.getConsole())) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual(this.getBaseDir(), otherTyped.getBaseDir())) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual(this.getCliConfig(), otherTyped.getCliConfig()));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ProjectContextImpl.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ProjectContextImpl.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ProjectContextImpl.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ProjectContextImpl.class, MicronautCli.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty(this, string);
        }

        @Override
        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty(this, string, object);
        }

        @Override
        @Generated
        public MicronautConsole getConsole() {
            return this.console;
        }

        @Generated
        public void setConsole(MicronautConsole micronautConsole) {
            this.console = micronautConsole;
        }

        @Override
        @Generated
        public File getBaseDir() {
            return this.baseDir;
        }

        @Generated
        public void setBaseDir(File file) {
            this.baseDir = file;
        }

        @Generated
        public CodeGenConfig getCliConfig() {
            return this.cliConfig;
        }

        @Generated
        public void setCliConfig(CodeGenConfig codeGenConfig) {
            this.cliConfig = codeGenConfig;
        }
    }
}

