/*
 * Decompiled with CFR 0.152.
 */
package com.grack.nanojson;

import com.grack.nanojson.JsonBuilder;
import com.grack.nanojson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class JsonArray
extends ArrayList<Object> {
    private static final long serialVersionUID = 1L;

    public JsonArray() {
    }

    public JsonArray(int n) {
        super(n);
    }

    public JsonArray(Collection<? extends Object> collection) {
        super(collection);
    }

    public static JsonArray from(Object ... objectArray) {
        JsonArray jsonArray = new JsonArray((Collection<? extends Object>)Arrays.asList(objectArray));
        return jsonArray;
    }

    public static JsonBuilder<JsonArray> builder() {
        return new JsonBuilder<JsonArray>(new JsonArray());
    }

    @Override
    public Object get(int n) {
        return n < this.size() ? super.get(n) : null;
    }

    public JsonArray getArray(int n) {
        return this.getArray(n, null);
    }

    public JsonArray getArray(int n, JsonArray jsonArray) {
        Object object = this.get(n);
        if (object instanceof JsonArray) {
            return (JsonArray)this.get(n);
        }
        return jsonArray;
    }

    public boolean getBoolean(int n) {
        return this.getBoolean(n, false);
    }

    public boolean getBoolean(int n, Boolean bl) {
        Object object = this.get(n);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    public double getDouble(int n) {
        return this.getDouble(n, 0.0);
    }

    public double getDouble(int n, double d) {
        Object object = this.get(n);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return d;
    }

    public float getFloat(int n) {
        return this.getFloat(n, 0.0f);
    }

    public float getFloat(int n, float f) {
        Object object = this.get(n);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return f;
    }

    public int getInt(int n) {
        return this.getInt(n, 0);
    }

    public int getInt(int n, int n2) {
        Object object = this.get(n);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return n2;
    }

    public Number getNumber(int n) {
        return this.getNumber(n, null);
    }

    public Number getNumber(int n, Number number) {
        Object object = this.get(n);
        if (object instanceof Number) {
            return (Number)object;
        }
        return number;
    }

    public JsonObject getObject(int n) {
        return this.getObject(n, null);
    }

    public JsonObject getObject(int n, JsonObject jsonObject) {
        Object object = this.get(n);
        if (object instanceof JsonObject) {
            return (JsonObject)this.get(n);
        }
        return jsonObject;
    }

    public String getString(int n) {
        return this.getString(n, null);
    }

    public String getString(int n, String string) {
        Object object = this.get(n);
        if (object instanceof String) {
            return (String)this.get(n);
        }
        return string;
    }

    public boolean has(int n) {
        return n < this.size();
    }

    public boolean isBoolean(int n) {
        return this.get(n) instanceof Boolean;
    }

    public boolean isNull(int n) {
        return n < this.size() && this.get(n) == null;
    }

    public boolean isNumber(int n) {
        return this.get(n) instanceof Number;
    }

    public boolean isString(int n) {
        return this.get(n) instanceof String;
    }
}

