/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.stubs;

import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.extensions.JvmIrDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.kapt3.KaptContextForStubGeneration;
import org.jetbrains.kotlin.kapt3.base.stubs.FileInfoKt;
import org.jetbrains.kotlin.kapt3.base.stubs.KotlinPosition;
import org.jetbrains.kotlin.kapt3.stubs.KaptLineMappingCollectorBase;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.FieldNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001d*\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/kapt3/stubs/KaptLineMappingCollector;", "Lorg/jetbrains/kotlin/kapt3/stubs/KaptLineMappingCollectorBase;", "kaptContext", "Lorg/jetbrains/kotlin/kapt3/KaptContextForStubGeneration;", "<init>", "(Lorg/jetbrains/kotlin/kapt3/KaptContextForStubGeneration;)V", "registerClass", "", "clazz", "Lorg/jetbrains/org/objectweb/asm/tree/ClassNode;", "registerMethod", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "registerField", "field", "Lorg/jetbrains/org/objectweb/asm/tree/FieldNode;", "registerSignature", "declaration", "Lcom/sun/tools/javac/tree/JCTree$JCMethodDecl;", "getPosition", "Lorg/jetbrains/kotlin/kapt3/base/stubs/KotlinPosition;", "register", "asmNode", "", "fqName", "", "computeOffset", "", "ir", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "findPropertyGetterOrFieldBySyntheticAnnotationsMethod", "kotlin-annotation-processing-compiler"})
public final class KaptLineMappingCollector
extends KaptLineMappingCollectorBase {
    @NotNull
    private final KaptContextForStubGeneration kaptContext;

    public KaptLineMappingCollector(@NotNull KaptContextForStubGeneration kaptContext) {
        Intrinsics.checkNotNullParameter((Object)kaptContext, (String)"kaptContext");
        this.kaptContext = kaptContext;
    }

    public final void registerClass(@NotNull ClassNode clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        String string = clazz.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        this.register(clazz, string);
    }

    public final void registerMethod(@NotNull ClassNode clazz, @NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.register(method, clazz.name + '#' + method.name + method.desc);
    }

    public final void registerField(@NotNull ClassNode clazz, @NotNull FieldNode field) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.register(field, clazz.name + '#' + field.name);
    }

    public final void registerSignature(@NotNull JCTree.JCMethodDecl declaration, @NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.getSignatureInfo().put(FileInfoKt.getJavacSignature(declaration), method.name + method.desc);
    }

    @Nullable
    public final KotlinPosition getPosition(@NotNull ClassNode clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        return this.getLineInfo().get(clazz.name);
    }

    @Nullable
    public final KotlinPosition getPosition(@NotNull ClassNode clazz, @NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return this.getLineInfo().get(clazz.name + '#' + method.name + method.desc);
    }

    @Nullable
    public final KotlinPosition getPosition(@NotNull ClassNode clazz, @NotNull FieldNode field) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.getLineInfo().get(clazz.name + '#' + field.name);
    }

    private final void register(Object asmNode, String fqName) {
        JvmDeclarationOrigin origin = this.kaptContext.getOrigins().get(asmNode);
        JvmIrDeclarationOrigin jvmIrDeclarationOrigin = origin instanceof JvmIrDeclarationOrigin ? (JvmIrDeclarationOrigin)origin : null;
        if (jvmIrDeclarationOrigin == null || (jvmIrDeclarationOrigin = jvmIrDeclarationOrigin.getDeclaration()) == null) {
            return;
        }
        JvmIrDeclarationOrigin ir = jvmIrDeclarationOrigin;
        int offset = this.computeOffset((IrDeclaration)ir);
        this.getLineInfo().put(fqName, new KotlinPosition(JvmIrUtilsKt.getFileParent((IrDeclaration)ir).getFileEntry().getName(), false, offset));
    }

    private final int computeOffset(IrDeclaration ir) {
        IrDeclaration getter;
        if (Intrinsics.areEqual((Object)ir.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS()) && (getter = this.findPropertyGetterOrFieldBySyntheticAnnotationsMethod(ir)) != null) {
            return getter.getStartOffset();
        }
        if (ir.getStartOffset() == -1) {
            return Integer.MAX_VALUE;
        }
        if (ir instanceof IrFunction && Intrinsics.areEqual((Object)((IrFunction)ir).getName(), (Object)SpecialNames.ENUM_GET_ENTRIES) && Intrinsics.areEqual((Object)ir.getOrigin(), (Object)IrDeclarationOrigin.Companion.getENUM_CLASS_SPECIAL_MEMBER())) {
            return Integer.MAX_VALUE;
        }
        if (Intrinsics.areEqual((Object)ir.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDELEGATED_MEMBER())) {
            return Integer.MAX_VALUE;
        }
        return ir.getStartOffset();
    }

    private final IrDeclaration findPropertyGetterOrFieldBySyntheticAnnotationsMethod(IrDeclaration $this$findPropertyGetterOrFieldBySyntheticAnnotationsMethod) {
        if (!($this$findPropertyGetterOrFieldBySyntheticAnnotationsMethod instanceof IrSimpleFunction)) {
            return null;
        }
        for (IrElement declaration : SequencesKt.plus((Sequence)IrUtilsKt.getFunctions((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)$this$findPropertyGetterOrFieldBySyntheticAnnotationsMethod)), (Sequence)IrUtilsKt.getFields((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)$this$findPropertyGetterOrFieldBySyntheticAnnotationsMethod)))) {
            IrValueParameter irValueParameter;
            IrValueParameter irValueParameter2;
            IrValueParameter extensionReceiver;
            Object object;
            IrElement irElement = declaration;
            if (irElement instanceof IrSimpleFunction) {
                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol();
                object = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            } else if (irElement instanceof IrField) {
                IrPropertySymbol irPropertySymbol = ((IrField)declaration).getCorrespondingPropertySymbol();
                object = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            IrProperty property = object;
            String string = property.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String expectedAnnotationsMethodName = JvmAbi.getSyntheticMethodNameForAnnotatedProperty((String)JvmAbi.getterName((String)string));
            IrSimpleFunction irSimpleFunction = declaration instanceof IrSimpleFunction ? (IrSimpleFunction)declaration : null;
            Object object2 = extensionReceiver = irSimpleFunction != null ? irSimpleFunction.getExtensionReceiverParameter() : null;
            if (!Intrinsics.areEqual((Object)expectedAnnotationsMethodName, (Object)((IrSimpleFunction)$this$findPropertyGetterOrFieldBySyntheticAnnotationsMethod).getName().asString()) || !Intrinsics.areEqual((Object)((irValueParameter2 = extensionReceiver) != null && (irValueParameter2 = irValueParameter2.getType()) != null ? JvmIrTypeUtilsKt.getErasedUpperBound((IrType)irValueParameter2) : null), (irValueParameter = (IrValueParameter)CollectionsKt.firstOrNull((List)((IrSimpleFunction)$this$findPropertyGetterOrFieldBySyntheticAnnotationsMethod).getValueParameters())) != null && (irValueParameter = irValueParameter.getType()) != null ? JvmIrTypeUtilsKt.getErasedUpperBound((IrType)irValueParameter) : null)) continue;
            return (IrDeclaration)declaration;
        }
        return null;
    }
}

