/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.TypeCheck;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00102\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0016J(\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J \u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0016H\u0002J$\u0010 \u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n \"*\u0004\u0018\u00010\u00160\u00160!2\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160!2\u0006\u0010\u001a\u001a\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\u00020\u000b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0018\u0010'\u001a\u00020\u000b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010&R\u0018\u0010(\u001a\u00020\u000b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/js/translate/utils/TypeCheckRewritingVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "<init>", "()V", "scopes", "Ljava/util/Stack;", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "localVars", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "visit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "endVisit", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "getReplacement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "callee", "calleeArguments", "", "argument", "getReplacementForOrNull", "calleeArgument", "getReplacementForAndPredicate", "p1", "p2", "expandArgumentForTwoInvocations", "Lkotlin/Pair;", "kotlin.jvm.PlatformType", "generateAlias", "needsAlias", "getNeedsAlias", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Z", "isLocalVar", "isAssignmentToLocalVar", "js.translator"})
@SourceDebugExtension(value={"SMAP\nexpandIsCalls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 expandIsCalls.kt\norg/jetbrains/kotlin/js/translate/utils/TypeCheckRewritingVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1#2:157\n1557#3:158\n1628#3,3:159\n*S KotlinDebug\n*F\n+ 1 expandIsCalls.kt\norg/jetbrains/kotlin/js/translate/utils/TypeCheckRewritingVisitor\n*L\n42#1:158\n42#1:159,3\n*E\n"})
final class TypeCheckRewritingVisitor
extends JsVisitorWithContextImpl {
    @NotNull
    private final Stack<JsScope> scopes = new Stack();
    @NotNull
    private final Stack<Set<JsName>> localVars;

    /*
     * WARNING - void declaration
     */
    public TypeCheckRewritingVisitor() {
        void $this$localVars_u24lambda_u240;
        Stack stack;
        Stack stack2 = stack = new Stack();
        TypeCheckRewritingVisitor typeCheckRewritingVisitor = this;
        boolean bl = false;
        $this$localVars_u24lambda_u240.push((Set)new LinkedHashSet());
        typeCheckRewritingVisitor.localVars = stack;
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        void $this$mapTo$iv$iv;
        void $this$visit_u24lambda_u242;
        Set set;
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        this.scopes.push(x.getScope());
        Set set2 = set = CollectionUtilsKt.IdentitySet();
        Stack<Set<JsName>> stack = this.localVars;
        boolean bl = false;
        Collection collection = (Collection)$this$visit_u24lambda_u242;
        List<JsParameter> list = x.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(it.getName());
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CollectionsKt.addAll(collection, iterable2);
        stack.push(set);
        return super.visit(x, ctx);
    }

    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        JsName jsName = x.getName();
        Intrinsics.checkNotNullExpressionValue(jsName, "getName(...)");
        this.localVars.peek().add(jsName);
        return super.visit(x, ctx);
    }

    public void endVisit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        this.scopes.pop();
        this.localVars.pop();
        super.endVisit(x, ctx);
    }

    public boolean visit(@NotNull JsInvocation x, @NotNull JsContext<JsNode> ctx) {
        JsExpression replacement;
        JsInvocation callee;
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        JsExpression jsExpression = x.getQualifier();
        JsInvocation jsInvocation = callee = jsExpression instanceof JsInvocation ? (JsInvocation)jsExpression : null;
        List<JsExpression> calleeArguments = jsInvocation != null ? jsInvocation.getArguments() : null;
        List<JsExpression> list = x.getArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
        JsExpression argument = CollectionsKt.firstOrNull(list);
        if (callee != null && argument != null && calleeArguments != null && (replacement = this.getReplacement(callee, calleeArguments, argument)) != null) {
            ctx.replaceMe((JsNode)((JsExpression)this.accept((JsNode)replacement)).source(x.getSource()));
            return false;
        }
        return true;
    }

    private final JsExpression getReplacement(JsInvocation callee, List<? extends JsExpression> calleeArguments, JsExpression argument) {
        JsExpression jsExpression;
        TypeCheck typeCheck;
        TypeCheck typeCheck2 = typeCheck = MetadataProperties.getTypeCheck(callee);
        switch (typeCheck2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[typeCheck2.ordinal()]) {
            case 1: {
                JsBinaryOperation jsBinaryOperation;
                if (calleeArguments.size() == 1) {
                    JsExpression jsExpression2 = calleeArguments.get(0);
                    Intrinsics.checkNotNull(jsExpression2, "null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsStringLiteral");
                    jsBinaryOperation = JsAstUtils.typeOfIs(argument, (JsStringLiteral)jsExpression2);
                } else {
                    jsBinaryOperation = null;
                }
                jsExpression = jsBinaryOperation;
                break;
            }
            case 2: {
                if (calleeArguments.size() == 1) {
                    jsExpression = Namer.isInstanceOf(argument, calleeArguments.get(0));
                    break;
                }
                jsExpression = null;
                break;
            }
            case 3: {
                if (calleeArguments.size() == 1) {
                    jsExpression = this.getReplacementForOrNull(argument, calleeArguments.get(0));
                    break;
                }
                jsExpression = null;
                break;
            }
            case 4: {
                if (calleeArguments.size() == 2) {
                    jsExpression = this.getReplacementForAndPredicate(argument, calleeArguments.get(0), calleeArguments.get(1));
                    break;
                }
                jsExpression = null;
                break;
            }
            case -1: {
                jsExpression = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsExpression;
    }

    private final JsExpression getReplacementForOrNull(JsExpression argument, JsExpression calleeArgument) {
        if (calleeArgument instanceof JsInvocation && MetadataProperties.getTypeCheck((JsInvocation)calleeArgument) == TypeCheck.OR_NULL) {
            JsExpression[] jsExpressionArray = new JsExpression[]{argument};
            return new JsInvocation(calleeArgument, jsExpressionArray);
        }
        Pair<JsExpression, JsExpression> pair = this.expandArgumentForTwoInvocations(argument);
        JsExpression nullCheckTarget = pair.component1();
        JsExpression nextCheckTarget = pair.component2();
        JsBinaryOperation jsBinaryOperation = TranslationUtils.isNullCheck(nullCheckTarget);
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "isNullCheck(...)");
        JsBinaryOperation isNull = jsBinaryOperation;
        JsExpression[] jsExpressionArray = new JsExpression[]{nextCheckTarget};
        JsBinaryOperation jsBinaryOperation2 = JsAstUtils.or(isNull, new JsInvocation(calleeArgument, jsExpressionArray));
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation2, "or(...)");
        return jsBinaryOperation2;
    }

    private final JsExpression getReplacementForAndPredicate(JsExpression argument, JsExpression p1, JsExpression p2) {
        Pair<JsExpression, JsExpression> pair = this.expandArgumentForTwoInvocations(argument);
        JsExpression arg1 = pair.component1();
        JsExpression arg2 = pair.component2();
        JsExpression[] jsExpressionArray = new JsExpression[]{arg1};
        JsExpression first = (JsExpression)this.accept((JsNode)new JsInvocation(p1, jsExpressionArray));
        JsExpression[] jsExpressionArray2 = new JsExpression[]{arg2};
        JsExpression second = (JsExpression)this.accept((JsNode)new JsInvocation(p2, jsExpressionArray2));
        JsBinaryOperation jsBinaryOperation = JsAstUtils.and(first, second);
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "and(...)");
        return jsBinaryOperation;
    }

    private final Pair<JsExpression, JsExpression> expandArgumentForTwoInvocations(JsExpression argument) {
        Pair<JsExpression, JsExpression> pair;
        if (this.isAssignmentToLocalVar(argument)) {
            Intrinsics.checkNotNull(argument, "null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation");
            pair = new Pair<JsExpression, JsExpression>(argument, ((JsBinaryOperation)argument).getArg1());
        } else {
            pair = this.getNeedsAlias(argument) ? this.generateAlias(argument) : new Pair<JsExpression, JsExpression>(argument, argument);
        }
        return pair;
    }

    private final Pair<JsExpression, JsExpression> generateAlias(JsExpression argument) {
        JsName jsName = JsScope.declareTemporary();
        Intrinsics.checkNotNullExpressionValue(jsName, "declareTemporary(...)");
        JsName tmp = jsName;
        JsContext<JsStatement> jsContext = this.getLastStatementLevelContext();
        Intrinsics.checkNotNullExpressionValue(jsContext, "getLastStatementLevelContext(...)");
        JsContext<JsStatement> statementContext = jsContext;
        statementContext.addPrevious((JsNode)JsAstUtils.newVar(tmp, null));
        return new Pair<JsExpression, JsExpression>(JsAstUtils.assignment(tmp.makeRef(), argument), tmp.makeRef());
    }

    private final boolean getNeedsAlias(JsExpression $this$needsAlias) {
        return $this$needsAlias instanceof JsLiteral.JsValueLiteral ? false : !this.isLocalVar($this$needsAlias);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLocalVar(JsExpression $this$isLocalVar) {
        if (((Collection)this.localVars).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!($this$isLocalVar instanceof JsNameRef)) return false;
        JsName it = ((JsNameRef)$this$isLocalVar).getName();
        boolean bl2 = false;
        if (it == null) return false;
        if (!this.localVars.peek().contains(it)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAssignmentToLocalVar(JsExpression $this$isAssignmentToLocalVar) {
        if (((Collection)this.localVars).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Pair<JsName, JsExpression> it = JsAstUtils.decomposeAssignmentToVariable($this$isAssignmentToLocalVar);
        boolean bl2 = false;
        if (it == null) return false;
        if (!this.localVars.peek().contains(it.getFirst())) return false;
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeCheck.values().length];
            try {
                nArray[TypeCheck.TYPEOF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeCheck.INSTANCEOF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeCheck.OR_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeCheck.AND_PREDICATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

