/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 \u001d*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001dB\u001b\b\u0004\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0014\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0005J\u0014\u0010\u0018\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013J\u0013\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "D", "Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;", "", "_name", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;)V", "(Lorg/jetbrains/kotlin/diagnostics/Severity;)V", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "name", "getName", "()Ljava/lang/String;", "initializeName", "", "defaultRenderer", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "getDefaultRenderer", "()Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "setDefaultRenderer", "(Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;)V", "initDefaultRenderer", "cast", "diagnostic", "(Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;)Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;", "toString", "Companion", "frontend.common"})
@SourceDebugExtension(value={"SMAP\nDiagnosticFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticFactory.kt\norg/jetbrains/kotlin/diagnostics/DiagnosticFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public abstract class DiagnosticFactory<D extends UnboundDiagnostic> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String _name;
    @NotNull
    private final Severity severity;
    @Nullable
    private DiagnosticRenderer<? super D> defaultRenderer;

    protected DiagnosticFactory(@Nullable String _name, @NotNull Severity severity) {
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        this._name = _name;
        this.severity = severity;
    }

    @NotNull
    public Severity getSeverity() {
        return this.severity;
    }

    @NotNull
    public String getName() {
        String string2 = this._name;
        Intrinsics.checkNotNull(string2);
        return string2;
    }

    public final void initializeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        this._name = name2;
    }

    @Nullable
    public DiagnosticRenderer<D> getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public void setDefaultRenderer(@Nullable DiagnosticRenderer<? super D> diagnosticRenderer) {
        this.defaultRenderer = diagnosticRenderer;
    }

    protected DiagnosticFactory(@NotNull Severity severity) {
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        this(null, severity);
    }

    public final void initDefaultRenderer(@Nullable DiagnosticRenderer<?> defaultRenderer) {
        this.setDefaultRenderer(defaultRenderer);
    }

    @NotNull
    public final D cast(@NotNull UnboundDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        if (!(diagnostic.getFactory() == this)) {
            boolean bl = false;
            String string2 = "Factory mismatch: expected " + this + " but was " + diagnostic.getFactory();
            throw new IllegalArgumentException(string2.toString());
        }
        return (D)diagnostic;
    }

    @NotNull
    public String toString() {
        String string2 = this._name;
        if (string2 == null) {
            string2 = "<Anonymous DiagnosticFactory>";
        }
        return string2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JC\u0010\u0004\u001a\u0002H\u0005\"\b\b\u0001\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\"\u0010\b\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\n0\t\"\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ3\u0010\u0004\u001a\u0002H\u0005\"\b\b\u0001\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\n0\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory$Companion;", "", "<init>", "()V", "cast", "D", "Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;", "diagnostic", "factories", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "(Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;[Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;)Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;", "", "(Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;Ljava/util/Collection;)Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;", "frontend.common"})
    public static final class Companion {
        private Companion() {
        }

        @SafeVarargs
        @NotNull
        public final <D extends UnboundDiagnostic> D cast(@NotNull UnboundDiagnostic diagnostic, DiagnosticFactory<? extends D> ... factories) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            Intrinsics.checkNotNullParameter(factories, "factories");
            return this.cast(diagnostic, (Collection)CollectionsKt.listOf(Arrays.copyOf(factories, factories.length)));
        }

        @NotNull
        public final <D extends UnboundDiagnostic> D cast(@NotNull UnboundDiagnostic diagnostic, @NotNull Collection<? extends DiagnosticFactory<? extends D>> factories) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            Intrinsics.checkNotNullParameter(factories, "factories");
            for (DiagnosticFactory<D> factory2 : factories) {
                if (diagnostic.getFactory() != factory2) continue;
                return factory2.cast(diagnostic);
            }
            throw new IllegalArgumentException("Factory mismatch: expected one of " + factories + " but was " + diagnostic.getFactory());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

