/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.repository;

import java.util.UUID;
import org.jetbrains.kotlin.org.eclipse.aether.repository.ArtifactRepository;

public final class WorkspaceRepository
implements ArtifactRepository {
    private final String type;
    private final Object key;

    public WorkspaceRepository() {
        this("workspace");
    }

    public WorkspaceRepository(String type) {
        this(type, null);
    }

    public WorkspaceRepository(String type, Object key) {
        this.type = type != null ? type : "";
        this.key = key != null ? key : UUID.randomUUID().toString().replace("-", "");
    }

    public String getContentType() {
        return this.type;
    }

    @Override
    public String getId() {
        return "workspace";
    }

    public Object getKey() {
        return this.key;
    }

    public String toString() {
        return "(" + this.getContentType() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        WorkspaceRepository that = (WorkspaceRepository)obj;
        return this.getContentType().equals(that.getContentType()) && this.getKey().equals(that.getKey());
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.getKey().hashCode();
        hash = hash * 31 + this.getContentType().hashCode();
        return hash;
    }
}

