/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.fixStack.AnalyzeTryCatchBlocksKt;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010'\u001a\u00020\fJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0012H\u0002J\u0006\u0010+\u001a\u00020\fJ\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0012H\u0002J\u0010\u0010/\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0012H\u0002J\u0010\u00100\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0012H\u0002R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR-\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u001cj\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012`\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR9\u0010 \u001a*\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120!0\u001cj\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120!`\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001fR\u001d\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "breakContinueGotoNodes", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "Lkotlin/collections/LinkedHashSet;", "getBreakContinueGotoNodes", "()Ljava/util/LinkedHashSet;", "<set-?>", "", "consistentInlineMarkers", "getConsistentInlineMarkers", "()Z", "fakeAlwaysFalseIfeqMarkers", "Ljava/util/ArrayList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/ArrayList;", "getFakeAlwaysFalseIfeqMarkers", "()Ljava/util/ArrayList;", "fakeAlwaysTrueIfeqMarkers", "getFakeAlwaysTrueIfeqMarkers", "isThereAnyTryCatch", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "openingInlineMethodMarker", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getOpeningInlineMethodMarker", "()Ljava/util/HashMap;", "restoreStackMarkersForSaveMarker", "", "getRestoreStackMarkersForSaveMarker", "saveStackMarkerForRestoreMarker", "", "getSaveStackMarkerForRestoreMarker", "()Ljava/util/Map;", "hasAnyMarkers", "indexOf", "", "node", "isAnalysisRequired", "visitFakeAlwaysFalseIfeq", "", "insnNode", "visitFakeAlwaysTrueIfeq", "visitFixStackBeforeJump", "backend"})
@SourceDebugExtension(value={"SMAP\nFixStackContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixStackContext.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n372#2,7:107\n1313#3:114\n1314#3:116\n1#4:115\n*S KotlinDebug\n*F\n+ 1 FixStackContext.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext\n*L\n46#1:107,7\n51#1:114\n51#1:116\n*E\n"})
public final class FixStackContext {
    @NotNull
    private final MethodNode methodNode;
    @NotNull
    private final LinkedHashSet<JumpInsnNode> breakContinueGotoNodes;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysTrueIfeqMarkers;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysFalseIfeqMarkers;
    private final boolean isThereAnyTryCatch;
    @NotNull
    private final Map<AbstractInsnNode, AbstractInsnNode> saveStackMarkerForRestoreMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, List<AbstractInsnNode>> restoreStackMarkersForSaveMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> openingInlineMethodMarker;
    private boolean consistentInlineMarkers;

    public FixStackContext(@NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        this.methodNode = methodNode;
        this.breakContinueGotoNodes = new LinkedHashSet();
        this.fakeAlwaysTrueIfeqMarkers = new ArrayList();
        this.fakeAlwaysFalseIfeqMarkers = new ArrayList();
        this.saveStackMarkerForRestoreMarker = AnalyzeTryCatchBlocksKt.insertTryCatchBlocksMarkers(this.methodNode);
        this.restoreStackMarkersForSaveMarker = new HashMap();
        this.openingInlineMethodMarker = new HashMap();
        this.consistentInlineMarkers = true;
        this.isThereAnyTryCatch = !this.saveStackMarkerForRestoreMarker.isEmpty();
        for (Map.Entry<AbstractInsnNode, AbstractInsnNode> entry : this.saveStackMarkerForRestoreMarker.entrySet()) {
            Object object;
            AbstractInsnNode restore = entry.getKey();
            AbstractInsnNode save = entry.getValue();
            Map $this$getOrPut$iv = this.restoreStackMarkersForSaveMarker;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(save);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new SmartList();
                $this$getOrPut$iv.put(save, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(restore);
        }
        Stack<AbstractInsnNode> inlineMarkersStack = new Stack<AbstractInsnNode>();
        InsnList insnList = this.methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue(insnList, "methodNode.instructions");
        Sequence $this$forEach$iv = new InsnSequence(insnList);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object t;
            boolean bl;
            Object element$iv = iterator2.next();
            AbstractInsnNode insnNode = (AbstractInsnNode)element$iv;
            boolean bl2 = false;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(insnNode);
            if (pseudoInsn == PseudoInsn.FIX_STACK_BEFORE_JUMP) {
                this.visitFixStackBeforeJump(insnNode);
                continue;
            }
            if (pseudoInsn == PseudoInsn.FAKE_ALWAYS_TRUE_IFEQ) {
                this.visitFakeAlwaysTrueIfeq(insnNode);
                continue;
            }
            if (pseudoInsn == PseudoInsn.FAKE_ALWAYS_FALSE_IFEQ) {
                this.visitFakeAlwaysFalseIfeq(insnNode);
                continue;
            }
            if (InlineCodegenUtilsKt.isBeforeInlineMarker(insnNode)) {
                inlineMarkersStack.push(insnNode);
                continue;
            }
            if (!InlineCodegenUtilsKt.isAfterInlineMarker(insnNode)) continue;
            boolean bl3 = bl = !((Collection)inlineMarkersStack).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Mismatching after inline method marker at " + this.indexOf(insnNode);
                throw new AssertionError((Object)string2);
            }
            Map map = this.openingInlineMethodMarker;
            Intrinsics.checkNotNullExpressionValue(inlineMarkersStack.pop(), "inlineMarkersStack.pop()");
            map.put(insnNode, t);
        }
        if (!((Collection)inlineMarkersStack).isEmpty()) {
            this.consistentInlineMarkers = false;
        }
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    @NotNull
    public final LinkedHashSet<JumpInsnNode> getBreakContinueGotoNodes() {
        return this.breakContinueGotoNodes;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysTrueIfeqMarkers() {
        return this.fakeAlwaysTrueIfeqMarkers;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysFalseIfeqMarkers() {
        return this.fakeAlwaysFalseIfeqMarkers;
    }

    public final boolean isThereAnyTryCatch() {
        return this.isThereAnyTryCatch;
    }

    @NotNull
    public final Map<AbstractInsnNode, AbstractInsnNode> getSaveStackMarkerForRestoreMarker() {
        return this.saveStackMarkerForRestoreMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, List<AbstractInsnNode>> getRestoreStackMarkersForSaveMarker() {
        return this.restoreStackMarkersForSaveMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getOpeningInlineMethodMarker() {
        return this.openingInlineMethodMarker;
    }

    public final boolean getConsistentInlineMarkers() {
        return this.consistentInlineMarkers;
    }

    private final void visitFixStackBeforeJump(AbstractInsnNode insnNode) {
        boolean bl;
        AbstractInsnNode next = insnNode.getNext();
        boolean bl2 = bl = next.getOpcode() == 167;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = this.indexOf(insnNode) + ": should be followed by GOTO";
            throw new AssertionError((Object)string2);
        }
        Intrinsics.checkNotNull(next, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        this.breakContinueGotoNodes.add((JumpInsnNode)next);
    }

    private final void visitFakeAlwaysTrueIfeq(AbstractInsnNode insnNode) {
        boolean bl;
        boolean bl2 = bl = insnNode.getNext().getOpcode() == 153;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = this.indexOf(insnNode) + ": should be followed by IFEQ";
            throw new AssertionError((Object)string2);
        }
        this.fakeAlwaysTrueIfeqMarkers.add(insnNode);
    }

    private final void visitFakeAlwaysFalseIfeq(AbstractInsnNode insnNode) {
        boolean bl;
        boolean bl2 = bl = insnNode.getNext().getOpcode() == 153;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = this.indexOf(insnNode) + ": should be followed by IFEQ";
            throw new AssertionError((Object)string2);
        }
        this.fakeAlwaysFalseIfeqMarkers.add(insnNode);
    }

    private final int indexOf(AbstractInsnNode node) {
        return this.methodNode.instructions.indexOf(node);
    }

    public final boolean hasAnyMarkers() {
        return !((Collection)this.breakContinueGotoNodes).isEmpty() || !((Collection)this.fakeAlwaysTrueIfeqMarkers).isEmpty() || !((Collection)this.fakeAlwaysFalseIfeqMarkers).isEmpty() || this.isThereAnyTryCatch || !((Map)this.openingInlineMethodMarker).isEmpty();
    }

    public final boolean isAnalysisRequired() {
        return !((Collection)this.breakContinueGotoNodes).isEmpty() || this.isThereAnyTryCatch || !((Map)this.openingInlineMethodMarker).isEmpty();
    }
}

