/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SharedProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamedObjectProviderBinding
implements ProviderBinding {
    private final Map<String, List<ProviderBinding.ProviderInfo<ElementPattern<?>>>> myNamesToProvidersMap = new HashMap(5);
    private final Map<String, List<ProviderBinding.ProviderInfo<ElementPattern<?>>>> myNamesToProvidersMapInsensitive = new HashMap(5);

    public void registerProvider(@NonNls String @NotNull [] names2, @NotNull ElementPattern<?> filter2, boolean caseSensitive, @NotNull PsiReferenceProvider provider2, double priority) {
        if (names2 == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(0);
        }
        if (filter2 == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(1);
        }
        if (provider2 == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(2);
        }
        Map<String, List<ProviderBinding.ProviderInfo<ElementPattern<?>>>> map = caseSensitive ? this.myNamesToProvidersMap : this.myNamesToProvidersMapInsensitive;
        for (String attributeName : names2) {
            String key = caseSensitive ? attributeName : StringUtil.toLowerCase(attributeName);
            List<ProviderBinding.ProviderInfo<ElementPattern<?>>> psiReferenceProviders = map.get(key);
            if (psiReferenceProviders == null) {
                psiReferenceProviders = new SmartList();
                map.put(key, psiReferenceProviders);
            }
            psiReferenceProviders.add(new ProviderBinding.ProviderInfo(provider2, filter2, priority));
        }
    }

    @Override
    public void addAcceptableReferenceProviders(@NotNull PsiElement position, @NotNull List<? super ProviderBinding.ProviderInfo<ProcessingContext>> list2, @NotNull PsiReferenceService.Hints hints) {
        String name2;
        if (position == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(3);
        }
        if (list2 == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(4);
        }
        if (hints == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(5);
        }
        if ((name2 = this.getName(position)) != null) {
            NamedObjectProviderBinding.addMatchingProviders(position, ContainerUtil.notNullize(this.myNamesToProvidersMap.get(name2)), list2, hints);
            NamedObjectProviderBinding.addMatchingProviders(position, ContainerUtil.notNullize(this.myNamesToProvidersMapInsensitive.get(StringUtil.toLowerCase(name2))), list2, hints);
        }
    }

    @Override
    public void unregisterProvider(@NotNull PsiReferenceProvider provider2) {
        if (provider2 == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(6);
        }
        for (List<ProviderBinding.ProviderInfo<ElementPattern<?>>> list2 : this.myNamesToProvidersMap.values()) {
            list2.removeIf(trinity -> trinity.provider.equals(provider2));
        }
        for (List<ProviderBinding.ProviderInfo<ElementPattern<?>>> list2 : this.myNamesToProvidersMapInsensitive.values()) {
            list2.removeIf(trinity -> trinity.provider.equals(provider2));
        }
    }

    boolean isEmpty() {
        return this.myNamesToProvidersMap.isEmpty() && this.myNamesToProvidersMapInsensitive.isEmpty();
    }

    @Nullable
    protected abstract String getName(@NotNull PsiElement var1);

    static void addMatchingProviders(@NotNull PsiElement position, @NotNull @NotNull List<? extends @NotNull ProviderBinding.ProviderInfo<ElementPattern<?>>> providerList, @NotNull Collection<? super ProviderBinding.ProviderInfo<ProcessingContext>> output, @NotNull PsiReferenceService.Hints hints) {
        if (position == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(7);
        }
        if (providerList == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(8);
        }
        if (output == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(9);
        }
        if (hints == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(10);
        }
        SharedProcessingContext sharedProcessingContext = new SharedProcessingContext();
        for (int i = 0; i < providerList.size(); ++i) {
            ProviderBinding.ProviderInfo<ElementPattern<?>> info = providerList.get(i);
            if (hints != PsiReferenceService.Hints.NO_HINTS && !info.provider.acceptsHints(position, hints)) continue;
            ProcessingContext context = new ProcessingContext(sharedProcessingContext);
            boolean suitable = false;
            try {
                suitable = ((ElementPattern)info.processingContext).accepts(position, context);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (!suitable) continue;
            output.add(new ProviderBinding.ProviderInfo<ProcessingContext>(info.provider, context, info.priority));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addAcceptableReferenceProviders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterProvider";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addMatchingProviders";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

