/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.extensions;

import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aB\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\u0004\b\u0001\u0010\u00012\u0006\u0010\u0004\u001a\u0002H\u00022\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00010\u0006\u00a2\u0006\u0002\b\u0007H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\t"}, d2={"withLinkageErrorLogger", "R", "T", "", "receiver", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "frontend"})
public final class ExtensionsUtilKt {
    public static final <T, R> R withLinkageErrorLogger(@NotNull T receiver, @NotNull Function1<? super T, ? extends R> block) {
        Intrinsics.checkNotNullParameter(receiver, "receiver");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withLinkageErrorLogger = false;
        try {
            return block.invoke(receiver);
        }
        catch (LinkageError e) {
            Logger logger = Logger.getInstance(receiver.getClass());
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(receiver::class.java)");
            Logger logger2 = logger;
            logger2.error(receiver.getClass().getName() + " caused LinkageError", e);
            throw e;
        }
    }
}

