/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js.internal;

import com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.inline.util.FixForwardNameReferencesKt;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JSONKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapError;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapLocationRemapper;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParseResult;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParser;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSuccess;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilderConsumer;
import org.jetbrains.kotlin.js.util.TextOutputImpl;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\u0019\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\n\u001a.\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002\u00a8\u0006\u0014"}, d2={"collectFiles", "", "rootFile", "Ljava/io/File;", "target", "", "main", "args", "", "", "([Ljava/lang/String;)V", "mergeStdlibParts", "outputFile", "wrapperFile", "baseDir", "inputPaths", "", "createInsertionPlace", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "cli-js"})
@JvmName(name="JSStdlibLinker")
@SourceDebugExtension(value={"SMAP\nJSStdlibLinker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSStdlibLinker.kt\norg/jetbrains/kotlin/cli/js/internal/JSStdlibLinker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,145:1\n1549#2:146\n1620#2,3:147\n1855#2,2:150\n1549#2:152\n1620#2,3:153\n37#3,2:156\n*S KotlinDebug\n*F\n+ 1 JSStdlibLinker.kt\norg/jetbrains/kotlin/cli/js/internal/JSStdlibLinker\n*L\n28#1:146\n28#1:147,3\n47#1:150,2\n96#1:152\n96#1:153,3\n103#1:156,2\n*E\n"})
public final class JSStdlibLinker {
    /*
     * WARNING - void declaration
     */
    public static final void main(@NotNull String[] args) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(args, "args");
        File outputFile = new File(args[0]);
        File baseDir = new File(args[1]).getCanonicalFile();
        File wrapperFile = new File(args[2]);
        Iterable $this$map$iv = ArraysKt.drop(args, 3);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)it));
        }
        List inputPaths = (List)destination$iv$iv;
        Intrinsics.checkNotNullExpressionValue(baseDir, "baseDir");
        JSStdlibLinker.mergeStdlibParts(outputFile, wrapperFile, baseDir, inputPaths);
    }

    /*
     * WARNING - void declaration
     */
    private static final void mergeStdlibParts(File outputFile, File wrapperFile, File baseDir, List<? extends File> inputPaths) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        JsProgram program = new JsProgram();
        String string2 = FilesKt.readText$default(wrapperFile, null, 1, null);
        ErrorReporter errorReporter = ThrowExceptionOnErrorReporter.INSTANCE;
        JsObjectScope jsObjectScope = program.getScope();
        Intrinsics.checkNotNullExpressionValue(jsObjectScope, "program.scope");
        List<JsStatement> list2 = ParserUtilsKt.parse(string2, errorReporter, jsObjectScope, JSStdlibLinker.mergeStdlibParts$makeRelativeIfNecessary(wrapperFile, baseDir));
        if (list2 == null) {
            throw new IllegalStateException("Should not be null because of error reporter".toString());
        }
        List<JsStatement> wrapper = list2;
        JsBlock insertionPlace = JSStdlibLinker.createInsertionPlace(wrapper);
        List allFiles = new ArrayList();
        Iterable $this$forEach$iv = inputPaths;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            File it = (File)element$iv;
            boolean bl = false;
            JSStdlibLinker.collectFiles(it, allFiles);
        }
        for (File file2 : allFiles) {
            List<JsStatement> statements2;
            String string3 = FilesKt.readText$default(file2, null, 1, null);
            ErrorReporter errorReporter2 = ThrowExceptionOnErrorReporter.INSTANCE;
            JsObjectScope jsObjectScope2 = program.getScope();
            Intrinsics.checkNotNullExpressionValue(jsObjectScope2, "program.scope");
            if (ParserUtilsKt.parse(string3, errorReporter2, jsObjectScope2, JSStdlibLinker.mergeStdlibParts$makeRelativeIfNecessary(file2, baseDir)) == null) {
                throw new IllegalStateException("Should not be null because of error reporter".toString());
            }
            JsBlock block = new JsBlock(statements2);
            FixForwardNameReferencesKt.fixForwardNameReferences(block);
            File sourceMapFile = new File(file2.getParent(), file2.getName() + ".map");
            if (sourceMapFile.exists()) {
                SourceMapParseResult sourceMapParse = SourceMapParser.INSTANCE.parse(sourceMapFile);
                if (sourceMapParse instanceof SourceMapError) {
                    System.err.println("Error parsing source map file " + sourceMapFile + ": " + ((SourceMapError)sourceMapParse).getMessage());
                    System.exit(1);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                if (sourceMapParse instanceof SourceMapSuccess) {
                    SourceMap sourceMap2 = ((SourceMapSuccess)sourceMapParse).getValue();
                    SourceMapLocationRemapper remapper2 = new SourceMapLocationRemapper(sourceMap2, null, 2, null);
                    remapper2.remap(block);
                }
            }
            List<JsStatement> list3 = insertionPlace.getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, "insertionPlace.statements");
            CollectionsKt.addAll((Collection)list3, (Iterable)statements2);
        }
        List<JsStatement> list4 = program.getGlobalBlock().getStatements();
        Intrinsics.checkNotNullExpressionValue(list4, "program.globalBlock.statements");
        CollectionsKt.addAll((Collection)list4, (Iterable)wrapper);
        File sourceMapFile = new File(outputFile.getParentFile(), outputFile.getName() + ".map");
        TextOutputImpl textOutput = new TextOutputImpl();
        SourceMap3Builder sourceMapBuilder2 = new SourceMap3Builder(outputFile, new Function0<Integer>((Object)textOutput){

            @NotNull
            public final Integer invoke() {
                return ((TextOutputImpl)this.receiver).getColumn();
            }

            @NotNull
            public final String getSignature() {
                return "getColumn()I";
            }

            @NotNull
            public final String getName() {
                return "getColumn";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(TextOutputImpl.class);
            }
        }, "");
        SourceMapBuilderConsumer consumer = new SourceMapBuilderConsumer(new File("."), sourceMapBuilder2, new SourceFilePathResolver(new ArrayList(), null, 2, null), true, true);
        program.getGlobalBlock().accept(new JsToStringGenerationVisitor(textOutput, consumer));
        String sourceMapContent = sourceMapBuilder2.build();
        String string4 = textOutput.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "textOutput.toString()");
        String programText = string4;
        FilesKt.writeText$default(outputFile, programText + "\n//# sourceMappingURL=" + sourceMapFile.getName() + '\n', null, 2, null);
        JsonNode sourceMapJson = JSONKt.parseJson(sourceMapContent);
        Intrinsics.checkNotNull(sourceMapJson, "null cannot be cast to non-null type org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject");
        JsonNode jsonNode = ((JsonObject)sourceMapJson).getProperties().get("sources");
        Intrinsics.checkNotNull(jsonNode, "null cannot be cast to non-null type org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray");
        JsonArray sources = (JsonArray)jsonNode;
        Map<String, JsonNode> map = ((JsonObject)sourceMapJson).getProperties();
        String string5 = "sourcesContent";
        Iterable $this$map$iv = sources.getElements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sourcePath;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(sourcePath, "null cannot be cast to non-null type org.jetbrains.kotlin.js.parser.sourcemaps.JsonString");
            File sourceFile = new File(((JsonString)sourcePath).getValue());
            collection.add(sourceFile.exists() ? (JsonNode)new JsonString(FilesKt.readText$default(sourceFile, null, 1, null)) : (JsonNode)JsonNull.INSTANCE);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new JsonNode[0]);
        JsonNode[] jsonNodeArray = Arrays.copyOf(object, ((JsonNode[])object).length);
        object = new JsonArray(jsonNodeArray);
        map.put(string5, (JsonNode)object);
        FilesKt.writeText$default(sourceMapFile, sourceMapJson.toString(), null, 2, null);
    }

    private static final JsBlock createInsertionPlace(List<? extends JsStatement> $this$createInsertionPlace) {
        JsCompositeBlock block = new JsCompositeBlock();
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(block){
            final /* synthetic */ JsCompositeBlock $block;
            {
                this.$block = $block;
            }

            public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<? super JsStatement> ctx) {
                boolean bl;
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "x.expression");
                if (this.isInsertionPlace(jsExpression)) {
                    ctx.replaceMe((JsNode)this.$block);
                    bl = false;
                } else {
                    bl = super.visit(x, ctx);
                }
                return bl;
            }

            private final boolean isInsertionPlace(JsExpression expression2) {
                block5: {
                    block4: {
                        if (!(expression2 instanceof JsInvocation)) break block4;
                        List<JsExpression> list2 = ((JsInvocation)expression2).getArguments();
                        Intrinsics.checkNotNullExpressionValue(list2, "expression.arguments");
                        if (!(!((Collection)list2).isEmpty())) break block5;
                    }
                    return false;
                }
                JsExpression jsExpression = ((JsInvocation)expression2).getQualifier();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "expression.qualifier");
                JsExpression qualifier2 = jsExpression;
                if (!(qualifier2 instanceof JsNameRef) || ((JsNameRef)qualifier2).getQualifier() != null) {
                    return false;
                }
                return Intrinsics.areEqual(((JsNameRef)qualifier2).getIdent(), "insertContent");
            }
        };
        for (JsStatement jsStatement : $this$createInsertionPlace) {
            visitor2.accept((JsNode)jsStatement);
        }
        return block;
    }

    private static final void collectFiles(File rootFile, List<File> target) {
        if (rootFile.isDirectory()) {
            File[] fileArray = rootFile.listFiles();
            if (fileArray == null) {
                throw new IllegalStateException(("Problem with listing files in " + rootFile).toString());
            }
            for (File child : ArraysKt.sorted((Comparable[])fileArray)) {
                Intrinsics.checkNotNullExpressionValue(child, "child");
                JSStdlibLinker.collectFiles(child, target);
            }
        } else if (Intrinsics.areEqual(FilesKt.getExtension(rootFile), "js")) {
            ((Collection)target).add(rootFile);
        }
    }

    private static final String mergeStdlibParts$makeRelativeIfNecessary(File $this$mergeStdlibParts_u24makeRelativeIfNecessary, File $baseDir) {
        File file2 = $this$mergeStdlibParts_u24makeRelativeIfNecessary.getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue(file2, "canonicalFile");
        return FilesKt.toRelativeString(file2, $baseDir);
    }
}

