/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CodeAnalysisMeasurement;
import org.jetbrains.kotlin.cli.common.CodeGenerationMeasurement;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CompilerInitializationMeasurement;
import org.jetbrains.kotlin.cli.common.GarbageCollectionMeasurement;
import org.jetbrains.kotlin.cli.common.IRMeasurement;
import org.jetbrains.kotlin.cli.common.JitCompilationMeasurement;
import org.jetbrains.kotlin.cli.common.PerformanceCounterMeasurement;
import org.jetbrains.kotlin.cli.common.PerformanceMeasurement;
import org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0017\b&\u0018\u00002\u00020\u0001:\u0001GB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006H\u0002J\u000e\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020'J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001d01J\u0006\u00102\u001a\u00020\u0003J\b\u00103\u001a\u00020'H\u0016J\b\u00104\u001a\u00020'H\u0016J\b\u00105\u001a\u00020'H\u0016J \u00106\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0003H\u0016J\b\u00107\u001a\u00020'H\u0016J\b\u00108\u001a\u00020'H\u0016J\b\u00109\u001a\u00020'H\u0016J\b\u0010:\u001a\u00020'H\u0016J\b\u0010;\u001a\u00020'H\u0016J\b\u0010<\u001a\u00020'H\u0016J\b\u0010=\u001a\u00020'H\u0016J\b\u0010>\u001a\u00020'H\u0016J\u0018\u0010?\u001a\u00020'2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\bH\u0016J\b\u0010B\u001a\u00020'H\u0002J\b\u0010C\u001a\u00020'H\u0002J\b\u0010D\u001a\u00020'H\u0002J\b\u0010E\u001a\u00020'H\u0002J\u0006\u0010F\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0019\u0010\n\"\u0004\b\u001a\u0010\fR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020$0#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "", "presentableName", "", "(Ljava/lang/String;)V", "analysisStart", "", "files", "", "getFiles", "()Ljava/lang/Integer;", "setFiles", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "generationStart", "initStartNanos", "irGenerationStart", "irLoweringStart", "irTranslationStart", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "lines", "getLines", "setLines", "measurements", "", "Lorg/jetbrains/kotlin/cli/common/PerformanceMeasurement;", "getMeasurements$annotations", "()V", "getMeasurements", "()Ljava/util/List;", "startGCData", "", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager$GCData;", "targetDescription", "addSourcesStats", "", "createPerformanceReport", "", "deltaTime", "start", "dumpPerformanceReport", "destination", "Ljava/io/File;", "enableCollectingPerformanceStatistics", "getMeasurementResults", "", "getTargetInfo", "notifyAnalysisFinished", "notifyAnalysisStarted", "notifyCompilationFinished", "notifyCompilerInitialized", "notifyGenerationFinished", "notifyGenerationStarted", "notifyIRGenerationFinished", "notifyIRGenerationStarted", "notifyIRLoweringFinished", "notifyIRLoweringStarted", "notifyIRTranslationFinished", "notifyIRTranslationStarted", "notifyRepeat", "total", "number", "recordGcTime", "recordInitializationTime", "recordJitCompilationTime", "recordPerfCountersMeasurements", "renderCompilerPerformance", "GCData", "cli"})
@SourceDebugExtension(value={"SMAP\nCommonCompilerPerformanceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonCompilerPerformanceManager.kt\norg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1253#2,4:179\n1855#2,2:183\n1549#2:185\n1620#2,3:186\n1855#2,2:189\n766#2:191\n857#2,2:192\n*E\n*S KotlinDebug\n*F\n+ 1 CommonCompilerPerformanceManager.kt\norg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager\n*L\n40#1,4:179\n131#1,2:183\n161#1:185\n161#1,3:186\n161#1,2:189\n171#1:191\n171#1,2:192\n*E\n"})
public abstract class CommonCompilerPerformanceManager {
    @NotNull
    private final List<PerformanceMeasurement> measurements;
    private boolean isEnabled;
    private long initStartNanos;
    private long analysisStart;
    private long generationStart;
    private Map<String, GCData> startGCData;
    private long irTranslationStart;
    private long irLoweringStart;
    private long irGenerationStart;
    private String targetDescription;
    @Nullable
    private Integer files;
    @Nullable
    private Integer lines;
    private final String presentableName;

    protected static /* synthetic */ void getMeasurements$annotations() {
    }

    @NotNull
    protected final List<PerformanceMeasurement> getMeasurements() {
        return this.measurements;
    }

    protected final boolean isEnabled() {
        return this.isEnabled;
    }

    protected final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Nullable
    protected final Integer getFiles() {
        return this.files;
    }

    protected final void setFiles(@Nullable Integer n) {
        this.files = n;
    }

    @Nullable
    protected final Integer getLines() {
        return this.lines;
    }

    protected final void setLines(@Nullable Integer n) {
        this.lines = n;
    }

    @NotNull
    public final String getTargetInfo() {
        return this.targetDescription + ", " + this.files + " files (" + this.lines + " lines)";
    }

    @NotNull
    public final List<PerformanceMeasurement> getMeasurementResults() {
        return this.measurements;
    }

    /*
     * WARNING - void declaration
     */
    public final void enableCollectingPerformanceStatistics() {
        void $this$associateTo$iv;
        this.isEnabled = true;
        PerformanceCounter.Companion.setTimeCounterEnabled(true);
        List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list2, "ManagementFactory.getGarbageCollectorMXBeans()");
        Iterable iterable = list2;
        Map<String, GCData> destination$iv = this.startGCData;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map<String, GCData> map = destination$iv;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl = false;
            GarbageCollectorMXBean garbageCollectorMXBean = it;
            Intrinsics.checkNotNullExpressionValue(garbageCollectorMXBean, "it");
            Pair<String, GCData> pair = TuplesKt.to(garbageCollectorMXBean.getName(), new GCData(it));
            map.put(pair.getFirst(), pair.getSecond());
        }
    }

    private final long deltaTime(long start) {
        return PerformanceCounter.Companion.currentTime() - start;
    }

    public void notifyCompilerInitialized(int files2, int lines, @NotNull String targetDescription) {
        Intrinsics.checkNotNullParameter(targetDescription, "targetDescription");
        if (!this.isEnabled) {
            return;
        }
        this.recordInitializationTime();
        this.files = files2;
        this.lines = lines;
        this.targetDescription = targetDescription;
    }

    public void notifyCompilationFinished() {
        if (!this.isEnabled) {
            return;
        }
        this.recordGcTime();
        this.recordJitCompilationTime();
        this.recordPerfCountersMeasurements();
    }

    public void addSourcesStats(int files2, int lines) {
        if (!this.isEnabled) {
            return;
        }
        Integer n = this.files;
        this.files = n != null ? n + files2 : files2;
        Integer n2 = this.lines;
        this.lines = n2 != null ? n2 + lines : lines;
    }

    public void notifyAnalysisStarted() {
        this.analysisStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyAnalysisFinished() {
        long time = PerformanceCounter.Companion.currentTime() - this.analysisStart;
        Collection collection = this.measurements;
        CodeAnalysisMeasurement codeAnalysisMeasurement = new CodeAnalysisMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time));
        collection.add(codeAnalysisMeasurement);
    }

    public void notifyGenerationStarted() {
        this.generationStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyGenerationFinished() {
        long time = PerformanceCounter.Companion.currentTime() - this.generationStart;
        Collection collection = this.measurements;
        CodeGenerationMeasurement codeGenerationMeasurement = new CodeGenerationMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time));
        collection.add(codeGenerationMeasurement);
    }

    public void notifyIRTranslationStarted() {
        this.irTranslationStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyIRTranslationFinished() {
        long time = this.deltaTime(this.irTranslationStart);
        Collection collection = this.measurements;
        IRMeasurement iRMeasurement = new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.TRANSLATION);
        collection.add(iRMeasurement);
    }

    public void notifyIRLoweringStarted() {
        this.irLoweringStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyIRLoweringFinished() {
        long time = this.deltaTime(this.irLoweringStart);
        Collection collection = this.measurements;
        IRMeasurement iRMeasurement = new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.LOWERING);
        collection.add(iRMeasurement);
    }

    public void notifyIRGenerationStarted() {
        this.irGenerationStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyIRGenerationFinished() {
        long time = this.deltaTime(this.irGenerationStart);
        Collection collection = this.measurements;
        IRMeasurement iRMeasurement = new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.GENERATION);
        collection.add(iRMeasurement);
    }

    public final void dumpPerformanceReport(@NotNull File destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        FilesKt.writeBytes(destination, this.createPerformanceReport());
    }

    private final void recordGcTime() {
        if (!this.isEnabled) {
            return;
        }
        List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list2, "ManagementFactory.getGarbageCollectorMXBeans()");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GCData startCounts;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl = false;
            GarbageCollectorMXBean garbageCollectorMXBean = it;
            Intrinsics.checkNotNullExpressionValue(garbageCollectorMXBean, "it");
            GCData gCData = startCounts = this.startGCData.get(garbageCollectorMXBean.getName());
            long startCollectionTime = gCData != null ? gCData.getCollectionTime() : 0L;
            GCData gCData2 = startCounts;
            long startCollectionCount = gCData2 != null ? gCData2.getCollectionCount() : 0L;
            Collection collection = this.measurements;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "it.name");
            GarbageCollectionMeasurement garbageCollectionMeasurement = new GarbageCollectionMeasurement(string2, it.getCollectionTime() - startCollectionTime, it.getCollectionCount() - startCollectionCount);
            collection.add(garbageCollectionMeasurement);
        }
    }

    private final void recordJitCompilationTime() {
        if (!this.isEnabled) {
            return;
        }
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean == null) {
            return;
        }
        CompilationMXBean bean = compilationMXBean;
        Collection collection = this.measurements;
        JitCompilationMeasurement jitCompilationMeasurement = new JitCompilationMeasurement(bean.getTotalCompilationTime());
        collection.add(jitCompilationMeasurement);
    }

    private final void recordInitializationTime() {
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.initStartNanos);
        Collection collection = this.measurements;
        CompilerInitializationMeasurement compilerInitializationMeasurement = new CompilerInitializationMeasurement(time);
        collection.add(compilerInitializationMeasurement);
    }

    private final void recordPerfCountersMeasurements() {
        PerformanceCounter.Companion.report((Function1<? super String, Unit>)new Function1<String, Unit>(this){
            final /* synthetic */ CommonCompilerPerformanceManager this$0;

            public final void invoke(@NotNull String s) {
                Intrinsics.checkNotNullParameter(s, "s");
                Collection collection = this.this$0.getMeasurements();
                PerformanceCounterMeasurement performanceCounterMeasurement = new PerformanceCounterMeasurement(s);
                collection.add(performanceCounterMeasurement);
            }
            {
                this.this$0 = commonCompilerPerformanceManager;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] createPerformanceReport() {
        void $this$mapTo$iv$iv;
        CharSequence charSequence2 = new StringBuilder();
        StringBuilder $this$buildString = charSequence2;
        boolean bl = false;
        $this$buildString.append(this.presentableName + " performance report\n");
        Iterable $this$map$iv = this.measurements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerformanceMeasurement performanceMeasurement = (PerformanceMeasurement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string2 = it.render();
            collection.add(string2);
        }
        Iterable $this$forEach$iv = CollectionsKt.sorted((List)destination$iv$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            $this$buildString.append(it + '\n');
        }
        String string3 = ((StringBuilder)charSequence2).toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
        charSequence2 = string3;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = ((String)charSequence2).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    public void notifyRepeat(int total, int number2) {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderCompilerPerformance() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getMeasurementResults();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PerformanceMeasurement it = (PerformanceMeasurement)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof CompilerInitializationMeasurement || it instanceof CodeAnalysisMeasurement || it instanceof CodeGenerationMeasurement || it instanceof PerformanceCounterMeasurement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantMeasurements = (List)destination$iv$iv;
        return "Compiler perf stats:\n" + CollectionsKt.joinToString$default(relevantMeasurements, "\n", null, null, 0, null, renderCompilerPerformance.1.INSTANCE, 30, null);
    }

    public CommonCompilerPerformanceManager(@NotNull String presentableName2) {
        Intrinsics.checkNotNullParameter(presentableName2, "presentableName");
        this.presentableName = presentableName2;
        this.measurements = new ArrayList();
        this.initStartNanos = PerformanceCounter.Companion.currentTime();
        this.startGCData = new LinkedHashMap();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager$GCData;", "", "bean", "Ljava/lang/management/GarbageCollectorMXBean;", "(Ljava/lang/management/GarbageCollectorMXBean;)V", "name", "", "collectionTime", "", "collectionCount", "(Ljava/lang/String;JJ)V", "getCollectionCount", "()J", "getCollectionTime", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "cli"})
    private static final class GCData {
        @NotNull
        private final String name;
        private final long collectionTime;
        private final long collectionCount;

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getCollectionTime() {
            return this.collectionTime;
        }

        public final long getCollectionCount() {
            return this.collectionCount;
        }

        public GCData(@NotNull String name, long collectionTime, long collectionCount) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
            this.collectionTime = collectionTime;
            this.collectionCount = collectionCount;
        }

        public GCData(@NotNull GarbageCollectorMXBean bean) {
            Intrinsics.checkNotNullParameter(bean, "bean");
            String string2 = bean.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "bean.name");
            this(string2, bean.getCollectionTime(), bean.getCollectionCount());
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final long component2() {
            return this.collectionTime;
        }

        public final long component3() {
            return this.collectionCount;
        }

        @NotNull
        public final GCData copy(@NotNull String name, long collectionTime, long collectionCount) {
            Intrinsics.checkNotNullParameter(name, "name");
            return new GCData(name, collectionTime, collectionCount);
        }

        public static /* synthetic */ GCData copy$default(GCData gCData, String string2, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = gCData.name;
            }
            if ((n & 2) != 0) {
                l = gCData.collectionTime;
            }
            if ((n & 4) != 0) {
                l2 = gCData.collectionCount;
            }
            return gCData.copy(string2, l, l2);
        }

        @NotNull
        public String toString() {
            return "GCData(name=" + this.name + ", collectionTime=" + this.collectionTime + ", collectionCount=" + this.collectionCount + ")";
        }

        public int hashCode() {
            String string2 = this.name;
            return ((string2 != null ? string2.hashCode() : 0) * 31 + Long.hashCode(this.collectionTime)) * 31 + Long.hashCode(this.collectionCount);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GCData)) break block3;
                    GCData gCData = (GCData)object;
                    if (!Intrinsics.areEqual(this.name, gCData.name) || this.collectionTime != gCData.collectionTime || this.collectionCount != gCData.collectionCount) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

