/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.proto.AccessorIdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.CommonIdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.CompositeSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.FileLocalIdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.FileSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.IdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.LocalSignature;
import org.jetbrains.kotlin.ir.util.IdSignature;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\tJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t0$R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "", "libraryFile", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "fileSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;)V", "signatureCache", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/collections/HashMap;", "deserializeAccessorIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "proto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/AccessorIdSignature;", "deserializeCompositeIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CompositeSignature;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/CompositeSignature;", "deserializeFileIdSignature", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/FileSignature;", "deserializeFileLocalIdSignature", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/FileLocalIdSignature;", "deserializeIdSignature", "index", "deserializeLocalIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$LocalSignature;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/LocalSignature;", "deserializePublicIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/CommonIdSignature;", "deserializeScopeLocalIdSignature", "deserializeSignatureData", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IdSignature;", "loadSignatureProto", "signatureToIndexMapping", "", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIdSignatureDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdSignatureDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n361#2,7:99\n1#3:106\n1179#4,2:107\n1253#4,4:109\n*S KotlinDebug\n*F\n+ 1 IdSignatureDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer\n*L\n31#1:99,7\n96#1:107,2\n96#1:109,4\n*E\n"})
public final class IdSignatureDeserializer {
    @NotNull
    private final IrLibraryFile libraryFile;
    @Nullable
    private final IdSignature.FileSignature fileSignature;
    @NotNull
    private final HashMap<Integer, org.jetbrains.kotlin.ir.util.IdSignature> signatureCache;

    public IdSignatureDeserializer(@NotNull IrLibraryFile libraryFile, @Nullable IdSignature.FileSignature fileSignature) {
        Intrinsics.checkNotNullParameter(libraryFile, "libraryFile");
        this.libraryFile = libraryFile;
        this.fileSignature = fileSignature;
        this.signatureCache = new HashMap();
    }

    private final IdSignature loadSignatureProto(int index2) {
        return this.libraryFile.signature(index2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final org.jetbrains.kotlin.ir.util.IdSignature deserializeIdSignature(int index2) {
        Object object;
        void $this$getOrPut$iv;
        Map map = this.signatureCache;
        Integer key$iv = index2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature sigData = this.loadSignatureProto(index2);
            org.jetbrains.kotlin.ir.util.IdSignature answer$iv = this.deserializeSignatureData(sigData);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (org.jetbrains.kotlin.ir.util.IdSignature)object;
    }

    private final IdSignature.CommonSignature deserializePublicIdSignature(CommonIdSignature proto) {
        List<Integer> list2 = proto.getPackageFqNameList();
        Intrinsics.checkNotNullExpressionValue(list2, "proto.packageFqNameList");
        String pkg = IrFileDeserializerKt.deserializeFqName(this.libraryFile, list2);
        List<Integer> list3 = proto.getDeclarationFqNameList();
        Intrinsics.checkNotNullExpressionValue(list3, "proto.declarationFqNameList");
        String cls = IrFileDeserializerKt.deserializeFqName(this.libraryFile, list3);
        Long memberId = proto.hasMemberUniqId() ? Long.valueOf(proto.getMemberUniqId()) : null;
        return new IdSignature.CommonSignature(pkg, cls, memberId, proto.getFlags());
    }

    private final IdSignature.AccessorSignature deserializeAccessorIdSignature(AccessorIdSignature proto) {
        org.jetbrains.kotlin.ir.util.IdSignature propertySignature = this.deserializeIdSignature(proto.getPropertySignature());
        if (!(propertySignature instanceof IdSignature.CommonSignature)) {
            boolean $i$a$-require-IdSignatureDeserializer$deserializeAccessorIdSignature$22 = false;
            String $i$a$-require-IdSignatureDeserializer$deserializeAccessorIdSignature$22 = "For public accessor corresponding property supposed to be public as well";
            throw new IllegalArgumentException($i$a$-require-IdSignatureDeserializer$deserializeAccessorIdSignature$22.toString());
        }
        String name = this.libraryFile.string(proto.getName());
        long hash = proto.getAccessorHashId();
        long mask = proto.getFlags();
        IdSignature.CommonSignature accessorSignature = new IdSignature.CommonSignature(((IdSignature.CommonSignature)propertySignature).getPackageFqName(), ((IdSignature.CommonSignature)propertySignature).getDeclarationFqName() + '.' + name, hash, mask);
        return new IdSignature.AccessorSignature(propertySignature, accessorSignature);
    }

    private final org.jetbrains.kotlin.ir.util.IdSignature deserializeFileLocalIdSignature(FileLocalIdSignature proto) {
        return new IdSignature.FileLocalSignature(this.deserializeIdSignature(proto.getContainer()), proto.getLocalId(), null, 4, null);
    }

    private final org.jetbrains.kotlin.ir.util.IdSignature deserializeScopeLocalIdSignature(int proto) {
        return new IdSignature.ScopeLocalDeclaration(proto, null, 2, null);
    }

    private final IdSignature.CompositeSignature deserializeCompositeIdSignature(CompositeSignature proto) {
        org.jetbrains.kotlin.ir.util.IdSignature containerSig = this.deserializeIdSignature(proto.getContainerSig());
        org.jetbrains.kotlin.ir.util.IdSignature innerSig = this.deserializeIdSignature(proto.getInnerSig());
        return new IdSignature.CompositeSignature(containerSig, innerSig);
    }

    private final IdSignature.LocalSignature deserializeLocalIdSignature(LocalSignature proto) {
        List<Integer> list2 = proto.getLocalFqNameList();
        Intrinsics.checkNotNullExpressionValue(list2, "proto.localFqNameList");
        String localFqn = IrFileDeserializerKt.deserializeFqName(this.libraryFile, list2);
        Long localHash = proto.hasLocalHash() ? Long.valueOf(proto.getLocalHash()) : null;
        String description2 = proto.hasDebugInfo() ? this.libraryFile.debugInfo(proto.getDebugInfo()) : null;
        return new IdSignature.LocalSignature(localFqn, localHash, description2);
    }

    private final IdSignature.FileSignature deserializeFileIdSignature(FileSignature proto) {
        IdSignature.FileSignature fileSignature = this.fileSignature;
        if (fileSignature == null) {
            throw new IllegalStateException("Provide file symbol".toString());
        }
        return fileSignature;
    }

    private final org.jetbrains.kotlin.ir.util.IdSignature deserializeSignatureData(IdSignature proto) {
        org.jetbrains.kotlin.ir.util.IdSignature idSignature;
        IdSignature.IdSigCase idSigCase = proto.getIdSigCase();
        switch (idSigCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[idSigCase.ordinal()]) {
            case 1: {
                CommonIdSignature commonIdSignature = proto.getPublicSig();
                Intrinsics.checkNotNullExpressionValue(commonIdSignature, "proto.publicSig");
                idSignature = this.deserializePublicIdSignature(commonIdSignature);
                break;
            }
            case 2: {
                AccessorIdSignature accessorIdSignature = proto.getAccessorSig();
                Intrinsics.checkNotNullExpressionValue(accessorIdSignature, "proto.accessorSig");
                idSignature = this.deserializeAccessorIdSignature(accessorIdSignature);
                break;
            }
            case 3: {
                FileLocalIdSignature fileLocalIdSignature = proto.getPrivateSig();
                Intrinsics.checkNotNullExpressionValue(fileLocalIdSignature, "proto.privateSig");
                idSignature = this.deserializeFileLocalIdSignature(fileLocalIdSignature);
                break;
            }
            case 4: {
                idSignature = this.deserializeScopeLocalIdSignature(proto.getScopedLocalSig());
                break;
            }
            case 5: {
                CompositeSignature compositeSignature = proto.getCompositeSig();
                Intrinsics.checkNotNullExpressionValue(compositeSignature, "proto.compositeSig");
                idSignature = this.deserializeCompositeIdSignature(compositeSignature);
                break;
            }
            case 6: {
                LocalSignature localSignature = proto.getLocalSig();
                Intrinsics.checkNotNullExpressionValue(localSignature, "proto.localSig");
                idSignature = this.deserializeLocalIdSignature(localSignature);
                break;
            }
            case 7: {
                FileSignature fileSignature = proto.getFileSig();
                Intrinsics.checkNotNullExpressionValue(fileSignature, "proto.fileSig");
                idSignature = this.deserializeFileIdSignature(fileSignature);
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected IdSignature kind: " + proto.getIdSigCase()).toString());
            }
        }
        return idSignature;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<org.jetbrains.kotlin.ir.util.IdSignature, Integer> signatureToIndexMapping() {
        void $this$associateTo$iv$iv;
        Set<Map.Entry<Integer, org.jetbrains.kotlin.ir.util.IdSignature>> set = this.signatureCache.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "signatureCache.entries");
        Iterable $this$associate$iv = set;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getValue(), it.getKey());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IdSignature.IdSigCase.values().length];
            try {
                nArray[IdSignature.IdSigCase.PUBLIC_SIG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.ACCESSOR_SIG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.PRIVATE_SIG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.SCOPED_LOCAL_SIG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.COMPOSITE_SIG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.LOCAL_SIG.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.FILE_SIG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

