/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.runner.Runner;
import org.jetbrains.kotlin.runner.RunnerException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH$J@\u0010\f\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/runner/AbstractRunner;", "Lorg/jetbrains/kotlin/runner/Runner;", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "createClassLoader", "Ljava/lang/ClassLoader;", "classpath", "", "Ljava/net/URL;", "run", "", "compilerArguments", "arguments", "compilerClasspath", "kotlin-runner"})
public abstract class AbstractRunner
implements Runner {
    @NotNull
    protected abstract String getClassName();

    @NotNull
    protected abstract ClassLoader createClassLoader(@NotNull List<URL> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(@NotNull List<URL> classpath, @NotNull List<String> compilerArguments, @NotNull List<String> arguments, @NotNull List<URL> compilerClasspath) {
        Object e3;
        Class<?> clazz;
        Intrinsics.checkNotNullParameter(classpath, "classpath");
        Intrinsics.checkNotNullParameter(compilerArguments, "compilerArguments");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        Intrinsics.checkNotNullParameter(compilerClasspath, "compilerClasspath");
        ClassLoader classLoader = this.createClassLoader(classpath);
        try {
            clazz = classLoader.loadClass(this.getClassName());
        }
        catch (ClassNotFoundException e2) {
            throw new RunnerException("could not find or load main class " + this.getClassName(), null, 2, null);
        }
        catch (NoClassDefFoundError e3) {
            String message = StringsKt.trimIndent("\n                could not find or load main class " + this.getClassName() + "\n                Caused by: " + e3 + "\n            ");
            throw new RunnerException(message, null, 2, null);
        }
        Class<?> mainClass = clazz;
        try {
            e3 = new Class[]{String[].class};
            e3 = mainClass.getDeclaredMethod("main", (Class<?>)e3);
        }
        catch (NoSuchMethodException e4) {
            throw new RunnerException("'main' method not found in class " + this.getClassName(), null, 2, null);
        }
        Object main = e3;
        if (!Modifier.isStatic(((Method)main).getModifiers())) {
            throw new RunnerException("'main' method of class " + this.getClassName() + " is not static. Please ensure that 'main' is either a top level Kotlin function, a member function annotated with @JvmStatic, or a static Java method", null, 2, null);
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        Iterable iterable = classpath;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue(string, "pathSeparator");
        String savedClasspathProperty = System.setProperty("java.class.path", CollectionsKt.joinToString$default(iterable, string, null, null, 0, null, null, 62, null));
        try {
            Object[] e4 = new Object[1];
            Collection $this$toTypedArray$iv = arguments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            e4[0] = thisCollection$iv.toArray(new String[0]);
            ((Method)main).invoke(null, e4);
        }
        catch (IllegalAccessException e5) {
            throw new RunnerException("'main' method of class " + this.getClassName() + " is not public", null, 2, null);
        }
        catch (InvocationTargetException e6) {
            Throwable throwable = e6.getTargetException();
            Intrinsics.checkNotNullExpressionValue(throwable, "e.targetException");
            throw throwable;
        }
        finally {
            if (savedClasspathProperty == null) {
                System.clearProperty("java.class.path");
            } else {
                System.setProperty("java.class.path", savedClasspathProperty);
            }
        }
    }
}

