/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\t\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\nH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\f"}, d2={"isInterface", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Z", "isAccessorOfOverriddenStableProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "overriddenStableProperty", "overridesExternal", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableDeclaration;", "shouldExportAccessor", "backend.js"})
public final class JsClassGeneratorKt {
    public static final boolean shouldExportAccessor(@Nullable IrSimpleFunction $this$shouldExportAccessor, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        if ($this$shouldExportAccessor == null) {
            return false;
        }
        if (ExportModelGeneratorKt.isExported(IrUtilsKt.getParentAsClass($this$shouldExportAccessor), context)) {
            return true;
        }
        return JsClassGeneratorKt.isAccessorOfOverriddenStableProperty($this$shouldExportAccessor, context);
    }

    public static final boolean overriddenStableProperty(@NotNull IrSimpleFunction $this$overriddenStableProperty, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter($this$overriddenStableProperty, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        IrPropertySymbol irPropertySymbol = $this$overriddenStableProperty.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull(irPropertySymbol);
        IrProperty property2 = (IrProperty)irPropertySymbol.getOwner();
        if (ExportModelGeneratorKt.isOverriddenExported(property2, context)) {
            return ExportModelGeneratorKt.isOverriddenExported($this$overriddenStableProperty, context);
        }
        return JsClassGeneratorKt.overridesExternal($this$overriddenStableProperty) || AnnotationUtilsKt.getJsName(property2) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAccessorOfOverriddenStableProperty(@NotNull IrSimpleFunction $this$isAccessorOfOverriddenStableProperty, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter($this$isAccessorOfOverriddenStableProperty, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        if (JsClassGeneratorKt.overriddenStableProperty($this$isAccessorOfOverriddenStableProperty, context)) return true;
        IrPropertySymbol irPropertySymbol = $this$isAccessorOfOverriddenStableProperty.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull(irPropertySymbol);
        if (!JsClassGeneratorKt.overridesExternal((IrOverridableDeclaration)irPropertySymbol.getOwner())) return false;
        return true;
    }

    private static final boolean overridesExternal(IrOverridableDeclaration<?> $this$overridesExternal) {
        boolean bl;
        block4: {
            if (IrUtilsKt.isEffectivelyExternal($this$overridesExternal)) {
                return true;
            }
            Iterable $this$any$iv = $this$overridesExternal.getOverriddenSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSymbol it = (IrSymbol)element$iv;
                    boolean bl2 = false;
                    IrSymbolOwner irSymbolOwner = it.getOwner();
                    Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration<*>");
                    if (!JsClassGeneratorKt.overridesExternal((IrOverridableDeclaration)irSymbolOwner)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isInterface(IrClassifierSymbol $this$isInterface) {
        IrSymbolOwner irSymbolOwner = $this$isInterface.getOwner();
        IrClass irClass2 = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
        return irClass2 != null ? IrUtilsKt.isInterface(irClass2) : false;
    }

    public static final /* synthetic */ boolean access$overridesExternal(IrOverridableDeclaration $receiver) {
        return JsClassGeneratorKt.overridesExternal($receiver);
    }

    public static final /* synthetic */ boolean access$isInterface(IrClassifierSymbol $receiver) {
        return JsClassGeneratorKt.isInterface($receiver);
    }
}

