/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bJ\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0002\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\rH\u0082\u0010J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0019H\u0016J\u001a\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\f\u0010\"\u001a\u00020\r*\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\u00020\r*\u00020\u000e8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineReferenceLocator;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "inlineCallSites", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver$CallSite;", "inlineFunctionCallSites", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "isPrivateInline", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "findContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "scope", "approximateToPackage", "visitCall", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitInlineLambda", "argument", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "callee", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitSimpleFunction", "declaration", "isCoroutineIntrinsic", "CallSite", "backend.jvm"})
public final class IrInlineScopeResolver
extends IrInlineReferenceLocator {
    @NotNull
    private final Map<IrFunction, CallSite> inlineCallSites;
    @NotNull
    private final Map<IrFunction, Set<IrElement>> inlineFunctionCallSites;

    public IrInlineScopeResolver(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        super(context);
        this.inlineCallSites = new LinkedHashMap();
        this.inlineFunctionCallSites = new LinkedHashMap();
    }

    @Override
    public void visitInlineLambda(@NotNull IrFunctionReference argument2, @NotNull IrFunction callee, @NotNull IrValueParameter parameter, @NotNull IrDeclaration scope2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Intrinsics.checkNotNullParameter(callee, "callee");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        this.inlineCallSites.put(((IrFunctionSymbol)argument2.getSymbol()).getOwner(), new CallSite(scope2, parameter.isCrossinline() && !this.isCoroutineIntrinsic(callee)));
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable IrDeclaration data) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrInlineScopeResolver irInlineScopeResolver = this;
        IrSimpleFunction $this$isPrivateInline$iv = declaration;
        boolean $i$f$isPrivateInline = false;
        if ($this$isPrivateInline$iv.isInline() && DescriptorVisibilities.isPrivate($this$isPrivateInline$iv.getVisibility())) {
            this.inlineFunctionCallSites.putIfAbsent(declaration, new LinkedHashSet());
        }
        super.visitSimpleFunction(declaration, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable IrDeclaration data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        IrInlineScopeResolver irInlineScopeResolver = this;
        IrSimpleFunction $this$isPrivateInline$iv = callee;
        boolean $i$f$isPrivateInline = false;
        if ($this$isPrivateInline$iv.isInline() && DescriptorVisibilities.isPrivate($this$isPrivateInline$iv.getVisibility()) && data != null) {
            Set set;
            Map<IrFunction, Set<IrElement>> $this$getOrPut$iv = this.inlineFunctionCallSites;
            boolean $i$f$getOrPut = false;
            Set value$iv = $this$getOrPut$iv.get(callee);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(callee, answer$iv);
                set = answer$iv;
            } else {
                set = value$iv;
            }
            TypeIntrinsics.asMutableSet(set).add(data);
        }
        super.visitCall(expression2, data);
    }

    private final boolean isCoroutineIntrinsic(IrFunction $this$isCoroutineIntrinsic) {
        return Intrinsics.areEqual($this$isCoroutineIntrinsic.getName().asString(), "suspendCoroutine") && Intrinsics.areEqual(IrUtilsKt.getPackageFragment($this$isCoroutineIntrinsic).getFqName(), new FqName("kotlin.coroutines")) || Intrinsics.areEqual($this$isCoroutineIntrinsic.getName().asString(), "suspendCoroutineUninterceptedOrReturn") && Intrinsics.areEqual(IrUtilsKt.getPackageFragment($this$isCoroutineIntrinsic).getFqName(), new FqName("kotlin.coroutines.intrinsics"));
    }

    @Nullable
    public final IrDeclarationContainer findContainer(@NotNull IrElement scope2) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return this.findContainer(scope2, false);
    }

    /*
     * WARNING - void declaration
     */
    private final IrDeclarationContainer findContainer(IrElement context, boolean approximateToPackage) {
        IrDeclarationContainer irDeclarationContainer;
        block15: {
            while (true) {
                IrInlineScopeResolver this_;
                boolean bl;
                IrElement irElement;
                IrInlineScopeResolver irInlineScopeResolver;
                CallSite callSite = this_.inlineCallSites.get(context);
                if (callSite != null) {
                    irInlineScopeResolver = this_;
                    irElement = callSite.getParent();
                    bl = approximateToPackage || callSite.getApproximateToPackage();
                    this_ = irInlineScopeResolver;
                    context = irElement;
                    approximateToPackage = bl;
                    continue;
                }
                if (context instanceof IrFunction && ((IrFunction)context).isInline()) {
                    CallSite callSite2;
                    Set<IrElement> callSites;
                    if (this_.inlineFunctionCallSites.get(context) == null) {
                        return null;
                    }
                    this_.inlineCallSites.put((IrFunction)context, new CallSite(null, false));
                    if (callSites.isEmpty()) {
                        callSite2 = new CallSite(((IrFunction)context).getParent(), false);
                    } else if (callSites.size() == 1) {
                        callSite2 = new CallSite((IrElement)CollectionsKt.single((Iterable)callSites), false);
                    } else {
                        IrDeclarationContainer single2;
                        boolean bl2;
                        Object t;
                        block14: {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = callSites;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                IrElement irElement2 = (IrElement)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl3 = false;
                                IrDeclarationContainer irDeclarationContainer2 = this_.findContainer((IrElement)it, false);
                                if (irDeclarationContainer2 == null) {
                                    return null;
                                }
                                collection.add(irDeclarationContainer2);
                            }
                            List results = (List)destination$iv$iv;
                            t = CollectionsKt.first(results);
                            IrDeclarationContainer it = (IrDeclarationContainer)t;
                            boolean bl4 = false;
                            Iterable $this$all$iv = results;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    IrDeclarationContainer other = (IrDeclarationContainer)element$iv;
                                    boolean bl5 = false;
                                    if (it == other) continue;
                                    bl2 = false;
                                    break block14;
                                }
                                bl2 = true;
                            }
                        }
                        IrDeclarationContainer irDeclarationContainer3 = single2 = (IrDeclarationContainer)(bl2 ? t : null);
                        callSite2 = new CallSite(irDeclarationContainer3 != null ? (IrDeclarationParent)irDeclarationContainer3 : ((IrFunction)context).getParent(), single2 == null);
                    }
                    CallSite commonCallSite = callSite2;
                    this_.inlineCallSites.put((IrFunction)context, commonCallSite);
                    IrInlineScopeResolver irInlineScopeResolver2 = this_;
                    IrElement irElement3 = commonCallSite.getParent();
                    boolean bl6 = approximateToPackage || commonCallSite.getApproximateToPackage();
                    this_ = irInlineScopeResolver2;
                    context = irElement3;
                    approximateToPackage = bl6;
                    continue;
                }
                if (context instanceof IrClass && !approximateToPackage) {
                    irDeclarationContainer = (IrDeclarationContainer)context;
                    break block15;
                }
                if (!(context instanceof IrDeclaration)) break;
                irInlineScopeResolver = this_;
                irElement = ((IrDeclaration)context).getParent();
                bl = approximateToPackage;
                this_ = irInlineScopeResolver;
                context = irElement;
                approximateToPackage = bl;
            }
            irDeclarationContainer = context instanceof IrPackageFragment ? (IrPackageFragment)context : null;
        }
        return irDeclarationContainer;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver$CallSite;", "", "parent", "Lorg/jetbrains/kotlin/ir/IrElement;", "approximateToPackage", "", "(Lorg/jetbrains/kotlin/ir/IrElement;Z)V", "getApproximateToPackage", "()Z", "getParent", "()Lorg/jetbrains/kotlin/ir/IrElement;", "backend.jvm"})
    private static final class CallSite {
        @Nullable
        private final IrElement parent;
        private final boolean approximateToPackage;

        public CallSite(@Nullable IrElement parent2, boolean approximateToPackage) {
            this.parent = parent2;
            this.approximateToPackage = approximateToPackage;
        }

        @Nullable
        public final IrElement getParent() {
            return this.parent;
        }

        public final boolean getApproximateToPackage() {
            return this.approximateToPackage;
        }
    }
}

