/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.serialization.ElementValueInput;
import kotlinx.serialization.ElementValueOutput;
import kotlinx.serialization.KInput;
import kotlinx.serialization.KOutput;
import kotlinx.serialization.KSerialClassDesc;
import kotlinx.serialization.KSerialClassKind;
import kotlinx.serialization.KSerialLoader;
import kotlinx.serialization.KSerialSaver;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.ScopeKt;
import kotlinx.serialization.SerialContext;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationKt;
import kotlinx.serialization.UpdateMode;
import kotlinx.serialization.json.JSON;
import kotlinx.serialization.json.JSON$Companion$WhenMappings;
import kotlinx.serialization.json.JSON$JsonInput$WhenMappings;
import kotlinx.serialization.json.JSON$JsonOutput$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u0000 02\u00020\u0001:\u0006012345BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c2\u0003J\u000e\u0010\u0019\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001aJ\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JG\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\"\u0010\"\u001a\u0002H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u00012\u0006\u0010$\u001a\u00020\u0006H\u0086\b\u00a2\u0006\u0002\u0010%J'\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H#0'2\u0006\u0010$\u001a\u00020\u0006\u00a2\u0006\u0002\u0010(J\"\u0010)\u001a\u00020\u0006\"\n\b\u0000\u0010#\u0018\u0001*\u00020\u00012\u0006\u0010*\u001a\u0002H#H\u0086\b\u00a2\u0006\u0002\u0010+J'\u0010)\u001a\u00020\u0006\"\u0004\b\u0000\u0010#2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H#0-2\u0006\u0010*\u001a\u0002H#\u00a2\u0006\u0002\u0010.J\t\u0010/\u001a\u00020\u0006H\u00d6\u0001R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u000fR\u0016\u0010\u0007\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\b\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00066"}, d2={"Lkotlinx/serialization/json/JSON;", "", "unquoted", "", "indented", "indent", "", "nonstrict", "updateMode", "Lkotlinx/serialization/UpdateMode;", "context", "Lkotlinx/serialization/SerialContext;", "(ZZLjava/lang/String;ZLkotlinx/serialization/UpdateMode;Lkotlinx/serialization/SerialContext;)V", "getContext", "()Lkotlinx/serialization/SerialContext;", "indented$1", "getNonstrict$kotlinx_serialization_runtime", "()Z", "nonstrict$1", "unquoted$1", "getUpdateMode", "()Lkotlinx/serialization/UpdateMode;", "component1", "component2", "component3", "component4", "component4$kotlinx_serialization_runtime", "component5", "component6", "copy", "equals", "other", "hashCode", "", "parse", "T", "str", "(Ljava/lang/String;)Ljava/lang/Object;", "loader", "Lkotlinx/serialization/KSerialLoader;", "(Lkotlinx/serialization/KSerialLoader;Ljava/lang/String;)Ljava/lang/Object;", "stringify", "obj", "(Ljava/lang/Object;)Ljava/lang/String;", "saver", "Lkotlinx/serialization/KSerialSaver;", "(Lkotlinx/serialization/KSerialSaver;Ljava/lang/Object;)Ljava/lang/String;", "toString", "Companion", "Composer", "JsonInput", "JsonOutput", "Mode", "Parser", "kotlinx-serialization-runtime"})
public final class JSON {
    private final boolean unquoted$1;
    private final boolean indented$1;
    private final String indent;
    private final boolean nonstrict$1;
    @NotNull
    private final UpdateMode updateMode;
    @Nullable
    private final SerialContext context;
    @NotNull
    private static final JSON plain;
    @NotNull
    private static final JSON unquoted;
    @NotNull
    private static final JSON indented;
    @NotNull
    private static final JSON nonstrict;
    private static final String NULL = "null";
    private static final char COMMA = ',';
    private static final char COLON = ':';
    private static final char BEGIN_OBJ = '{';
    private static final char END_OBJ = '}';
    private static final char BEGIN_LIST = '[';
    private static final char END_LIST = ']';
    private static final char STRING = '\"';
    private static final char STRING_ESC = '\\';
    private static final char INVALID = '\u0000';
    private static final char UNICODE_ESC = 'u';
    private static final byte TC_OTHER = 0;
    private static final byte TC_EOF = 1;
    private static final byte TC_INVALID = 2;
    private static final byte TC_WS = 3;
    private static final byte TC_COMMA = 4;
    private static final byte TC_COLON = 5;
    private static final byte TC_BEGIN_OBJ = 6;
    private static final byte TC_END_OBJ = 7;
    private static final byte TC_BEGIN_LIST = 8;
    private static final byte TC_END_LIST = 9;
    private static final byte TC_STRING = 10;
    private static final byte TC_STRING_ESC = 11;
    private static final byte TC_NULL = 12;
    private static final int CTC_MAX = 126;
    private static final int CTC_OFS = 1;
    private static final byte[] C2TC;
    private static final int C2ESC_MAX = 93;
    private static final int ESC2C_MAX = 117;
    private static final byte[] C2ESC;
    private static final byte[] ESC2C;
    public static final Companion Companion;

    @NotNull
    public final <T> String stringify(@NotNull KSerialSaver<? super T> saver, T obj) {
        Intrinsics.checkParameterIsNotNull(saver, (String)"saver");
        StringWriter sw = new StringWriter();
        JsonOutput output = new JsonOutput(Mode.OBJ, new Composer(sw));
        output.write(saver, obj);
        String string = sw.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sw.toString()");
        return string;
    }

    private final <T> String stringify(T obj) {
        SerialContext serialContext = this.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.stringify(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), obj);
    }

    public final <T> T parse(@NotNull KSerialLoader<T> loader, @NotNull String str) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Parser parser = new Parser(new StringReader(str));
        JsonInput input = new JsonInput(Mode.OBJ, parser);
        T result = input.read(loader);
        boolean bl2 = bl = parser.getCurTc() == 1;
        if (!bl) {
            String string = "Shall parse complete string";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return result;
    }

    private final <T> T parse(String str) {
        SerialContext serialContext = this.getContext();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.parse(ScopeKt.klassSerializer(serialContext, Reflection.getOrCreateKotlinClass(Object.class)), str);
    }

    public final boolean getNonstrict$kotlinx_serialization_runtime() {
        return this.nonstrict$1;
    }

    @NotNull
    public final UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    @Nullable
    public final SerialContext getContext() {
        return this.context;
    }

    public JSON(boolean unquoted, boolean indented, @NotNull String indent, boolean nonstrict, @NotNull UpdateMode updateMode, @Nullable SerialContext context) {
        Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
        Intrinsics.checkParameterIsNotNull((Object)((Object)updateMode), (String)"updateMode");
        this.unquoted$1 = unquoted;
        this.indented$1 = indented;
        this.indent = indent;
        this.nonstrict$1 = nonstrict;
        this.updateMode = updateMode;
        this.context = context;
    }

    public /* synthetic */ JSON(boolean bl, boolean bl2, String string, boolean bl3, UpdateMode updateMode, SerialContext serialContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            string = "    ";
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            updateMode = UpdateMode.OVERWRITE;
        }
        if ((n & 0x20) != 0) {
            serialContext = null;
        }
        this(bl, bl2, string, bl3, updateMode, serialContext);
    }

    public JSON() {
        this(false, false, null, false, null, null, 63, null);
    }

    static {
        int i;
        Companion = new Companion(null);
        plain = new JSON(false, false, null, false, null, null, 63, null);
        unquoted = new JSON(true, false, null, false, null, null, 62, null);
        indented = new JSON(false, true, null, false, null, null, 61, null);
        nonstrict = new JSON(false, false, null, true, null, null, 55, null);
        C2TC = new byte[127];
        Companion.initC2TC(-1, (byte)1);
        int n = 0;
        int n2 = 32;
        while (n <= n2) {
            Companion.initC2TC(i, (byte)2);
            ++i;
        }
        Companion.initC2TC(9, (byte)3);
        Companion.initC2TC(10, (byte)3);
        Companion.initC2TC(13, (byte)3);
        Companion.initC2TC(32, (byte)3);
        Companion.initC2TC(',', (byte)4);
        Companion.initC2TC(':', (byte)5);
        Companion.initC2TC('{', (byte)6);
        Companion.initC2TC('}', (byte)7);
        Companion.initC2TC('[', (byte)8);
        Companion.initC2TC(']', (byte)9);
        Companion.initC2TC('\"', (byte)10);
        Companion.initC2TC('\\', (byte)11);
        C2ESC = new byte[93];
        ESC2C = new byte[117];
        n2 = 31;
        for (i = 0; i <= n2; ++i) {
            Companion.initC2ESC(i, 'u');
        }
        Companion.initC2ESC(8, 'b');
        Companion.initC2ESC(9, 't');
        Companion.initC2ESC(10, 'n');
        Companion.initC2ESC(12, 'f');
        Companion.initC2ESC(13, 'r');
        Companion.initC2ESC('/', '/');
        Companion.initC2ESC('\"', '\"');
        Companion.initC2ESC('\\', '\\');
    }

    private final boolean component1() {
        return this.unquoted$1;
    }

    private final boolean component2() {
        return this.indented$1;
    }

    private final String component3() {
        return this.indent;
    }

    public final boolean component4$kotlinx_serialization_runtime() {
        return this.nonstrict$1;
    }

    @NotNull
    public final UpdateMode component5() {
        return this.updateMode;
    }

    @Nullable
    public final SerialContext component6() {
        return this.context;
    }

    @NotNull
    public final JSON copy(boolean unquoted, boolean indented, @NotNull String indent, boolean nonstrict, @NotNull UpdateMode updateMode, @Nullable SerialContext context) {
        Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
        Intrinsics.checkParameterIsNotNull((Object)((Object)updateMode), (String)"updateMode");
        return new JSON(unquoted, indented, indent, nonstrict, updateMode, context);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ JSON copy$default(JSON jSON, boolean bl, boolean bl2, String string, boolean bl3, UpdateMode updateMode, SerialContext serialContext, int n, Object object) {
        if ((n & 1) != 0) {
            bl = jSON.unquoted$1;
        }
        if ((n & 2) != 0) {
            bl2 = jSON.indented$1;
        }
        if ((n & 4) != 0) {
            string = jSON.indent;
        }
        if ((n & 8) != 0) {
            bl3 = jSON.nonstrict$1;
        }
        if ((n & 0x10) != 0) {
            updateMode = jSON.updateMode;
        }
        if ((n & 0x20) != 0) {
            serialContext = jSON.context;
        }
        return jSON.copy(bl, bl2, string, bl3, updateMode, serialContext);
    }

    public String toString() {
        return "JSON(unquoted=" + this.unquoted$1 + ", indented=" + this.indented$1 + ", indent=" + this.indent + ", nonstrict=" + this.nonstrict$1 + ", updateMode=" + (Object)((Object)this.updateMode) + ", context=" + this.context + ")";
    }

    public int hashCode() {
        int n = this.unquoted$1 ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int n2 = n * 31;
        int n3 = this.indented$1 ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        String string = this.indent;
        int n4 = ((n2 + n3) * 31 + (string != null ? string.hashCode() : 0)) * 31;
        int n5 = this.nonstrict$1 ? 1 : 0;
        if (n5 != 0) {
            n5 = 1;
        }
        UpdateMode updateMode = this.updateMode;
        SerialContext serialContext = this.context;
        return ((n4 + n5) * 31 + (updateMode != null ? ((Object)((Object)updateMode)).hashCode() : 0)) * 31 + (serialContext != null ? serialContext.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JSON)) break block3;
                JSON jSON = (JSON)object;
                if (!(this.unquoted$1 == jSON.unquoted$1) || !(this.indented$1 == jSON.indented$1) || !Intrinsics.areEqual((Object)this.indent, (Object)jSON.indent) || !(this.nonstrict$1 == jSON.nonstrict$1) || !Intrinsics.areEqual((Object)((Object)this.updateMode), (Object)((Object)jSON.updateMode)) || !Intrinsics.areEqual((Object)this.context, (Object)jSON.context)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u000b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/json/JSON$Mode;", "", "begin", "", "end", "(Ljava/lang/String;ICC)V", "getBegin", "()C", "beginTc", "", "getBeginTc", "()B", "getEnd", "endTc", "getEndTc", "OBJ", "LIST", "MAP", "POLY", "ENTRY", "kotlinx-serialization-runtime"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode OBJ;
        public static final /* enum */ Mode LIST;
        public static final /* enum */ Mode MAP;
        public static final /* enum */ Mode POLY;
        public static final /* enum */ Mode ENTRY;
        private static final /* synthetic */ Mode[] $VALUES;
        private final byte beginTc;
        private final byte endTc;
        private final char begin;
        private final char end;

        static {
            Mode[] modeArray = new Mode[5];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = OBJ = new Mode('{', '}');
            modeArray[1] = LIST = new Mode('[', ']');
            modeArray[2] = MAP = new Mode('{', '}');
            modeArray[3] = POLY = new Mode('[', ']');
            modeArray[4] = ENTRY = new Mode('\u0000', '\u0000');
            $VALUES = modeArray;
        }

        public final byte getBeginTc() {
            return this.beginTc;
        }

        public final byte getEndTc() {
            return this.endTc;
        }

        public final char getBegin() {
            return this.begin;
        }

        public final char getEnd() {
            return this.end;
        }

        protected Mode(char begin, char end) {
            this.begin = begin;
            this.end = end;
            this.beginTc = Companion.c2tc(this.begin);
            this.endTc = Companion.c2tc(this.end);
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J1\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u001a\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013\"\u0006\u0012\u0002\b\u00030\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020!H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0017H\u0016J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020.H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006/"}, d2={"Lkotlinx/serialization/json/JSON$JsonOutput;", "Lkotlinx/serialization/ElementValueOutput;", "mode", "Lkotlinx/serialization/json/JSON$Mode;", "w", "Lkotlinx/serialization/json/JSON$Composer;", "Lkotlinx/serialization/json/JSON;", "(Lkotlinx/serialization/json/JSON;Lkotlinx/serialization/json/JSON$Mode;Lkotlinx/serialization/json/JSON$Composer;)V", "forceStr", "", "getMode", "()Lkotlinx/serialization/json/JSON$Mode;", "getW", "()Lkotlinx/serialization/json/JSON$Composer;", "writeBegin", "Lkotlinx/serialization/KOutput;", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/KSerialClassDesc;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/KOutput;", "writeBooleanValue", "", "value", "writeByteValue", "", "writeCharValue", "", "writeDoubleValue", "", "writeElement", "index", "", "writeEnd", "writeFloatValue", "", "writeIntValue", "writeLongValue", "", "writeNonSerializableValue", "", "writeNullValue", "writeShortValue", "", "writeStringValue", "", "kotlinx-serialization-runtime"})
    private final class JsonOutput
    extends ElementValueOutput {
        private boolean forceStr;
        @NotNull
        private final Mode mode;
        @NotNull
        private final Composer w;

        @Override
        @NotNull
        public KOutput writeBegin(@NotNull KSerialClassDesc desc, KSerializer<?> ... typeParams) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            Mode newMode = Companion.switchMode(this.mode, desc, typeParams);
            if (newMode.getBegin() != '\u0000') {
                this.w.print(newMode.getBegin());
                this.w.indent();
            }
            return Intrinsics.areEqual((Object)((Object)this.mode), (Object)((Object)newMode)) ? (KOutput)this : (KOutput)new JsonOutput(newMode, this.w);
        }

        @Override
        public void writeEnd(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.mode.getEnd() != '\u0000') {
                this.w.unIndent();
                this.w.nextItem();
                this.w.print(this.mode.getEnd());
            }
        }

        @Override
        public boolean writeElement(@NotNull KSerialClassDesc desc, int index) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            switch (JSON$JsonOutput$WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
                case 1: 
                case 2: {
                    if (index == 0) {
                        return false;
                    }
                    if (index > 1) {
                        this.w.print(',');
                    }
                    this.w.nextItem();
                    break;
                }
                case 3: 
                case 4: {
                    if (index == 0) {
                        this.forceStr = true;
                    }
                    if (index != 1) break;
                    this.w.print(Intrinsics.areEqual((Object)((Object)this.mode), (Object)((Object)Mode.ENTRY)) ? (char)':' : ',');
                    this.w.space();
                    this.forceStr = false;
                    break;
                }
                default: {
                    if (index > 0) {
                        this.w.print(',');
                    }
                    this.w.nextItem();
                    this.writeStringValue(desc.getElementName(index));
                    this.w.print(':');
                    this.w.space();
                }
            }
            return true;
        }

        @Override
        public void writeNullValue() {
            this.w.print(JSON.NULL);
        }

        @Override
        public void writeBooleanValue(boolean value) {
            if (this.forceStr) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeByteValue(byte value) {
            if (this.forceStr) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print((Object)value);
            }
        }

        @Override
        public void writeShortValue(short value) {
            if (this.forceStr) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print((Object)value);
            }
        }

        @Override
        public void writeIntValue(int value) {
            if (this.forceStr) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeLongValue(long value) {
            if (this.forceStr) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeFloatValue(float value) {
            float f;
            float f2;
            if (this.forceStr || !(!Float.isInfinite(f2 = (f = value)) && !Float.isNaN(f2 = f))) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeDoubleValue(double value) {
            double d;
            double d2;
            if (this.forceStr || !(!Double.isInfinite(d2 = (d = value)) && !Double.isNaN(d2 = d))) {
                this.writeStringValue(String.valueOf(value));
            } else {
                this.w.print(value);
            }
        }

        @Override
        public void writeCharValue(char value) {
            this.writeStringValue(String.valueOf(value));
        }

        @Override
        public void writeStringValue(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            if (JSON.this.unquoted$1 && !Companion.mustBeQuoted(value)) {
                this.w.print(value);
                return;
            }
            this.w.print('\"');
            String string = value;
            int n = string.length();
            block4: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                char esc = Companion.c2esc(c);
                switch (esc) {
                    case '\u0000': {
                        this.w.print(c);
                        continue block4;
                    }
                    case 'u': {
                        this.w.print('\\');
                        this.w.print('u');
                        char code = c;
                        this.w.print(Companion.hex(code >> 12));
                        this.w.print(Companion.hex(code >> 8));
                        this.w.print(Companion.hex(code >> 4));
                        this.w.print(Companion.hex(code));
                        continue block4;
                    }
                    default: {
                        this.w.print('\\');
                        this.w.print(esc);
                    }
                }
            }
            this.w.print('\"');
        }

        @Override
        public void writeNonSerializableValue(@NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.writeStringValue(value.toString());
        }

        @NotNull
        public final Mode getMode() {
            return this.mode;
        }

        @NotNull
        public final Composer getW() {
            return this.w;
        }

        public JsonOutput(@NotNull Mode mode, Composer w) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
            Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
            this.mode = mode;
            this.w = w;
            this.setContext(JSON.this.getContext());
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lkotlinx/serialization/json/JSON$Composer;", "Ljava/io/PrintWriter;", "Lkotlinx/io/PrintWriter;", "w", "Ljava/io/StringWriter;", "Lkotlinx/io/StringWriter;", "(Lkotlinx/serialization/json/JSON;Ljava/io/StringWriter;)V", "level", "", "getLevel", "()I", "setLevel", "(I)V", "indent", "", "nextItem", "space", "unIndent", "kotlinx-serialization-runtime"})
    private final class Composer
    extends PrintWriter {
        private int level;

        public final int getLevel() {
            return this.level;
        }

        public final void setLevel(int n) {
            this.level = n;
        }

        public final void indent() {
            int n = this.level;
            this.level = n + 1;
        }

        public final void unIndent() {
            int n = this.level;
            this.level = n + -1;
        }

        public final void nextItem() {
            if (JSON.this.indented$1) {
                this.println();
                int n = this.level;
                int n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    this.print(JSON.this.indent);
                }
            }
        }

        public final void space() {
            if (JSON.this.indented$1) {
                this.print(' ');
            }
        }

        public Composer(StringWriter w) {
            Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
            super(w);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J1\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u001a\u0010\u001c\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001d\"\u0006\u0012\u0002\b\u00030\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J+\u0010+\u001a\u0002H,\"\u000e\b\u0000\u0010,*\b\u0012\u0004\u0012\u0002H,0-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H,0/H\u0016\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\bH\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020!H\u0016J\n\u00107\u001a\u0004\u0018\u000108H\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020<H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006="}, d2={"Lkotlinx/serialization/json/JSON$JsonInput;", "Lkotlinx/serialization/ElementValueInput;", "mode", "Lkotlinx/serialization/json/JSON$Mode;", "p", "Lkotlinx/serialization/json/JSON$Parser;", "(Lkotlinx/serialization/json/JSON;Lkotlinx/serialization/json/JSON$Mode;Lkotlinx/serialization/json/JSON$Parser;)V", "curIndex", "", "getCurIndex", "()I", "setCurIndex", "(I)V", "entryIndex", "getEntryIndex", "setEntryIndex", "getMode", "()Lkotlinx/serialization/json/JSON$Mode;", "getP", "()Lkotlinx/serialization/json/JSON$Parser;", "updateMode", "Lkotlinx/serialization/UpdateMode;", "getUpdateMode", "()Lkotlinx/serialization/UpdateMode;", "readBegin", "Lkotlinx/serialization/KInput;", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/KSerialClassDesc;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/KInput;", "readBooleanValue", "", "readByteValue", "", "readCharValue", "", "readDoubleValue", "", "readElement", "readEnd", "", "readEnumValue", "T", "", "enumClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Enum;", "readFloatValue", "", "readIntValue", "readLongValue", "", "readNotNullMark", "readNullValue", "", "readShortValue", "", "readStringValue", "", "kotlinx-serialization-runtime"})
    private final class JsonInput
    extends ElementValueInput {
        private int curIndex;
        private int entryIndex;
        @NotNull
        private final Mode mode;
        @NotNull
        private final Parser p;

        public final int getCurIndex() {
            return this.curIndex;
        }

        public final void setCurIndex(int n) {
            this.curIndex = n;
        }

        public final int getEntryIndex() {
            return this.entryIndex;
        }

        public final void setEntryIndex(int n) {
            this.entryIndex = n;
        }

        @Override
        @NotNull
        public UpdateMode getUpdateMode() {
            return JSON.this.getUpdateMode();
        }

        @Override
        @NotNull
        public KInput readBegin(@NotNull KSerialClassDesc desc, KSerializer<?> ... typeParams) {
            KInput kInput;
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            Mode newMode = Companion.switchMode(this.mode, desc, typeParams);
            if (newMode.getBegin() != '\u0000') {
                Companion.require(this.p.getCurTc() == newMode.getBeginTc(), this.p.getTokenPos(), (Function0<String>)((Function0)new Function0<String>(newMode, desc){
                    final /* synthetic */ Mode $newMode;
                    final /* synthetic */ KSerialClassDesc $desc;

                    @NotNull
                    public final String invoke() {
                        return "Expected '" + this.$newMode.getBegin() + ", kind: " + (Object)((Object)this.$desc.getKind()) + '\'';
                    }
                    {
                        this.$newMode = mode;
                        this.$desc = kSerialClassDesc;
                        super(0);
                    }
                }));
                this.p.nextToken();
            }
            switch (JSON$JsonInput$WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    kInput = new JsonInput(newMode, this.p);
                    break;
                }
                default: {
                    kInput = Intrinsics.areEqual((Object)((Object)this.mode), (Object)((Object)newMode)) ? this : new JsonInput(newMode, this.p);
                }
            }
            return kInput;
        }

        @Override
        public void readEnd(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            if (this.mode.getEnd() != '\u0000') {
                Companion.require(this.p.getCurTc() == this.mode.getEndTc(), this.p.getTokenPos(), (Function0<String>)((Function0)new Function0<String>(this){
                    final /* synthetic */ JsonInput this$0;

                    @NotNull
                    public final String invoke() {
                        return "Expected '" + this.this$0.getMode().getEnd() + '\'';
                    }
                    {
                        this.this$0 = jsonInput;
                        super(0);
                    }
                }));
                this.p.nextToken();
            }
        }

        @Override
        public boolean readNotNullMark() {
            return this.p.getCurTc() != 12;
        }

        @Override
        @Nullable
        public Void readNullValue() {
            Companion.require(this.p.getCurTc() == 12, this.p.getTokenPos(), (Function0<String>)readNullValue.1.INSTANCE);
            this.p.nextToken();
            return null;
        }

        @Override
        public int readElement(@NotNull KSerialClassDesc desc) {
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            while (true) {
                if (this.p.getCurTc() == 4) {
                    this.p.nextToken();
                }
                switch (JSON$JsonInput$WhenMappings.$EnumSwitchMapping$1[this.mode.ordinal()]) {
                    case 1: 
                    case 2: {
                        if (!this.p.getCanBeginValue()) {
                            return -1;
                        }
                        JsonInput jsonInput = this;
                        ++jsonInput.curIndex;
                        return jsonInput.curIndex;
                    }
                    case 3: {
                        int n = this.entryIndex;
                        this.entryIndex = n + 1;
                        switch (n) {
                            case 0: {
                                return 0;
                            }
                            case 1: {
                                return 1;
                            }
                        }
                        this.entryIndex = 0;
                        return -1;
                    }
                    case 4: {
                        int n = this.entryIndex;
                        this.entryIndex = n + 1;
                        switch (n) {
                            case 0: {
                                return 0;
                            }
                            case 1: {
                                Companion.require(this.p.getCurTc() == 5, this.p.getTokenPos(), (Function0<String>)readElement.1.INSTANCE);
                                this.p.nextToken();
                                return 1;
                            }
                        }
                        this.entryIndex = 0;
                        return -1;
                    }
                }
                if (!this.p.getCanBeginValue()) {
                    return -1;
                }
                String key = this.p.takeStr();
                Companion.require(this.p.getCurTc() == 5, this.p.getTokenPos(), (Function0<String>)readElement.2.INSTANCE);
                this.p.nextToken();
                int ind = desc.getElementIndex(key);
                if (ind != -3) {
                    return ind;
                }
                if (!JSON.this.getNonstrict$kotlinx_serialization_runtime()) {
                    throw (Throwable)new SerializationException("Strict JSON encountered unknown key: " + key);
                }
                this.p.skipElement$kotlinx_serialization_runtime();
            }
        }

        @Override
        public boolean readBooleanValue() {
            return Intrinsics.areEqual((Object)this.p.takeStr(), (Object)"true");
        }

        @Override
        public byte readByteValue() {
            String string = this.p.takeStr();
            return Byte.parseByte(string);
        }

        @Override
        public short readShortValue() {
            String string = this.p.takeStr();
            return Short.parseShort(string);
        }

        @Override
        public int readIntValue() {
            String string = this.p.takeStr();
            return Integer.parseInt(string);
        }

        @Override
        public long readLongValue() {
            String string = this.p.takeStr();
            return Long.parseLong(string);
        }

        @Override
        public float readFloatValue() {
            String string = this.p.takeStr();
            return Float.parseFloat(string);
        }

        @Override
        public double readDoubleValue() {
            String string = this.p.takeStr();
            return Double.parseDouble(string);
        }

        @Override
        public char readCharValue() {
            return StringsKt.single((CharSequence)this.p.takeStr());
        }

        @Override
        @NotNull
        public String readStringValue() {
            return this.p.takeStr();
        }

        @Override
        @NotNull
        public <T extends Enum<T>> T readEnumValue(@NotNull KClass<T> enumClass) {
            Intrinsics.checkParameterIsNotNull(enumClass, (String)"enumClass");
            return SerializationKt.enumFromName(enumClass, this.p.takeStr());
        }

        @NotNull
        public final Mode getMode() {
            return this.mode;
        }

        @NotNull
        public final Parser getP() {
            return this.p;
        }

        public JsonInput(@NotNull Mode mode, Parser p) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
            Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
            this.mode = mode;
            this.p = p;
            this.setContext(JSON.this.getContext());
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010+\u001a\u00020\u000bH\u0002J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020-H\u0002J\u0006\u00100\u001a\u00020-J\r\u00101\u001a\u00020-H\u0000\u00a2\u0006\u0002\b2J\r\u00103\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b4J\u0006\u00105\u001a\u00020\u0014R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00060\"j\u0002`#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\r\"\u0004\b*\u0010\u000f\u00a8\u00066"}, d2={"Lkotlinx/serialization/json/JSON$Parser;", "", "r", "Ljava/io/Reader;", "Lkotlinx/io/Reader;", "(Ljava/io/Reader;)V", "canBeginValue", "", "getCanBeginValue", "()Z", "charPos", "", "getCharPos", "()I", "setCharPos", "(I)V", "curChar", "getCurChar", "setCurChar", "curStr", "", "getCurStr", "()Ljava/lang/String;", "setCurStr", "(Ljava/lang/String;)V", "curTc", "", "getCurTc", "()B", "setCurTc", "(B)V", "getR", "()Ljava/io/Reader;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getSb", "()Ljava/lang/StringBuilder;", "setSb", "(Ljava/lang/StringBuilder;)V", "tokenPos", "getTokenPos", "setTokenPos", "hex", "nextChar", "", "nextLiteral", "nextString", "nextToken", "skipElement", "skipElement$kotlinx_serialization_runtime", "state", "state$kotlinx_serialization_runtime", "takeStr", "kotlinx-serialization-runtime"})
    private static final class Parser {
        private int charPos;
        private int curChar;
        private int tokenPos;
        private byte curTc;
        @Nullable
        private String curStr;
        @NotNull
        private StringBuilder sb;
        @NotNull
        private final Reader r;

        public final int getCharPos() {
            return this.charPos;
        }

        public final void setCharPos(int n) {
            this.charPos = n;
        }

        public final int getCurChar() {
            return this.curChar;
        }

        public final void setCurChar(int n) {
            this.curChar = n;
        }

        public final int getTokenPos() {
            return this.tokenPos;
        }

        public final void setTokenPos(int n) {
            this.tokenPos = n;
        }

        public final byte getCurTc() {
            return this.curTc;
        }

        public final void setCurTc(byte by) {
            this.curTc = by;
        }

        @Nullable
        public final String getCurStr() {
            return this.curStr;
        }

        public final void setCurStr(@Nullable String string) {
            this.curStr = string;
        }

        @NotNull
        public final StringBuilder getSb() {
            return this.sb;
        }

        public final void setSb(@NotNull StringBuilder stringBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)stringBuilder, (String)"<set-?>");
            this.sb = stringBuilder;
        }

        public final boolean getCanBeginValue() {
            boolean bl;
            switch (this.curTc) {
                case 0: 
                case 6: 
                case 8: 
                case 10: 
                case 12: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public final String takeStr() {
            String string = this.curStr;
            if (string == null) {
                Void void_ = Companion.fail(this.tokenPos, "Expected string or non-null literal");
                throw null;
            }
            String prevStr = string;
            this.nextToken();
            return prevStr;
        }

        public final void nextToken() {
            block5: while (true) {
                this.tokenPos = this.charPos;
                this.curTc = Companion.c2tc(this.curChar);
                switch (this.curTc) {
                    case 3: {
                        this.nextChar();
                        continue block5;
                    }
                    case 0: {
                        this.nextLiteral();
                        return;
                    }
                    case 10: {
                        this.nextString();
                        return;
                    }
                }
                break;
            }
            this.nextChar();
            this.curStr = null;
        }

        private final void nextChar() {
            this.curChar = this.r.read();
            int n = this.charPos;
            this.charPos = n + 1;
        }

        private final void nextLiteral() {
            this.sb = new StringBuilder();
            do {
                this.sb.append((char)this.curChar);
                this.nextChar();
            } while (Companion.c2tc(this.curChar) == 0);
            if (Intrinsics.areEqual((Object)JSON.NULL, (Object)this.sb.toString())) {
                this.curStr = null;
                this.curTc = (byte)12;
            } else {
                this.curStr = this.sb.toString();
                this.curTc = 0;
            }
        }

        private final void nextString() {
            this.sb = new StringBuilder();
            block5: while (true) {
                this.nextChar();
                switch (Companion.c2tc(this.curChar)) {
                    case 1: {
                        Void void_ = Companion.fail(this.charPos, "Unexpected end in string");
                        throw null;
                    }
                    case 10: {
                        this.nextChar();
                        break block5;
                    }
                    case 11: {
                        this.nextChar();
                        Companion.require(this.curChar >= 0, this.charPos, (Function0<String>)nextString.1.INSTANCE);
                        if (this.curChar == 117) {
                            this.sb.append((char)((this.hex() << 12) + (this.hex() << 8) + (this.hex() << 4) + this.hex()));
                            break;
                        }
                        char c = Companion.esc2c(this.curChar);
                        Companion.require(c != '\u0000', this.charPos, (Function0<String>)((Function0)new Function0<String>(this){
                            final /* synthetic */ Parser this$0;

                            @NotNull
                            public final String invoke() {
                                return "Invalid escaped char '" + (char)this.this$0.getCurChar() + '\'';
                            }
                            {
                                this.this$0 = parser;
                                super(0);
                            }
                        }));
                        this.sb.append(c);
                        break;
                    }
                    default: {
                        this.sb.append((char)this.curChar);
                    }
                }
            }
            this.curStr = this.sb.toString();
            this.curTc = (byte)10;
        }

        private final int hex() {
            int n;
            char c;
            this.nextChar();
            Companion.require(this.curChar >= 0, this.charPos, (Function0<String>)hex.1.INSTANCE);
            char c2 = c = (char)this.curChar;
            if ('0' <= c2 && '9' >= c2) {
                n = this.curChar - 48;
            } else {
                c2 = c;
                if ('a' <= c2 && 'f' >= c2) {
                    n = this.curChar - 97 + 10;
                } else {
                    c2 = c;
                    if ('A' <= c2 && 'F' >= c2) {
                        n = this.curChar - 65 + 10;
                    } else {
                        Void void_ = Companion.fail(this.charPos, "Invalid hex char '" + (char)this.curChar + "' in unicode escape");
                        throw null;
                    }
                }
            }
            return n;
        }

        @NotNull
        public final String state$kotlinx_serialization_runtime() {
            return "Parser(charPos=" + this.charPos + ", curChar=" + this.curChar + ", tokenPos=" + this.tokenPos + ", curTc=" + this.curTc + ", curStr=" + this.curStr + ')';
        }

        public final void skipElement$kotlinx_serialization_runtime() {
            Collection collection;
            if (this.curTc != 6 && this.curTc != 8) {
                this.nextToken();
                return;
            }
            List tokenStack = new ArrayList();
            do {
                switch (this.curTc) {
                    case 6: 
                    case 8: {
                        tokenStack.add(this.curTc);
                        break;
                    }
                    case 9: {
                        if (((Number)CollectionsKt.last((List)tokenStack)).byteValue() != 8) {
                            throw (Throwable)new SerializationException("Invalid JSON at " + this.charPos + ": found ] instead of }");
                        }
                        tokenStack.remove(tokenStack.size() - 1);
                        break;
                    }
                    case 7: {
                        if (((Number)CollectionsKt.last((List)tokenStack)).byteValue() != 6) {
                            throw (Throwable)new SerializationException("Invalid JSON at " + this.charPos + ": found } instead of ]");
                        }
                        tokenStack.remove(tokenStack.size() - 1);
                    }
                }
                this.nextToken();
            } while (!(collection = (Collection)tokenStack).isEmpty());
        }

        @NotNull
        public final Reader getR() {
            return this.r;
        }

        public Parser(@NotNull Reader r) {
            Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
            this.r = r;
            this.curChar = -1;
            this.curTc = 1;
            this.sb = new StringBuilder();
            this.nextChar();
            this.nextToken();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004J\u000e\u00107\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u000bJ\u000e\u00108\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u000bJ\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u0019H\u0002J\u000e\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u000bJ\u0016\u0010?\u001a\u00020@2\u0006\u00106\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u0004J\u0016\u0010?\u001a\u00020@2\u0006\u00106\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u0004J\u0016\u0010B\u001a\u00020@2\u0006\u00106\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u001dJ\u0016\u0010B\u001a\u00020@2\u0006\u00106\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020\u001dJ\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u0019H\u0002J\"\u0010G\u001a\u0002HH\"\n\b\u0000\u0010H\u0018\u0001*\u00020\u00012\u0006\u0010F\u001a\u00020\u0019H\u0086\b\u00a2\u0006\u0002\u0010IJ'\u0010G\u001a\u0002HH\"\u0004\b\u0000\u0010H2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HH0K2\u0006\u0010F\u001a\u00020\u0019\u00a2\u0006\u0002\u0010LJ&\u0010M\u001a\u00020@2\u0006\u0010N\u001a\u00020E2\u0006\u0010;\u001a\u00020\u000b2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00190OH\u0002J\"\u0010P\u001a\u00020\u0019\"\n\b\u0000\u0010H\u0018\u0001*\u00020\u00012\u0006\u0010Q\u001a\u0002HHH\u0086\b\u00a2\u0006\u0002\u0010RJ'\u0010P\u001a\u00020\u0019\"\u0004\b\u0000\u0010H2\f\u0010S\u001a\b\u0012\u0004\u0012\u0002HH0T2\u0006\u0010Q\u001a\u0002HH\u00a2\u0006\u0002\u0010UJ1\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020W2\u0006\u0010Y\u001a\u00020Z2\u0012\u0010[\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030]0\\H\u0002\u00a2\u0006\u0002\u0010^R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u000e\u0010\u0016\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u0011\u00101\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010.R\u0011\u00103\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010.\u00a8\u0006_"}, d2={"Lkotlinx/serialization/json/JSON$Companion;", "", "()V", "BEGIN_LIST", "", "BEGIN_OBJ", "C2ESC", "", "getC2ESC", "()[B", "C2ESC_MAX", "", "C2TC", "getC2TC", "COLON", "COMMA", "CTC_MAX", "CTC_OFS", "END_LIST", "END_OBJ", "ESC2C", "getESC2C", "ESC2C_MAX", "INVALID", "NULL", "", "STRING", "STRING_ESC", "TC_BEGIN_LIST", "", "TC_BEGIN_OBJ", "TC_COLON", "TC_COMMA", "TC_END_LIST", "TC_END_OBJ", "TC_EOF", "TC_INVALID", "TC_NULL", "TC_OTHER", "TC_STRING", "TC_STRING_ESC", "TC_WS", "UNICODE_ESC", "indented", "Lkotlinx/serialization/json/JSON;", "getIndented", "()Lkotlinx/serialization/json/JSON;", "nonstrict", "getNonstrict", "plain", "getPlain", "unquoted", "getUnquoted", "c2esc", "c", "c2tc", "esc2c", "fail", "", "pos", "msg", "hex", "i", "initC2ESC", "", "esc", "initC2TC", "cl", "mustBeQuoted", "", "str", "parse", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "loader", "Lkotlinx/serialization/KSerialLoader;", "(Lkotlinx/serialization/KSerialLoader;Ljava/lang/String;)Ljava/lang/Object;", "require", "condition", "Lkotlin/Function0;", "stringify", "obj", "(Ljava/lang/Object;)Ljava/lang/String;", "saver", "Lkotlinx/serialization/KSerialSaver;", "(Lkotlinx/serialization/KSerialSaver;Ljava/lang/Object;)Ljava/lang/String;", "switchMode", "Lkotlinx/serialization/json/JSON$Mode;", "mode", "desc", "Lkotlinx/serialization/KSerialClassDesc;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/json/JSON$Mode;Lkotlinx/serialization/KSerialClassDesc;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/json/JSON$Mode;", "kotlinx-serialization-runtime"})
    public static final class Companion {
        @NotNull
        public final <T> String stringify(@NotNull KSerialSaver<? super T> saver, T obj) {
            Intrinsics.checkParameterIsNotNull(saver, (String)"saver");
            return this.getPlain().stringify(saver, obj);
        }

        private final <T> String stringify(T obj) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return this.stringify(SerializationKt.serializer(Reflection.getOrCreateKotlinClass(Object.class)), obj);
        }

        public final <T> T parse(@NotNull KSerialLoader<T> loader, @NotNull String str) {
            Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            return this.getPlain().parse(loader, str);
        }

        private final <T> T parse(String str) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return this.parse(SerializationKt.serializer(Reflection.getOrCreateKotlinClass(Object.class)), str);
        }

        @NotNull
        public final JSON getPlain() {
            return plain;
        }

        @NotNull
        public final JSON getUnquoted() {
            return unquoted;
        }

        @NotNull
        public final JSON getIndented() {
            return indented;
        }

        @NotNull
        public final JSON getNonstrict() {
            return nonstrict;
        }

        private final byte[] getC2TC() {
            return C2TC;
        }

        public final void initC2TC(int c, byte cl) {
            this.getC2TC()[c + 1] = cl;
        }

        public final void initC2TC(char c, byte cl) {
            this.initC2TC((int)c, cl);
        }

        public final byte c2tc(int c) {
            return c < 126 ? this.getC2TC()[c + 1] : (byte)0;
        }

        private final boolean mustBeQuoted(String str) {
            boolean bl;
            block1: {
                CharSequence $receiver$iv;
                CharSequence charSequence = $receiver$iv = (CharSequence)str;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv = charSequence.charAt(i);
                    char it = element$iv;
                    if (!(Companion.c2tc(it) != 0)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl || Intrinsics.areEqual((Object)str, (Object)JSON.NULL);
        }

        private final byte[] getC2ESC() {
            return C2ESC;
        }

        private final byte[] getESC2C() {
            return ESC2C;
        }

        public final void initC2ESC(int c, char esc) {
            this.getC2ESC()[c] = (byte)esc;
            if (esc != 'u') {
                this.getESC2C()[esc] = (byte)c;
            }
        }

        public final void initC2ESC(char c, char esc) {
            this.initC2ESC((int)c, esc);
        }

        public final char c2esc(char c) {
            return c < ']' ? (char)this.getC2ESC()[c] : (char)'\u0000';
        }

        public final char esc2c(int c) {
            return c < 117 ? (char)this.getESC2C()[c] : (char)'\u0000';
        }

        public final char hex(int i) {
            int d = i & 0xF;
            return d < 10 ? (char)(d + 48) : (char)(d - 10 + 97);
        }

        private final Mode switchMode(Mode mode, KSerialClassDesc desc, KSerializer<?>[] typeParams) {
            Mode mode2;
            switch (JSON$Companion$WhenMappings.$EnumSwitchMapping$0[desc.getKind().ordinal()]) {
                case 1: {
                    mode2 = Mode.POLY;
                    break;
                }
                case 2: 
                case 3: {
                    mode2 = Mode.LIST;
                    break;
                }
                case 4: {
                    KSerialClassKind keyKind = typeParams[0].getSerialClassDesc().getKind();
                    if (Intrinsics.areEqual((Object)((Object)keyKind), (Object)((Object)KSerialClassKind.PRIMITIVE)) || Intrinsics.areEqual((Object)((Object)keyKind), (Object)((Object)KSerialClassKind.ENUM))) {
                        mode2 = Mode.MAP;
                        break;
                    }
                    mode2 = Mode.LIST;
                    break;
                }
                case 5: {
                    if (Intrinsics.areEqual((Object)((Object)mode), (Object)((Object)Mode.MAP))) {
                        mode2 = Mode.ENTRY;
                        break;
                    }
                    mode2 = Mode.OBJ;
                    break;
                }
                default: {
                    mode2 = Mode.OBJ;
                }
            }
            return mode2;
        }

        private final void require(boolean condition, int pos, Function0<String> msg) {
            if (!condition) {
                Void void_ = this.fail(pos, (String)msg.invoke());
                throw null;
            }
        }

        private final Void fail(int pos, String msg) {
            throw (Throwable)new IllegalArgumentException("JSON at " + pos + ": " + msg);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

