/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.signaturer;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.signaturer.FirMangler;
import org.jetbrains.kotlin.fir.signaturer.FirManglerUtilKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J$\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J$\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0$H\u0016J\u0014\u0010%\u001a\u00020\u0006*\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0002J\f\u0010(\u001a\u00020)*\u00020\u0010H\u0002J\f\u0010*\u001a\u00020)*\u00020\u0010H\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "mangler", "Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;", "(Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;)V", "fileSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "getFileSignature", "()Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "setFileSignature", "(Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;)V", "getMangler", "()Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;", "composeAccessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isSetter", "", "containingClass", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "forceTopLevelPrivate", "composeSignature", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "composeTypeParameterSignature", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "index", "", "containerSignature", "isTopLevelPrivate", "withFileSignature", "", "sig", "body", "Lkotlin/Function0;", "fakeFileSignature", "commonSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "getterOrDefault", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "setterOrDefault", "SignatureBuilder", "fir2ir"})
public final class FirBasedSignatureComposer
implements Fir2IrSignatureComposer {
    @NotNull
    private final FirMangler mangler;
    @Nullable
    private IdSignature.FileSignature fileSignature;

    public FirBasedSignatureComposer(@NotNull FirMangler mangler) {
        Intrinsics.checkNotNullParameter(mangler, "mangler");
        this.mangler = mangler;
    }

    @Override
    @NotNull
    public FirMangler getMangler() {
        return this.mangler;
    }

    @Nullable
    public final IdSignature.FileSignature getFileSignature() {
        return this.fileSignature;
    }

    public final void setFileSignature(@Nullable IdSignature.FileSignature fileSignature) {
        this.fileSignature = fileSignature;
    }

    @Override
    public void withFileSignature(@NotNull IdSignature.FileSignature sig, @NotNull Function0<Unit> body2) {
        Intrinsics.checkNotNullParameter(sig, "sig");
        Intrinsics.checkNotNullParameter(body2, "body");
        this.fileSignature = sig;
        body2.invoke();
        this.fileSignature = null;
    }

    @Override
    @Nullable
    public IdSignature composeSignature(@NotNull FirDeclaration declaration, @Nullable ConeClassLikeLookupTag containingClass, boolean forceTopLevelPrivate) {
        IdSignature idSignature;
        IdSignature.CommonSignature commonSignature;
        ClassId classId;
        block20: {
            block21: {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                if (declaration instanceof FirAnonymousObject || declaration instanceof FirAnonymousFunction) {
                    return null;
                }
                if (declaration instanceof FirRegularClass && FirDeclarationUtilKt.getClassId((FirClass)declaration).isLocal()) {
                    return null;
                }
                if (!(declaration instanceof FirCallableDeclaration)) break block20;
                FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$getVisibility = false;
                if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE)) {
                    return null;
                }
                Object object = ClassMembersKt.dispatchReceiverClassOrNull((FirCallableDeclaration)declaration);
                if (object != null && (object = ((ConeClassLikeLookupTag)object).getClassId()) != null ? ((ClassId)object).isLocal() : false) break block21;
                Object object2 = containingClass;
                boolean bl = object2 != null && (object2 = ((ConeClassLikeLookupTag)object2).getClassId()) != null ? ((ClassId)object2).isLocal() : false;
                if (!bl) break block20;
            }
            return null;
        }
        SignatureBuilder builder2 = new SignatureBuilder();
        try {
            declaration.accept(builder2, null);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error while composing signature for " + FirRendererKt.render$default(declaration, null, 1, null), t);
        }
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            classId = FirDeclarationUtilKt.getClassId((FirClass)declaration);
            String string2 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "classId.packageFqName.asString()");
            String string3 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue(string3, "classId.relativeClassName.asString()");
            commonSignature = new IdSignature.CommonSignature(string2, string3, builder2.getHashId(), builder2.getMask());
        } else if (firDeclaration instanceof FirTypeAlias) {
            classId = ((FirTypeAlias)declaration).getSymbol().getClassId();
            String string4 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string4, "classId.packageFqName.asString()");
            String string5 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue(string5, "classId.relativeClassName.asString()");
            commonSignature = new IdSignature.CommonSignature(string4, string5, builder2.getHashId(), builder2.getMask());
        } else if (firDeclaration instanceof FirCallableDeclaration) {
            ClassId classId2;
            Object object;
            ConeClassLikeLookupTag coneClassLikeLookupTag = containingClass;
            ClassId containingClassId = coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null;
            ClassId classId3 = containingClassId;
            if (classId3 == null) {
                ConeClassLikeLookupTag coneClassLikeLookupTag2 = ClassMembersKt.containingClass((FirCallableDeclaration)declaration);
                classId3 = coneClassLikeLookupTag2 != null ? coneClassLikeLookupTag2.getClassId() : null;
            }
            if ((object = (classId2 = classId3)) == null || (object = ((ClassId)object).getPackageFqName()) == null) {
                object = ((FirCallableDeclaration)declaration).getSymbol().getCallableId().getPackageName();
            }
            Intrinsics.checkNotNullExpressionValue(object, "classId?.packageFqName ?\u2026ol.callableId.packageName");
            Object packageName = object;
            Name callableName = FirManglerUtilKt.getIrName((FirCallableDeclaration)declaration);
            String string6 = ((FqName)packageName).asString();
            Intrinsics.checkNotNullExpressionValue(string6, "packageName.asString()");
            Object object3 = classId2;
            if (object3 == null || (object3 = ((ClassId)object3).getRelativeClassName()) == null || (object3 = ((FqName)object3).child(callableName)) == null || (object3 = ((FqName)object3).asString()) == null) {
                object3 = callableName.asString();
            }
            Intrinsics.checkNotNullExpressionValue(object3, "classId?.relativeClassNa\u2026: callableName.asString()");
            commonSignature = new IdSignature.CommonSignature(string6, (String)object3, builder2.getHashId(), builder2.getMask());
        } else {
            throw new IllegalStateException(("Unsupported FIR declaration in signature composer: " + FirRendererKt.render$default(declaration, null, 1, null)).toString());
        }
        IdSignature.CommonSignature publicSignature = commonSignature;
        if (this.isTopLevelPrivate(declaration) || forceTopLevelPrivate) {
            IdSignature.FileSignature fileSignature = this.fileSignature;
            if (fileSignature == null) {
                fileSignature = this.fakeFileSignature(declaration, publicSignature);
            }
            IdSignature.FileSignature fileSig = fileSignature;
            idSignature = new IdSignature.CompositeSignature(fileSig, publicSignature);
        } else {
            idSignature = publicSignature;
        }
        return idSignature;
    }

    @Override
    @Nullable
    public IdSignature composeTypeParameterSignature(@NotNull FirTypeParameter typeParameter, int index2, @Nullable IdSignature containerSignature) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        if (containerSignature == null) {
            return null;
        }
        return new IdSignature.CompositeSignature(containerSignature, new IdSignature.LocalSignature("<TP>", Long.valueOf(index2), null));
    }

    @Override
    @Nullable
    public IdSignature composeAccessorSignature(@NotNull FirProperty property2, boolean isSetter, @Nullable ConeClassLikeLookupTag containingClass, boolean forceTopLevelPrivate) {
        Intrinsics.checkNotNullParameter(property2, "property");
        IdSignature.CommonSignature propSig = null;
        IdSignature.FileSignature fileSig = null;
        IdSignature propertySignature = this.composeSignature(property2, containingClass, forceTopLevelPrivate);
        if (propertySignature instanceof IdSignature.CompositeSignature) {
            IdSignature idSignature = ((IdSignature.CompositeSignature)propertySignature).getInner();
            IdSignature.CommonSignature commonSignature = idSignature instanceof IdSignature.CommonSignature ? (IdSignature.CommonSignature)idSignature : null;
            if (commonSignature == null) {
                return null;
            }
            propSig = commonSignature;
            idSignature = ((IdSignature.CompositeSignature)propertySignature).getContainer();
            IdSignature.FileSignature fileSignature = idSignature instanceof IdSignature.FileSignature ? (IdSignature.FileSignature)idSignature : null;
            if (fileSignature == null) {
                return null;
            }
            fileSig = fileSignature;
        } else if (propertySignature instanceof IdSignature.CommonSignature) {
            propSig = (IdSignature.CommonSignature)propertySignature;
            fileSig = null;
        } else {
            return null;
        }
        FirMangler $this$composeAccessorSignature_u24lambda_u240 = this.getMangler();
        boolean bl = false;
        long id = isSetter ? $this$composeAccessorSignature_u24lambda_u240.signatureMangle(this.setterOrDefault(property2), false) : $this$composeAccessorSignature_u24lambda_u240.signatureMangle(this.getterOrDefault(property2), false);
        String accessorFqName = isSetter ? propSig.getDeclarationFqName() + ".<set-" + property2.getName().asString() + '>' : propSig.getDeclarationFqName() + ".<get-" + property2.getName().asString() + '>';
        IdSignature.CommonSignature commonSig = new IdSignature.CommonSignature(propSig.getPackageFqName(), accessorFqName, id, propSig.getMask());
        IdSignature.AccessorSignature accessorSig = new IdSignature.AccessorSignature(propSig, commonSig);
        return fileSig != null ? (IdSignature)new IdSignature.CompositeSignature(fileSig, accessorSig) : (IdSignature)accessorSig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTopLevelPrivate(FirDeclaration declaration) {
        if (FirVisibilityCheckerKt.getOwnerLookupTag(declaration.getSymbol()) != null) return false;
        if (!(declaration instanceof FirMemberDeclaration)) return false;
        FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$getVisibility = false;
        if (!Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) return false;
        return true;
    }

    private final IdSignature.FileSignature fakeFileSignature(FirDeclaration $this$fakeFileSignature, IdSignature.CommonSignature commonSignature) {
        return new IdSignature.FileSignature($this$fakeFileSignature, new FqName(commonSignature.getPackageFqName() + '.' + commonSignature.getDeclarationFqName()), "<unknown>");
    }

    private final FirPropertyAccessor getterOrDefault(FirProperty $this$getterOrDefault) {
        FirPropertyAccessor firPropertyAccessor = $this$getterOrDefault.getGetter();
        if (firPropertyAccessor == null) {
            FirMemberDeclaration $this$visibility$iv = $this$getterOrDefault;
            boolean $i$f$getVisibility = false;
            firPropertyAccessor = new FirDefaultPropertyGetter(null, $this$getterOrDefault.getModuleData(), $this$getterOrDefault.getOrigin(), $this$getterOrDefault.getReturnTypeRef(), $this$visibility$iv.getStatus().getVisibility(), $this$getterOrDefault.getSymbol(), null, null, null, 448, null);
        }
        return firPropertyAccessor;
    }

    private final FirPropertyAccessor setterOrDefault(FirProperty $this$setterOrDefault) {
        FirPropertyAccessor firPropertyAccessor = $this$setterOrDefault.getSetter();
        if (firPropertyAccessor == null) {
            FirMemberDeclaration $this$visibility$iv = $this$setterOrDefault;
            boolean $i$f$getVisibility = false;
            firPropertyAccessor = new FirDefaultPropertySetter(null, $this$setterOrDefault.getModuleData(), $this$setterOrDefault.getOrigin(), $this$setterOrDefault.getReturnTypeRef(), $this$visibility$iv.getStatus().getVisibility(), $this$setterOrDefault.getSymbol(), null, null, null, null, 960, null);
        }
        return firPropertyAccessor;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$SignatureBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "", "(Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;)V", "hashId", "", "getHashId", "()Ljava/lang/Long;", "setHashId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "mask", "getMask", "()J", "setMask", "(J)V", "setExpected", "f", "", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "fir2ir"})
    public final class SignatureBuilder
    extends FirVisitor<Unit, Object> {
        @Nullable
        private Long hashId;
        private long mask;

        @Nullable
        public final Long getHashId() {
            return this.hashId;
        }

        public final void setHashId(@Nullable Long l) {
            this.hashId = l;
        }

        public final long getMask() {
            return this.mask;
        }

        public final void setMask(long l) {
            this.mask = l;
        }

        private final void setExpected(boolean f) {
            this.mask |= IdSignature.Flags.IS_EXPECT.encode(f);
        }

        @Override
        public void visitElement(@NotNull FirElement element, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(element, "element");
            String string2 = "Should not be here";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            FirMemberDeclaration $this$isExpect$iv = regularClass;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            FirMemberDeclaration $this$isExpect$iv = typeAlias;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2, @Nullable Object data) {
            void $this$visitConstructor_u24lambda_u240;
            Intrinsics.checkNotNullParameter(constructor2, "constructor");
            FirMangler firMangler = FirBasedSignatureComposer.this.getMangler();
            SignatureBuilder signatureBuilder = this;
            boolean bl = false;
            signatureBuilder.hashId = $this$visitConstructor_u24lambda_u240.signatureMangle(constructor2, false);
            FirMemberDeclaration $this$isExpect$iv = constructor2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Object data) {
            void $this$visitSimpleFunction_u24lambda_u241;
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            FirMangler firMangler = FirBasedSignatureComposer.this.getMangler();
            SignatureBuilder signatureBuilder = this;
            boolean bl = false;
            signatureBuilder.hashId = $this$visitSimpleFunction_u24lambda_u241.signatureMangle(simpleFunction, false);
            FirMemberDeclaration $this$isExpect$iv = simpleFunction;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitProperty(@NotNull FirProperty property2, @Nullable Object data) {
            void $this$visitProperty_u24lambda_u242;
            Intrinsics.checkNotNullParameter(property2, "property");
            FirMangler firMangler = FirBasedSignatureComposer.this.getMangler();
            SignatureBuilder signatureBuilder = this;
            boolean bl = false;
            signatureBuilder.hashId = $this$visitProperty_u24lambda_u242.signatureMangle(property2, false);
            FirMemberDeclaration $this$isExpect$iv = property2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitField(@NotNull FirField field2, @Nullable Object data) {
            void $this$visitField_u24lambda_u243;
            Intrinsics.checkNotNullParameter(field2, "field");
            FirMangler firMangler = FirBasedSignatureComposer.this.getMangler();
            SignatureBuilder signatureBuilder = this;
            boolean bl = false;
            signatureBuilder.hashId = $this$visitField_u24lambda_u243.signatureMangle(field2, false);
            FirMemberDeclaration $this$isExpect$iv = field2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            FirMemberDeclaration $this$isExpect$iv = enumEntry;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }
    }
}

