/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConstChecksKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkAnnotationClassMember", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isAllowedArray", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isAllowedClassKind", "cone", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "checkers"})
public final class FirAnnotationClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirAnnotationClassDeclarationChecker INSTANCE = new FirAnnotationClassDeclarationChecker();

    private FirAnnotationClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (declaration2.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirClassLikeDeclaration $this$isLocal$iv = declaration2;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getLOCAL_ANNOTATION_CLASS_ERROR(), context2, null, 8, null);
        }
        if (declaration2.getSuperTypeRefs().size() != 1) {
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getSUPERTYPES_FOR_ANNOTATION_CLASS(), context2, null, 8, null);
        }
        for (FirDeclaration member2 : declaration2.getDeclarations()) {
            this.checkAnnotationClassMember(member2, context2, reporter);
        }
        if (FirAnnotationHelpersKt.getRetention(declaration2) != AnnotationRetention.SOURCE && FirAnnotationHelpersKt.getAllowedAnnotationTargets(declaration2).contains((Object)KotlinTarget.EXPRESSION)) {
            FirAnnotationCall firAnnotationCall;
            FirAnnotationCall firAnnotationCall2 = FirAnnotationHelpersKt.getRetentionAnnotation(declaration2);
            FirElement target = firAnnotationCall2 == null ? ((firAnnotationCall = FirAnnotationHelpersKt.getTargetAnnotation(declaration2)) == null ? (FirElement)declaration2 : (FirElement)firAnnotationCall) : (FirElement)firAnnotationCall2;
            DiagnosticReporterKt.reportOn$default(reporter, ((FirPureAbstractElement)target).getSource(), FirErrors.INSTANCE.getRESTRICTED_RETENTION_FOR_EXPRESSION_ANNOTATION(), context2, null, 8, null);
        }
    }

    private final void checkAnnotationClassMember(FirDeclaration member2, CheckerContext context2, DiagnosticReporter reporter) {
        FirSourceElement firSourceElement;
        if (member2 instanceof FirConstructor && ((FirConstructor)member2).isPrimary()) {
            for (FirValueParameter parameter : ((FirConstructor)member2).getValueParameters()) {
                ConeLookupTagBasedType coneType;
                ConeLookupTagBasedType coneLookupTagBasedType;
                ClassId classId;
                FirTypeRef typeRef;
                FirSourceElement firSourceElement2 = parameter.getSource();
                if (firSourceElement2 == null) continue;
                FirSourceElement source = firSourceElement2;
                if (!LightTreePositioningStrategiesKt.hasValOrVar(source)) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getMISSING_VAL_ON_ANNOTATION_PARAMETER(), context2, null, 8, null);
                } else if (LightTreePositioningStrategiesKt.hasVar(source)) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getVAR_ANNOTATION_PARAMETER(), context2, null, 8, null);
                }
                FirExpression defaultValue2 = parameter.getDefaultValue();
                if (defaultValue2 != null && FirConstChecksKt.checkConstantArguments(defaultValue2, context2.getSession()) != null) {
                    DiagnosticReporterKt.reportOn$default(reporter, defaultValue2.getSource(), FirErrors.INSTANCE.getANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT(), context2, null, 8, null);
                }
                FirTypeRef $this$coneTypeSafe$iv = typeRef = parameter.getReturnTypeRef();
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                    coneKotlinType = null;
                }
                ClassId classId2 = classId = (coneLookupTagBasedType = (coneType = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType)))) == null ? null : ConeTypeUtilsKt.getClassId(coneLookupTagBasedType);
                if (coneType == null || Intrinsics.areEqual(classId, ClassId.fromString("<error>"))) continue;
                if (ConeTypeUtilsKt.isNullable(coneType)) {
                    DiagnosticReporterKt.reportOn$default(reporter, typeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_TYPE_OF_ANNOTATION_MEMBER(), context2, null, 8, null);
                    continue;
                }
                if (ConeTypeUtilsKt.isPrimitiveOrNullablePrimitive(coneType) || ConeTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(coneType) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getKClass()) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getString()) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values(), classId) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getUnsignedArrayTypeByElementType().values(), classId)) continue;
                if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getArray())) {
                    if (this.isAllowedArray(typeRef, context2.getSession())) continue;
                    DiagnosticReporterKt.reportOn$default(reporter, typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), context2, null, 8, null);
                    continue;
                }
                if (this.isAllowedClassKind(coneType, context2.getSession())) continue;
                DiagnosticReporterKt.reportOn$default(reporter, typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), context2, null, 8, null);
            }
        } else if (!(member2 instanceof FirRegularClass || member2 instanceof FirProperty && Intrinsics.areEqual((firSourceElement = member2.getSource()) == null ? null : firSourceElement.getElementType(), KtNodeTypes.VALUE_PARAMETER) || member2 instanceof FirSimpleFunction && !Intrinsics.areEqual((firSourceElement = member2.getSource()) == null ? null : firSourceElement.getElementType(), KtNodeTypes.FUN))) {
            DiagnosticReporterKt.reportOn$default(reporter, member2.getSource(), FirErrors.INSTANCE.getANNOTATION_CLASS_MEMBER(), context2, null, 8, null);
        }
    }

    private final boolean isAllowedClassKind(ConeLookupTagBasedType cone, FirSession session2) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.toSymbol(cone.getLookupTag(), session2);
        FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol = firClassifierSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassifierSymbol : null;
        if (firRegularClassSymbol == null) {
            return false;
        }
        ClassKind typeRefClassKind = firRegularClassSymbol.getClassKind();
        return typeRefClassKind == ClassKind.ANNOTATION_CLASS || typeRefClassKind == ClassKind.ENUM_CLASS;
    }

    private final boolean isAllowedArray(FirTypeRef typeRef, FirSession session2) {
        ConeKotlinTypeProjection coneKotlinTypeProjection;
        ConeTypeProjection[] typeArguments2 = FirTypeUtilsKt.getConeType(typeRef).getTypeArguments();
        if (typeArguments2.length != 1) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = typeArguments2[0];
        ConeKotlinTypeProjection coneKotlinTypeProjection2 = coneKotlinTypeProjection = coneTypeProjection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)coneTypeProjection : null;
        if (coneKotlinTypeProjection == null) {
            return false;
        }
        ConeKotlinType arrayType = coneKotlinTypeProjection.getType();
        if (ConeTypeUtilsKt.isNullable(arrayType)) {
            return false;
        }
        ClassId arrayTypeClassId = ConeTypeUtilsKt.getClassId(arrayType);
        if (Intrinsics.areEqual(arrayTypeClassId, StandardClassIds.INSTANCE.getKClass())) {
            return true;
        }
        if (Intrinsics.areEqual(arrayTypeClassId, StandardClassIds.INSTANCE.getString())) {
            return true;
        }
        return this.isAllowedClassKind((ConeLookupTagBasedType)arrayType, session2);
    }
}

