/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.GetTask;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.PeekTask;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.TransportListener;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.TransportTask;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.Transporter;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.TransferCancelledException;

public abstract class AbstractTransporter
implements Transporter {
    private final AtomicBoolean closed = new AtomicBoolean();

    protected AbstractTransporter() {
    }

    @Override
    public void peek(PeekTask task) throws Exception {
        this.failIfClosed(task);
        this.implPeek(task);
    }

    protected abstract void implPeek(PeekTask var1) throws Exception;

    @Override
    public void get(GetTask task) throws Exception {
        this.failIfClosed(task);
        this.implGet(task);
    }

    protected abstract void implGet(GetTask var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void utilGet(GetTask task, InputStream is, boolean close, long length, boolean resume) throws IOException, TransferCancelledException {
        OutputStream os = null;
        try {
            os = task.newOutputStream(resume);
            task.getListener().transportStarted(resume ? task.getResumeOffset() : 0L, length);
            AbstractTransporter.copy(os, is, task.getListener());
            os.close();
            os = null;
            if (close) {
                is.close();
                is = null;
            }
        }
        finally {
            block29: {
                block28: {
                    if (os == null) break block28;
                    os.close();
                }
                try {
                    if (close && is != null) {
                        is.close();
                    }
                    break block29;
                }
                catch (IOException iOException) {}
                break block29;
                catch (IOException iOException) {
                    try {
                        if (close && is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    catch (Throwable throwable) {
                        try {
                            if (close && is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException3) {}
                        throw throwable;
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.implClose();
        }
    }

    protected abstract void implClose();

    private void failIfClosed(TransportTask task) {
        if (this.closed.get()) {
            throw new IllegalStateException("transporter closed, cannot execute task " + task);
        }
    }

    private static void copy(OutputStream os, InputStream is, TransportListener listener) throws IOException, TransferCancelledException {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array = buffer.array();
        int read = is.read(array);
        while (read >= 0) {
            os.write(array, 0, read);
            buffer.rewind();
            buffer.limit(read);
            listener.transportProgressed(buffer);
            read = is.read(array);
        }
    }
}

