/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.tower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.CallKind;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateCollector;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactory;
import org.jetbrains.kotlin.fir.resolve.calls.tower.ProcessResult;
import org.jetbrains.kotlin.fir.resolve.calls.tower.ScopeTowerLevel;
import org.jetbrains.kotlin.fir.resolve.calls.tower.SessionBasedTowerLevel;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerScopeLevelProcessor;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerLevelHandler;", "", "()V", "processResult", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/ProcessResult;", "handleLevel", "collector", "Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateCollector;", "candidateFactory", "Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateFactory;", "info", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "explicitReceiverKind", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "group", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "towerLevel", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/SessionBasedTowerLevel;", "resolve"})
public final class TowerLevelHandler {
    @NotNull
    private ProcessResult processResult = ProcessResult.SCOPE_EMPTY;

    @NotNull
    public final ProcessResult handleLevel(@NotNull CandidateCollector collector2, @NotNull CandidateFactory candidateFactory, @NotNull CallInfo info, @NotNull ExplicitReceiverKind explicitReceiverKind, @NotNull TowerGroup group, @NotNull SessionBasedTowerLevel towerLevel) {
        Intrinsics.checkNotNullParameter(collector2, "collector");
        Intrinsics.checkNotNullParameter(candidateFactory, "candidateFactory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter((Object)explicitReceiverKind, "explicitReceiverKind");
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(towerLevel, "towerLevel");
        this.processResult = ProcessResult.SCOPE_EMPTY;
        TowerScopeLevelProcessor processor2 = new TowerScopeLevelProcessor(info, explicitReceiverKind, collector2, candidateFactory, group);
        CallKind callKind = info.getCallKind();
        if (Intrinsics.areEqual(callKind, CallKind.VariableAccess.INSTANCE)) {
            TowerLevelHandler towerLevelHandler = this;
            towerLevelHandler.processResult = towerLevelHandler.processResult.plus(towerLevel.processPropertiesByName(info, processor2));
            if (!collector2.isSuccess() && towerLevel instanceof ScopeTowerLevel && ((ScopeTowerLevel)towerLevel).getExtensionReceiver() == null) {
                towerLevelHandler = this;
                towerLevelHandler.processResult = towerLevelHandler.processResult.plus(towerLevel.processObjectsByName(info, processor2));
            }
        } else if (Intrinsics.areEqual(callKind, CallKind.Function.INSTANCE)) {
            TowerLevelHandler towerLevelHandler = this;
            towerLevelHandler.processResult = towerLevelHandler.processResult.plus(towerLevel.processFunctionsByName(info, processor2));
        } else if (Intrinsics.areEqual(callKind, CallKind.CallableReference.INSTANCE)) {
            TowerLevelHandler towerLevelHandler = this;
            towerLevelHandler.processResult = towerLevelHandler.processResult.plus(towerLevel.processFunctionsByName(info, processor2));
            towerLevelHandler = this;
            towerLevelHandler.processResult = towerLevelHandler.processResult.plus(towerLevel.processPropertiesByName(info, processor2));
        } else {
            throw new AssertionError((Object)Intrinsics.stringPlus("Unsupported call kind in tower resolver: ", info.getCallKind()));
        }
        return this.processResult;
    }
}

