/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConstructorCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirConstructorCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirConstructorCallChecker INSTANCE = new FirConstructorCallChecker();

    private FirConstructorCallChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirConstructorSymbol firConstructorSymbol;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Iterator iterator2 = expression2.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference = iterator2 instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)((Object)iterator2) : null;
        FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference == null ? null : firResolvedNamedReference.getResolvedSymbol();
        FirConstructorSymbol firConstructorSymbol2 = firConstructorSymbol = firBasedSymbol instanceof FirConstructorSymbol ? (FirConstructorSymbol)firBasedSymbol : null;
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol constructorSymbol = firConstructorSymbol;
        FirRegularClassSymbol declarationClass = FirHelpersKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType(constructorSymbol.getResolvedReturnTypeRef()), context2.getSession());
        if (declarationClass != null) {
            FirRegularClassSymbol $this$isAbstract$iv = declarationClass;
            boolean $i$f$isAbstract = false;
            if ($this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT && declarationClass.getClassKind() == ClassKind.CLASS) {
                DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getCREATING_AN_INSTANCE_OF_ABSTRACT_CLASS(), context2, null, 8, null);
            }
            if (declarationClass.getClassKind() == ClassKind.ANNOTATION_CLASS) {
                boolean bl;
                boolean $i$f$all;
                Iterable $this$all$iv;
                block12: {
                    $this$all$iv = context2.getQualifiedAccessOrAnnotationCalls();
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            FirStatement call2 = (FirStatement)element$iv;
                            boolean bl2 = false;
                            if (!(call2 instanceof FirAnnotationCall)) continue;
                            bl = false;
                            break block12;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    boolean bl3;
                    block13: {
                        $this$all$iv = context2.getContainingDeclarations();
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl3 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                FirDeclaration klass = (FirDeclaration)element$iv;
                                boolean bl4 = false;
                                if (!(klass instanceof FirRegularClass) || ((FirRegularClass)klass).getClassKind() != ClassKind.ANNOTATION_CLASS) continue;
                                bl3 = false;
                                break block13;
                            }
                            bl3 = true;
                        }
                    }
                    if (bl3) {
                        DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getANNOTATION_CLASS_CONSTRUCTOR_CALL(), context2, null, 8, null);
                    }
                }
            }
        }
    }
}

