/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ConstructorBinding;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.MethodBinding;
import org.jetbrains.kotlin.container.UnresolvedDependenciesException;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u001a(\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u000b\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"computeArguments", "", "", "argumentDescriptors", "Lorg/jetbrains/kotlin/container/ValueDescriptor;", "bindArguments", "Ljava/lang/reflect/Member;", "parameters", "Ljava/lang/reflect/Type;", "context", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "bindToConstructor", "Lorg/jetbrains/kotlin/container/ConstructorBinding;", "Ljava/lang/Class;", "bindToMethod", "Lorg/jetbrains/kotlin/container/MethodBinding;", "Ljava/lang/reflect/Method;", "container"})
public final class ResolveKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Object> computeArguments(@NotNull List<? extends ValueDescriptor> argumentDescriptors) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(argumentDescriptors, "argumentDescriptors");
        Iterable $this$map$iv = argumentDescriptors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueDescriptor valueDescriptor = (ValueDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.getValue();
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final ConstructorBinding bindToConstructor(@NotNull Class<?> $this$bindToConstructor, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter($this$bindToConstructor, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        ConstructorInfo constructorInfo = CacheKt.getInfo($this$bindToConstructor).getConstructorInfo();
        if (constructorInfo == null) {
            throw new IllegalStateException(("No constructor for " + $this$bindToConstructor + ": " + CacheKt.getInfo($this$bindToConstructor)).toString());
        }
        ConstructorInfo constructorInfo2 = constructorInfo;
        Constructor<?> candidate2 = constructorInfo2.getConstructor();
        return new ConstructorBinding(candidate2, ResolveKt.bindArguments(candidate2, constructorInfo2.getParameters(), context2));
    }

    @NotNull
    public static final MethodBinding bindToMethod(@NotNull Method $this$bindToMethod, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter($this$bindToMethod, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        Member member2 = $this$bindToMethod;
        Type[] typeArray = $this$bindToMethod.getGenericParameterTypes();
        Intrinsics.checkNotNullExpressionValue(typeArray, "genericParameterTypes");
        return new MethodBinding($this$bindToMethod, ResolveKt.bindArguments(member2, ArraysKt.toList((Object[])typeArray), context2));
    }

    private static final List<ValueDescriptor> bindArguments(Member $this$bindArguments, List<? extends Type> parameters2, ValueResolveContext context2) {
        ArrayList<ValueDescriptor> bound = new ArrayList<ValueDescriptor>(parameters2.size());
        List unsatisfied = null;
        for (Type type2 : parameters2) {
            ValueDescriptor descriptor2 = context2.resolve(type2);
            if (descriptor2 == null) {
                if (unsatisfied == null) {
                    unsatisfied = new ArrayList();
                }
                unsatisfied.add(type2);
                continue;
            }
            bound.add(descriptor2);
        }
        if (unsatisfied != null) {
            throw new UnresolvedDependenciesException("Dependencies for `" + $this$bindArguments + "` cannot be satisfied:\n  " + unsatisfied);
        }
        return bound;
    }
}

