/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.DecompiledTryDescriptor;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.utils.SmartSet;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001aD\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\nH\u0002\u001a\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a$\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"collectDecompiledTryDescriptors", "", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/DecompiledTryDescriptor;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "insertSaveRestoreStackMarkers", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "decompiledTryDescriptorForStart", "newTryStartLabels", "", "insertTryCatchBlocksMarkers", "transformTryCatchBlocks", "", "Ljava/util/HashMap;", "debugString", "", "tcb", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "isDefaultHandlerNode", "", "backend"})
public final class AnalyzeTryCatchBlocksKt {
    private static final boolean isDefaultHandlerNode(TryCatchBlockNode $this$isDefaultHandlerNode) {
        return Intrinsics.areEqual($this$isDefaultHandlerNode.start, $this$isDefaultHandlerNode.handler);
    }

    private static final String debugString(MethodNode $this$debugString, TryCatchBlockNode tcb) {
        return "TCB<" + $this$debugString.instructions.indexOf(tcb.start) + ", " + $this$debugString.instructions.indexOf(tcb.end) + ", " + $this$debugString.instructions.indexOf(tcb.handler) + '>';
    }

    @NotNull
    public static final Map<AbstractInsnNode, AbstractInsnNode> insertTryCatchBlocksMarkers(@NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        if (methodNode.tryCatchBlocks.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart = AnalyzeTryCatchBlocksKt.collectDecompiledTryDescriptors(methodNode);
        HashMap<LabelNode, LabelNode> newTryStartLabels = new HashMap<LabelNode, LabelNode>();
        Map<AbstractInsnNode, AbstractInsnNode> restoreStackToSaveStackMarker = AnalyzeTryCatchBlocksKt.insertSaveRestoreStackMarkers(decompiledTryDescriptorForStart, methodNode, (Map<LabelNode, LabelNode>)newTryStartLabels);
        AnalyzeTryCatchBlocksKt.transformTryCatchBlocks(methodNode, newTryStartLabels);
        return restoreStackToSaveStackMarker;
    }

    /*
     * WARNING - void declaration
     */
    private static final void transformTryCatchBlocks(MethodNode methodNode, HashMap<LabelNode, LabelNode> newTryStartLabels) {
        Collection<TryCatchBlockNode> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable<TryCatchBlockNode> iterable = methodNode.tryCatchBlocks;
        Intrinsics.checkNotNullExpressionValue(iterable, "methodNode.tryCatchBlocks");
        iterable = iterable;
        MethodNode methodNode2 = methodNode;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tcb;
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            LabelNode newTryStartLabel = newTryStartLabels.get(tcb.start);
            TryCatchBlockNode tryCatchBlockNode2 = newTryStartLabel == null ? tcb : new TryCatchBlockNode(newTryStartLabel, tcb.end, tcb.handler, tcb.type);
            collection.add(tryCatchBlockNode2);
        }
        collection = (List)destination$iv$iv;
        methodNode2.tryCatchBlocks = collection;
    }

    private static final Map<AbstractInsnNode, AbstractInsnNode> insertSaveRestoreStackMarkers(Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart, MethodNode methodNode, Map<LabelNode, LabelNode> newTryStartLabels) {
        HashMap restoreStackToSaveMarker = new HashMap();
        HashMap saveStackMarkerByTryLabel = new HashMap();
        HashSet<LabelNode> doneHandlerLabels = new HashSet<LabelNode>();
        Iterator<DecompiledTryDescriptor> iterator2 = decompiledTryDescriptorForStart.values().iterator();
        while (iterator2.hasNext()) {
            Object object;
            DecompiledTryDescriptor decompiledTryDescriptor;
            DecompiledTryDescriptor $this$insertSaveRestoreStackMarkers_u24lambda_u2d5 = decompiledTryDescriptor = iterator2.next();
            boolean bl = false;
            AbstractInsnNode saveStackMarker = null;
            Object object2 = saveStackMarkerByTryLabel;
            Object object3 = object2;
            LabelNode labelNode = $this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getTryStartLabel();
            if (!object3.containsKey(labelNode)) {
                AbstractInsnNode nopNode;
                Object finger$iv;
                AbstractInsnNode $this$findNextOrNull$iv = $this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getTryStartLabel();
                boolean $i$f$findNextOrNull = false;
                for (finger$iv = $this$findNextOrNull$iv.getNext(); finger$iv != null; finger$iv = ((AbstractInsnNode)finger$iv).getNext()) {
                    object = finger$iv;
                    AbstractInsnNode it = object;
                    boolean bl2 = false;
                    if (UtilKt.hasOpcode(it)) break;
                }
                Intrinsics.checkNotNull(finger$iv);
                boolean bl3 = $this$findNextOrNull$iv = nopNode.getOpcode() == 0;
                if (_Assertions.ENABLED && !$this$findNextOrNull$iv) {
                    boolean $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$32 = false;
                    String $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$32 = methodNode.instructions.indexOf(nopNode) + ": try block should start with NOP";
                    throw new AssertionError((Object)$i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$32);
                }
                LabelNode newTryStartLabel = new LabelNode(new Label());
                Map<LabelNode, LabelNode> $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$32 = newTryStartLabels;
                finger$iv = $this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getTryStartLabel();
                $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$32.put((LabelNode)finger$iv, newTryStartLabel);
                saveStackMarker = PseudoInsn.SAVE_STACK_BEFORE_TRY.createInsnNode();
                MethodInsnNode restoreStackMarker = PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode();
                finger$iv = saveStackMarkerByTryLabel;
                object = $this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getTryStartLabel();
                finger$iv.put(object, saveStackMarker);
                finger$iv = restoreStackToSaveMarker;
                finger$iv.put(restoreStackMarker, saveStackMarker);
                methodNode.instructions.insertBefore(nopNode, saveStackMarker);
                methodNode.instructions.insertBefore(nopNode, newTryStartLabel);
                methodNode.instructions.insert(nopNode, restoreStackMarker);
            } else {
                Object v = saveStackMarkerByTryLabel.get($this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getTryStartLabel());
                Intrinsics.checkNotNull(v);
                object2 = v;
                Intrinsics.checkNotNullExpressionValue(object2, "saveStackMarkerByTryLabel[tryStartLabel]!!");
                saveStackMarker = (AbstractInsnNode)object2;
            }
            for (LabelNode handlerStartLabel : $this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getHandlerStartLabels()) {
                AbstractInsnNode storeNode;
                AbstractInsnNode finger$iv;
                if (doneHandlerLabels.contains(handlerStartLabel)) continue;
                doneHandlerLabels.add(handlerStartLabel);
                Intrinsics.checkNotNullExpressionValue(handlerStartLabel, "handlerStartLabel");
                AbstractInsnNode $this$findNextOrNull$iv = handlerStartLabel;
                boolean $i$f$findNextOrNull = false;
                for (finger$iv = $this$findNextOrNull$iv.getNext(); finger$iv != null; finger$iv = finger$iv.getNext()) {
                    AbstractInsnNode abstractInsnNode;
                    AbstractInsnNode it = abstractInsnNode = finger$iv;
                    boolean bl4 = false;
                    if (UtilKt.hasOpcode(it)) break;
                }
                Intrinsics.checkNotNull(finger$iv);
                boolean bl5 = $this$findNextOrNull$iv = storeNode.getOpcode() == 58;
                if (_Assertions.ENABLED && !$this$findNextOrNull$iv) {
                    boolean bl6 = false;
                    String string2 = methodNode.instructions.indexOf(storeNode) + ": handler should start with ASTORE";
                    throw new AssertionError((Object)string2);
                }
                MethodInsnNode restoreStackMarker = PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode();
                object = restoreStackToSaveMarker;
                object.put(restoreStackMarker, saveStackMarker);
                methodNode.instructions.insert(storeNode, restoreStackMarker);
            }
        }
        return restoreStackToSaveMarker;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<LabelNode, DecompiledTryDescriptor> collectDecompiledTryDescriptors(MethodNode methodNode) {
        Object it;
        void $this$mapNotNullTo$iv;
        Map decompiledTryDescriptorForStart = new HashMap();
        Map decompiledTryDescriptorForHandler = new HashMap();
        Object object = methodNode.tryCatchBlocks;
        Intrinsics.checkNotNullExpressionValue(object, "methodNode.tryCatchBlocks");
        object = (Iterable)object;
        Collection destination$iv = SmartSet.Companion.create();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LabelNode labelNode;
            LabelNode labelNode2;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl4 = false;
            it = (TryCatchBlockNode)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            LabelNode labelNode3 = labelNode2 = AnalyzeTryCatchBlocksKt.isDefaultHandlerNode((TryCatchBlockNode)it) ? ((TryCatchBlockNode)it).handler : null;
            if (labelNode2 == null) continue;
            LabelNode it$iv = labelNode = labelNode2;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        SmartSet defaultHandlers = (SmartSet)destination$iv;
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            DecompiledTryDescriptor decompiledTryDescriptor;
            Object object2;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullExpressionValue(tcb, "tcb");
            if (AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) {
                $i$f$mapNotNullTo = decompiledTryDescriptorForHandler.containsKey(tcb.start);
                if (_Assertions.ENABLED && !$i$f$mapNotNullTo) {
                    boolean $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22 = false;
                    String $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22 = Intrinsics.stringPlus(AnalyzeTryCatchBlocksKt.debugString(methodNode, tcb), ": default handler should occur after some regular handler");
                    throw new AssertionError((Object)$i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22);
                }
            }
            Map $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22 = decompiledTryDescriptorForHandler;
            LabelNode $i$f$forEach2 = tcb.handler;
            Intrinsics.checkNotNullExpressionValue($i$f$forEach2, "tcb.handler");
            LabelNode key$iv = $i$f$forEach2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                Object object3;
                void $this$getOrPut$iv2;
                boolean bl = false;
                Map bl4 = decompiledTryDescriptorForStart;
                it = tcb.start;
                Intrinsics.checkNotNullExpressionValue(it, "tcb.start");
                Object key$iv2 = it;
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                if (value$iv2 == null) {
                    boolean bl5 = false;
                    LabelNode labelNode = tcb.start;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "tcb.start");
                    DecompiledTryDescriptor answer$iv = new DecompiledTryDescriptor(labelNode);
                    $this$getOrPut$iv2.put(key$iv2, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv2;
                }
                DecompiledTryDescriptor answer$iv = (DecompiledTryDescriptor)object3;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            DecompiledTryDescriptor $this$collectDecompiledTryDescriptors_u24lambda_u2d11 = decompiledTryDescriptor = (DecompiledTryDescriptor)object2;
            boolean bl = false;
            if (AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) {
                boolean bl6;
                boolean bl7 = bl6 = $this$collectDecompiledTryDescriptors_u24lambda_u2d11.getDefaultHandlerTcb() == null;
                if (_Assertions.ENABLED && !bl6) {
                    boolean bl8 = false;
                    StringBuilder stringBuilder2 = new StringBuilder().append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tcb)).append(": default handler is already found: ");
                    TryCatchBlockNode tryCatchBlockNode = $this$collectDecompiledTryDescriptors_u24lambda_u2d11.getDefaultHandlerTcb();
                    Intrinsics.checkNotNull(tryCatchBlockNode);
                    String string2 = stringBuilder2.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode)).toString();
                    throw new AssertionError((Object)string2);
                }
                $this$collectDecompiledTryDescriptors_u24lambda_u2d11.setDefaultHandlerTcb(tcb);
            }
            if (defaultHandlers.contains(tcb.handler)) continue;
            $this$collectDecompiledTryDescriptors_u24lambda_u2d11.getHandlerStartLabels().add(tcb.handler);
        }
        return decompiledTryDescriptorForStart;
    }
}

