/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.GenerateMultifileFacadesKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/UpdateConstantFacadePropertyReferences;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "shouldGeneratePartHierarchy", "", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Z)V", "getReplacementFacadeClassOrNull", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irClass", "lower", "", "backend.jvm.lower"})
final class UpdateConstantFacadePropertyReferences
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    private final boolean shouldGeneratePartHierarchy;

    public UpdateConstantFacadePropertyReferences(@NotNull JvmBackendContext context2, boolean shouldGeneratePartHierarchy) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.shouldGeneratePartHierarchy = shouldGeneratePartHierarchy;
    }

    @Override
    public void lower(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        IrClass irClass3 = this.getReplacementFacadeClassOrNull(irClass2);
        if (irClass3 == null) {
            return;
        }
        IrClass facadeClass = irClass3;
        IrElementTransformerVoidKt.transformChildrenVoid(irClass2, new IrElementTransformerVoid(facadeClass){
            final /* synthetic */ IrClass $facadeClass;
            {
                this.$facadeClass = $facadeClass;
            }

            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration2) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return declaration2;
            }

            @NotNull
            public IrExpression visitClassReference(@NotNull IrClassReference expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return new IrClassReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), IrUtilsKt.getDefaultType(this.$facadeClass), this.$facadeClass.getSymbol(), IrUtilsKt.getDefaultType(this.$facadeClass));
            }
        });
    }

    private final IrClass getReplacementFacadeClassOrNull(IrClass irClass2) {
        IrElement irElement;
        IrSimpleFunction irSimpleFunction;
        IrPropertySymbol irPropertySymbol;
        Object object;
        if (!Intrinsics.areEqual(irClass2.getOrigin(), JvmLoweredDeclarationOrigin.GENERATED_PROPERTY_REFERENCE.INSTANCE) && !Intrinsics.areEqual(irClass2.getOrigin(), JvmLoweredDeclarationOrigin.FUNCTION_REFERENCE_IMPL.INSTANCE)) {
            return null;
        }
        IrAttributeContainer callableReference = irClass2.getAttributeOwnerId();
        IrElement irElement2 = callableReference instanceof IrPropertyReference ? (IrElement)((object = ((IrPropertyReference)callableReference).getGetter()) == null ? null : ((irPropertySymbol = (irSimpleFunction = (IrSimpleFunction)object.getOwner()).getCorrespondingPropertySymbol()) == null ? null : (IrProperty)irPropertySymbol.getOwner())) : (irElement = callableReference instanceof IrFunctionReference ? (IrElement)((IrFunctionSymbol)((IrFunctionReference)callableReference).getSymbol()).getOwner() : null);
        if (irElement == null) {
            return null;
        }
        IrElement declaration2 = irElement;
        object = ((IrDeclarationBase)declaration2).getParent();
        IrAttributeContainer irAttributeContainer = callableReference = object instanceof IrClass ? (IrClass)object : null;
        if (callableReference == null) {
            return null;
        }
        IrAttributeContainer parent2 = callableReference;
        IrClass facadeClass = this.context.getMultifileFacadeClassForPart().get(parent2.getAttributeOwnerId());
        return this.shouldGeneratePartHierarchy || declaration2 instanceof IrProperty && ((object = ((IrProperty)declaration2).getBackingField()) == null ? false : GenerateMultifileFacadesKt.access$shouldMoveToFacade((IrField)object)) ? facadeClass : null;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

