/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.JsLibrary;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000bH\u0007J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000bH\u0007J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J$\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0002J$\u0010\"\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0002J$\u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0002J*\u0010$\u001a\u00020\t2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0007J$\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u000b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0007J\u000e\u0010(\u001a\u0004\u0018\u00010\u0007*\u00020\u000bH\u0002J\f\u0010)\u001a\u00020\u000b*\u00020\u000bH\u0002J(\u0010*\u001a\u00020\t*\u00020\u000b2\u0006\u0010+\u001a\u00020\u00072\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/utils/JsLibraryUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "META_INF_RESOURCES", "", "copyJsFilesFromDirectory", "", "dir", "Ljava/io/File;", "outputLibraryJsPath", "copySourceMap", "", "copyJsFilesFromLibraries", "libraries", "", "copyJsFilesFromZip", "file", "copyLibrary", "outputPath", "library", "Lorg/jetbrains/kotlin/utils/JsLibrary;", "getSuggestedPath", "path", "isKotlinJavascriptIrLibrary", "candidate", "isKotlinJavascriptLibrary", "isZippedKlib", "isZippedKlibInZip", "processDirectory", "action", "Lkotlin/Function1;", "traverseArchive", "traverseDirectory", "traverseJsLibraries", "libs", "traverseJsLibrary", "lib", "contentIfExists", "correspondingSourceMapFile", "runIfFileExists", "relativePath", "js.config"})
public final class JsLibraryUtils {
    @NotNull
    public static final JsLibraryUtils INSTANCE = new JsLibraryUtils();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String META_INF_RESOURCES;

    private JsLibraryUtils() {
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptLibrary(@NotNull File library) {
        Intrinsics.checkNotNullParameter(library, "library");
        Collection collection = KotlinJavascriptMetadataUtils.loadMetadata(library);
        boolean bl = false;
        return !collection.isEmpty();
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptIrLibrary(@NotNull File candidate2) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        return INSTANCE.isZippedKlib(candidate2) ? true : (FileUtil.isJarOrZip(candidate2) ? INSTANCE.isZippedKlibInZip(candidate2) : (!new File(candidate2, "manifest").isFile() ? false : new File(candidate2, "ir").isDirectory()));
    }

    @JvmStatic
    public static final void copyJsFilesFromLibraries(@NotNull List<String> libraries, @NotNull String outputLibraryJsPath, boolean copySourceMap) {
        Intrinsics.checkNotNullParameter(libraries, "libraries");
        Intrinsics.checkNotNullParameter(outputLibraryJsPath, "outputLibraryJsPath");
        for (String library : libraries) {
            File file2 = new File(library);
            boolean bl = file2.exists();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Library " + library + " not found";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            if (file2.isDirectory()) {
                INSTANCE.copyJsFilesFromDirectory(file2, outputLibraryJsPath, copySourceMap);
                continue;
            }
            INSTANCE.copyJsFilesFromZip(file2, outputLibraryJsPath, copySourceMap);
        }
    }

    public static /* synthetic */ void copyJsFilesFromLibraries$default(List list2, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        JsLibraryUtils.copyJsFilesFromLibraries(list2, string2, bl);
    }

    @JvmStatic
    public static final void traverseJsLibraries(@NotNull List<? extends File> libs, @NotNull Function1<? super JsLibrary, Unit> action) {
        Intrinsics.checkNotNullParameter(libs, "libs");
        Intrinsics.checkNotNullParameter(action, "action");
        Iterable $this$forEach$iv = libs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            JsLibraryUtils.traverseJsLibrary(it, action);
        }
    }

    @JvmStatic
    public static final void traverseJsLibrary(@NotNull File lib, @NotNull Function1<? super JsLibrary, Unit> action) {
        Intrinsics.checkNotNullParameter(lib, "lib");
        Intrinsics.checkNotNullParameter(action, "action");
        if (lib.isDirectory()) {
            INSTANCE.traverseDirectory(lib, action);
        } else if (FileUtil.isJarOrZip(lib)) {
            INSTANCE.traverseArchive(lib, action);
        } else {
            String string2 = lib.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "lib.name");
            if (StringsKt.endsWith$default(string2, ".js", false, 2, null)) {
                File jsFile;
                string2 = lib.getPath();
                Intrinsics.checkNotNullExpressionValue(string2, "lib.path");
                INSTANCE.runIfFileExists(lib, string2, action);
                File file2 = jsFile = FileUtilsKt.withReplacedExtensionOrNull(lib, ".meta.js", ".js");
                if (file2 != null) {
                    String string3 = jsFile.getPath();
                    Intrinsics.checkNotNullExpressionValue(string3, "jsFile.path");
                    INSTANCE.runIfFileExists(file2, string3, action);
                }
            }
        }
    }

    private final boolean isZippedKlibInZip(File candidate2) {
        boolean manifestFound = false;
        boolean irFound = false;
        Enumeration<? extends ZipEntry> enumeration = new ZipFile(candidate2).entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, "ZipFile(candidate).entries()");
        Iterator<? extends ZipEntry> iterator2 = CollectionsKt.iterator(enumeration);
        while (iterator2.hasNext()) {
            ZipEntry entry = iterator2.next();
            if (Intrinsics.areEqual(entry.getName(), "manifest")) {
                manifestFound = true;
            }
            if (!Intrinsics.areEqual(entry.getName(), "ir/")) continue;
            irFound = true;
        }
        return manifestFound && irFound;
    }

    private final boolean isZippedKlib(File candidate2) {
        return Intrinsics.areEqual(FilesKt.getExtension(candidate2), "klib");
    }

    private final void runIfFileExists(File $this$runIfFileExists, String relativePath, Function1<? super JsLibrary, Unit> action) {
        if ($this$runIfFileExists.isFile()) {
            action.invoke(new JsLibrary(FilesKt.readText$default($this$runIfFileExists, null, 1, null), relativePath, this.contentIfExists(this.correspondingSourceMapFile($this$runIfFileExists)), $this$runIfFileExists));
        }
    }

    private final void copyJsFilesFromDirectory(File dir, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseDirectory(dir, (Function1<? super JsLibrary, Unit>)new Function1<JsLibrary, Unit>(outputLibraryJsPath, copySourceMap){
            final /* synthetic */ String $outputLibraryJsPath;
            final /* synthetic */ boolean $copySourceMap;
            {
                this.$outputLibraryJsPath = $outputLibraryJsPath;
                this.$copySourceMap = $copySourceMap;
                super(1);
            }

            public final void invoke(@NotNull JsLibrary it) {
                Intrinsics.checkNotNullParameter(it, "it");
                JsLibraryUtils.access$copyLibrary(JsLibraryUtils.INSTANCE, this.$outputLibraryJsPath, it, this.$copySourceMap);
            }
        });
    }

    private final String contentIfExists(File $this$contentIfExists) {
        return $this$contentIfExists.exists() ? FilesKt.readText$default($this$contentIfExists, null, 1, null) : null;
    }

    private final File correspondingSourceMapFile(File $this$correspondingSourceMapFile) {
        return new File($this$correspondingSourceMapFile.getParentFile(), Intrinsics.stringPlus($this$correspondingSourceMapFile.getName(), ".map"));
    }

    private final void processDirectory(File dir, Function1<? super JsLibrary, Unit> action) {
        FileUtil.processFilesRecursively(dir, arg_0 -> JsLibraryUtils.processDirectory$lambda-2(dir, action, arg_0));
    }

    private final void traverseDirectory(File dir, Function1<? super JsLibrary, Unit> action) {
        try {
            this.processDirectory(dir, action);
        }
        catch (IOException ex) {
            LOG.error("Could not read files from directory " + dir.getName() + ": " + ex.getMessage());
        }
    }

    private final void copyJsFilesFromZip(File file2, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseArchive(file2, (Function1<? super JsLibrary, Unit>)new Function1<JsLibrary, Unit>(outputLibraryJsPath, copySourceMap){
            final /* synthetic */ String $outputLibraryJsPath;
            final /* synthetic */ boolean $copySourceMap;
            {
                this.$outputLibraryJsPath = $outputLibraryJsPath;
                this.$copySourceMap = $copySourceMap;
                super(1);
            }

            public final void invoke(@NotNull JsLibrary it) {
                Intrinsics.checkNotNullParameter(it, "it");
                JsLibraryUtils.access$copyLibrary(JsLibraryUtils.INSTANCE, this.$outputLibraryJsPath, it, this.$copySourceMap);
            }
        });
    }

    private final void copyLibrary(String outputPath, JsLibrary library, boolean copySourceMap) {
        String string2;
        File targetFile = new File(outputPath, library.getPath());
        targetFile.getParentFile().mkdirs();
        FilesKt.writeText$default(targetFile, library.getContent(), null, 2, null);
        if (copySourceMap && (string2 = library.getSourceMapContent()) != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            FilesKt.writeText$default(new File(targetFile.getParent(), Intrinsics.stringPlus(targetFile.getName(), ".map")), it, null, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void traverseArchive(File file2, Function1<? super JsLibrary, Unit> action) {
        ZipFile zipFile2;
        try {
            zipFile2 = new ZipFile(file2.getPath());
        }
        catch (ZipException e) {
            throw new IOException(Intrinsics.stringPlus("Failed to open zip file: ", file2), e);
        }
        try (ZipFile zipFile3 = zipFile2;){
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String correspondingJsPath;
            Enumeration<? extends ZipEntry> zipEntries = zipFile3.entries();
            boolean bl = false;
            List librariesWithoutSourceMaps = new ArrayList();
            boolean bl2 = false;
            Map possibleMapFiles = new LinkedHashMap();
            while (zipEntries.hasMoreElements()) {
                Object content;
                Object stream;
                ZipEntry entry = zipEntries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory()) continue;
                Intrinsics.checkNotNullExpressionValue(entryName, "entryName");
                if (StringsKt.endsWith$default(entryName, ".js", false, 2, null)) {
                    String string2 = this.getSuggestedPath(entryName);
                    if (string2 == null) continue;
                    String relativePath = string2;
                    stream = zipFile3.getInputStream(entry);
                    Intrinsics.checkNotNullExpressionValue(stream, "stream");
                    Object object = stream;
                    Object object2 = Charsets.UTF_8;
                    boolean bl3 = false;
                    content = TextStreamsKt.readText(new InputStreamReader((InputStream)object, (Charset)object2));
                    object = librariesWithoutSourceMaps;
                    object2 = new JsLibrary((String)content, relativePath, null, null);
                    bl3 = false;
                    object.add(object2);
                    continue;
                }
                if (!StringsKt.endsWith$default(entryName, ".js.map", false, 2, null)) continue;
                correspondingJsPath = Intrinsics.stringPlus(StringsKt.removeSuffix(entryName, (CharSequence)".js.map"), ".js");
                stream = possibleMapFiles;
                Intrinsics.checkNotNullExpressionValue(entry, "entry");
                content = entry;
                boolean bl4 = false;
                stream.put(correspondingJsPath, content);
            }
            Iterable entry = librariesWithoutSourceMaps;
            boolean $i$f$map = false;
            correspondingJsPath = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsLibrary jsLibrary;
                void it;
                JsLibrary jsLibrary2 = (JsLibrary)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                ZipEntry zipEntry = (ZipEntry)possibleMapFiles.get(it.getPath());
                if (zipEntry != null) {
                    InputStream stream = zipFile3.getInputStream(zipEntry);
                    Intrinsics.checkNotNullExpressionValue(stream, "stream");
                    InputStream inputStream = stream;
                    Charset charset = Charsets.UTF_8;
                    boolean bl6 = false;
                    String content = TextStreamsKt.readText(new InputStreamReader(inputStream, charset));
                    jsLibrary = JsLibrary.copy$default((JsLibrary)it, null, null, content, null, 11, null);
                } else {
                    jsLibrary = it;
                }
                void var23_35 = jsLibrary;
                collection.add(var23_35);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke((JsLibrary)element$iv);
            }
        }
    }

    private final String getSuggestedPath(String path2) {
        String string2 = FileUtil.toSystemIndependentName(path2);
        Intrinsics.checkNotNullExpressionValue(string2, "toSystemIndependentName(path)");
        String systemIndependentPath = string2;
        if (StringsKt.startsWith$default(systemIndependentPath, LibraryUtils.INSTANCE.getMETA_INF(), false, 2, null)) {
            if (StringsKt.startsWith$default(systemIndependentPath, META_INF_RESOURCES, false, 2, null)) {
                string2 = path2;
                int n = META_INF_RESOURCES.length();
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
                return string4;
            }
            return null;
        }
        return path2;
    }

    private static final boolean processDirectory$lambda-2(File $dir, Function1 $action, File file2) {
        Intrinsics.checkNotNullParameter($dir, "$dir");
        Intrinsics.checkNotNullParameter($action, "$action");
        String string2 = FileUtil.getRelativePath($dir, file2);
        if (string2 == null) {
            throw new IllegalArgumentException("relativePath should not be null " + $dir + ' ' + file2);
        }
        String string3 = string2;
        String relativePath = string3;
        if (StringsKt.endsWith$default(relativePath, ".js", false, 2, null)) {
            string2 = INSTANCE.getSuggestedPath(relativePath);
            if (string2 == null) {
                return true;
            }
            String suggestedRelativePath = string2;
            Intrinsics.checkNotNullExpressionValue(file2, "file");
            INSTANCE.runIfFileExists(file2, suggestedRelativePath, $action);
        }
        return true;
    }

    public static final /* synthetic */ void access$copyLibrary(JsLibraryUtils $this, String outputPath, JsLibrary library, boolean copySourceMap) {
        $this.copyLibrary(outputPath, library, copySourceMap);
    }

    static {
        Logger logger = Logger.getInstance(JsLibraryUtils.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(JsLibraryUtils::class.java)");
        LOG = logger;
        META_INF_RESOURCES = Intrinsics.stringPlus(LibraryUtils.INSTANCE.getMETA_INF(), "resources/");
    }
}

