/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationCheckerUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkSuperTypeNotInitialized", "primaryConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "regularClass", "checkSupertypeInitializedWithoutPrimaryConstructor", "checkers"})
public final class FirPrimaryConstructorSuperTypeChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirPrimaryConstructorSuperTypeChecker INSTANCE = new FirPrimaryConstructorSuperTypeChecker();

    private FirPrimaryConstructorSuperTypeChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Object $this$isInterface$iv = declaration2;
        boolean $i$f$isInterface = false;
        if ($this$isInterface$iv.getClassKind() == ClassKind.INTERFACE) {
            $this$isInterface$iv = SourceNavigator.Companion.forElement(declaration2);
            boolean bl = false;
            boolean bl2 = false;
            Object $this$check_u24lambda_u2d0 = $this$isInterface$iv;
            boolean bl3 = false;
            for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
                if (!$this$check_u24lambda_u2d0.isInConstructorCallee(superTypeRef)) continue;
                DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_INTERFACE(), context2, null, 8, null);
            }
            return;
        }
        FirConstructor primaryConstructor2 = FirDeclarationUtilKt.getPrimaryConstructor(declaration2);
        if (primaryConstructor2 == null) {
            this.checkSupertypeInitializedWithoutPrimaryConstructor(declaration2, reporter, context2);
        } else {
            this.checkSuperTypeNotInitialized(primaryConstructor2, declaration2, context2, reporter);
        }
    }

    private final void checkSuperTypeNotInitialized(FirConstructor primaryConstructor2, FirRegularClass regularClass, CheckerContext context2, DiagnosticReporter reporter) {
        Object v0;
        block14: {
            Iterable $this$lastIsInstanceOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            Iterable iterable = $this$lastIsInstanceOrNull$iv;
            if (iterable instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n) {
                    do {
                        int i$iv;
                        Object element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirRegularClass)) continue;
                        v0 = element$iv;
                        break block14;
                    } while (0 <= n);
                }
                v0 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed($this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirRegularClass)) continue;
                    v0 = element$iv$iv;
                    break block14;
                }
                v0 = null;
            }
        }
        FirRegularClass containingClass = v0;
        FirDelegatedConstructorCall $i$f$lastIsInstanceOrNull = primaryConstructor2.getDelegatedConstructor();
        if ($i$f$lastIsInstanceOrNull == null) {
            return;
        }
        FirDelegatedConstructorCall delegatedConstructorCall = $i$f$lastIsInstanceOrNull;
        FirTypeRef constructedTypeRef = delegatedConstructorCall.getConstructedTypeRef();
        if (constructedTypeRef instanceof FirImplicitAnyTypeRef) {
            return;
        }
        FirRegularClass $this$firstIsInstanceOrNull$iv$iv = FirHelpersKt.toRegularClass(FirTypeUtilsKt.getConeType(constructedTypeRef), context2.getSession());
        if ($this$firstIsInstanceOrNull$iv$iv == null) {
            return;
        }
        FirRegularClass superClass = $this$firstIsInstanceOrNull$iv$iv;
        if (superClass.getClassKind().isSingleton()) {
            return;
        }
        if (FirDeclarationCheckerUtilsKt.isEffectivelyExpect(regularClass, containingClass, context2) || FirDeclarationCheckerUtilsKt.isEffectivelyExternal(regularClass, containingClass, context2)) {
            return;
        }
        FirSourceElement firSourceElement = delegatedConstructorCall.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement delegatedCallSource = firSourceElement;
        if (!(delegatedCallSource.getKind() instanceof FirFakeSourceElementKind)) {
            return;
        }
        if (Intrinsics.areEqual(superClass.getSymbol().getClassId(), StandardClassIds.INSTANCE.getEnum())) {
            return;
        }
        if (!Intrinsics.areEqual(delegatedCallSource.getElementType(), KtNodeTypes.SUPER_TYPE_CALL_ENTRY)) {
            DiagnosticReporterKt.reportOn$default(reporter, constructedTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_NOT_INITIALIZED(), context2, null, 8, null);
        }
    }

    private final void checkSupertypeInitializedWithoutPrimaryConstructor(FirRegularClass regularClass, DiagnosticReporter reporter, CheckerContext context2) {
        SourceNavigator sourceNavigator = SourceNavigator.Companion.forElement(regularClass);
        boolean bl = false;
        boolean bl2 = false;
        SourceNavigator $this$checkSupertypeInitializedWithoutPrimaryConstructor_u24lambda_u2d1 = sourceNavigator;
        boolean bl3 = false;
        for (FirTypeRef superTypeRef : regularClass.getSuperTypeRefs()) {
            if (!$this$checkSupertypeInitializedWithoutPrimaryConstructor_u24lambda_u2d1.isInConstructorCallee(superTypeRef)) continue;
            DiagnosticReporterKt.reportOn$default(reporter, regularClass.getSource(), FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR(), context2, null, 8, null);
        }
    }
}

