/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.parser.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.Configuration;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ExtraInfoHolder;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.IncludeRule;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.License;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.org.apache.ivy.plugins.matcher.MapMatcher;
import org.jetbrains.kotlin.org.apache.ivy.util.DateUtil;
import org.jetbrains.kotlin.org.apache.ivy.util.Message;
import org.jetbrains.kotlin.org.apache.ivy.util.StringUtils;
import org.jetbrains.kotlin.org.apache.ivy.util.XMLHelper;
import org.jetbrains.kotlin.org.apache.ivy.util.extendable.ExtendableItem;

public final class XmlModuleDescriptorWriter {
    public static void write(ModuleDescriptor md, File output) throws IOException {
        XmlModuleDescriptorWriter.write(md, null, output);
    }

    public static void write(ModuleDescriptor md, String licenseHeader, File output) throws IOException {
        if (output.getParentFile() != null) {
            output.getParentFile().mkdirs();
        }
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8));){
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (licenseHeader != null) {
                out.print(licenseHeader);
            }
            StringBuilder xmlNamespace = new StringBuilder();
            Map<String, String> namespaces = md.getExtraAttributesNamespaces();
            for (Map.Entry<String, String> ns : namespaces.entrySet()) {
                xmlNamespace.append(" xmlns:").append(ns.getKey()).append("=\"").append(ns.getValue()).append("\"");
            }
            String version = "2.0";
            if (md.getInheritedDescriptors().length > 0) {
                version = "2.2";
            }
            out.println("<ivy-module version=\"" + version + "\"" + xmlNamespace + ">");
            XmlModuleDescriptorWriter.printInfoTag(md, out);
            XmlModuleDescriptorWriter.printConfigurations(md, out);
            XmlModuleDescriptorWriter.printPublications(md, out);
            XmlModuleDescriptorWriter.printDependencies(md, out);
            out.println("</ivy-module>");
        }
    }

    private static void printDependencies(ModuleDescriptor md, PrintWriter out) {
        DependencyDescriptor[] dds = md.getDependencies();
        if (dds.length > 0) {
            out.println("\t<dependencies>");
            for (DependencyDescriptor dep : dds) {
                out.print("\t\t");
                XmlModuleDescriptorWriter.printDependency(md, dep, out);
            }
            XmlModuleDescriptorWriter.printAllExcludes(md, out);
            XmlModuleDescriptorWriter.printAllMediators(md, out);
            out.println("\t</dependencies>");
        }
    }

    protected static void printDependency(ModuleDescriptor md, DependencyDescriptor dep, PrintWriter out) {
        ModuleRevisionId dependencyRevisionId = dep.getDependencyRevisionId();
        out.print(String.format("<dependency org=\"%s\" name=\"%s\"", XMLHelper.escape(dependencyRevisionId.getOrganisation()), XMLHelper.escape(dependencyRevisionId.getName())));
        if (dependencyRevisionId.getBranch() != null) {
            out.print(" branch=\"" + XMLHelper.escape(dependencyRevisionId.getBranch()) + "\"");
        }
        out.print(" rev=\"" + XMLHelper.escape(dependencyRevisionId.getRevision()) + "\"");
        ModuleRevisionId dynamicConstraintDependencyRevisionId = dep.getDynamicConstraintDependencyRevisionId();
        if (!dynamicConstraintDependencyRevisionId.equals(dependencyRevisionId)) {
            if (dynamicConstraintDependencyRevisionId.getBranch() != null) {
                out.print(" branchConstraint=\"" + XMLHelper.escape(dynamicConstraintDependencyRevisionId.getBranch()) + "\"");
            }
            out.print(" revConstraint=\"" + XMLHelper.escape(dynamicConstraintDependencyRevisionId.getRevision()) + "\"");
        }
        if (dep.isForce()) {
            out.print(" force=\"" + dep.isForce() + "\"");
        }
        if (dep.isChanging()) {
            out.print(" changing=\"" + dep.isChanging() + "\"");
        }
        if (!dep.isTransitive()) {
            out.print(" transitive=\"" + dep.isTransitive() + "\"");
        }
        StringBuilder sb = new StringBuilder();
        for (String modConf : dep.getModuleConfigurations()) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(XMLHelper.escape(modConf)).append(XmlModuleDescriptorWriter.listToPrefixedString(dep.getDependencyConfigurations(modConf), "->"));
        }
        out.print(" conf=\"" + sb + "\"");
        XmlModuleDescriptorWriter.printExtraAttributes(dep, out, " ");
        DependencyArtifactDescriptor[] depArtifacts = dep.getAllDependencyArtifacts();
        if (depArtifacts.length > 0) {
            out.println(">");
        }
        XmlModuleDescriptorWriter.printDependencyArtefacts(md, out, depArtifacts);
        IncludeRule[] includes = dep.getAllIncludeRules();
        if (includes.length > 0 && depArtifacts.length == 0) {
            out.println(">");
        }
        XmlModuleDescriptorWriter.printDependencyIncludeRules(md, out, includes);
        ExcludeRule[] excludes = dep.getAllExcludeRules();
        if (excludes.length > 0 && includes.length == 0 && depArtifacts.length == 0) {
            out.println(">");
        }
        XmlModuleDescriptorWriter.printDependencyExcludeRules(md, out, excludes);
        if (includes.length + excludes.length + depArtifacts.length == 0) {
            out.println("/>");
        } else {
            out.println("\t\t</dependency>");
        }
    }

    private static void printAllMediators(ModuleDescriptor md, PrintWriter out) {
        Map<MapMatcher, DependencyDescriptorMediator> mediators = md.getAllDependencyDescriptorMediators().getAllRules();
        for (Map.Entry<MapMatcher, DependencyDescriptorMediator> mediatorRule : mediators.entrySet()) {
            MapMatcher matcher = mediatorRule.getKey();
            DependencyDescriptorMediator mediator = mediatorRule.getValue();
            if (mediator instanceof OverrideDependencyDescriptorMediator) {
                OverrideDependencyDescriptorMediator oddm = (OverrideDependencyDescriptorMediator)mediator;
                out.print(String.format("\t\t<override org=\"%s\" module=\"%s\" matcher=\"%s\"", XMLHelper.escape(matcher.getAttributes().get("organisation")), XMLHelper.escape(matcher.getAttributes().get("module")), XMLHelper.escape(matcher.getPatternMatcher().getName())));
                if (oddm.getBranch() != null) {
                    out.print(" branch=\"" + XMLHelper.escape(oddm.getBranch()) + "\"");
                }
                if (oddm.getVersion() != null) {
                    out.print(" rev=\"" + XMLHelper.escape(oddm.getVersion()) + "\"");
                }
                out.println("/>");
                continue;
            }
            Message.verbose("ignoring unhandled DependencyDescriptorMediator: " + mediator.getClass());
        }
    }

    private static void printAllExcludes(ModuleDescriptor md, PrintWriter out) {
        ExcludeRule[] excludes = md.getAllExcludeRules();
        if (excludes.length > 0) {
            for (ExcludeRule exclude : excludes) {
                out.print(String.format("\t\t<exclude org=\"%s\" module=\"%s\" artifact=\"%s\" type=\"%s\" ext=\"%s\"", XMLHelper.escape(exclude.getId().getModuleId().getOrganisation()), XMLHelper.escape(exclude.getId().getModuleId().getName()), XMLHelper.escape(exclude.getId().getName()), XMLHelper.escape(exclude.getId().getType()), XMLHelper.escape(exclude.getId().getExt())));
                String[] ruleConfs = exclude.getConfigurations();
                if (!Arrays.asList(ruleConfs).equals(Arrays.asList(md.getConfigurationsNames()))) {
                    out.print(XmlModuleDescriptorWriter.listToPrefixedString(ruleConfs, " conf=\""));
                }
                out.print(" matcher=\"" + XMLHelper.escape(exclude.getMatcher().getName()) + "\"");
                out.println("/>");
            }
        }
    }

    private static void printDependencyExcludeRules(ModuleDescriptor md, PrintWriter out, ExcludeRule[] excludes) {
        if (excludes.length > 0) {
            for (ExcludeRule exclude : excludes) {
                out.print(String.format("\t\t\t<exclude org=\"%s\" module=\"%s\" name=\"%s\" type=\"%s\" ext=\"%s\"", XMLHelper.escape(exclude.getId().getModuleId().getOrganisation()), XMLHelper.escape(exclude.getId().getModuleId().getName()), XMLHelper.escape(exclude.getId().getName()), XMLHelper.escape(exclude.getId().getType()), XMLHelper.escape(exclude.getId().getExt())));
                String[] ruleConfs = exclude.getConfigurations();
                if (!Arrays.asList(ruleConfs).equals(Arrays.asList(md.getConfigurationsNames()))) {
                    out.print(XmlModuleDescriptorWriter.listToPrefixedString(ruleConfs, " conf=\""));
                }
                out.print(" matcher=\"" + XMLHelper.escape(exclude.getMatcher().getName()) + "\"");
                out.println("/>");
            }
        }
    }

    private static void printDependencyIncludeRules(ModuleDescriptor md, PrintWriter out, IncludeRule[] includes) {
        if (includes.length > 0) {
            for (IncludeRule include : includes) {
                out.print(String.format("\t\t\t<include name=\"%s\" type=\"%s\" ext=\"%s\"", XMLHelper.escape(include.getId().getName()), XMLHelper.escape(include.getId().getType()), XMLHelper.escape(include.getId().getExt())));
                String[] ruleConfs = include.getConfigurations();
                if (!Arrays.asList(ruleConfs).equals(Arrays.asList(md.getConfigurationsNames()))) {
                    out.print(XmlModuleDescriptorWriter.listToPrefixedString(ruleConfs, " conf=\""));
                }
                out.print(" matcher=\"" + XMLHelper.escape(include.getMatcher().getName()) + "\"");
                out.println("/>");
            }
        }
    }

    private static void printDependencyArtefacts(ModuleDescriptor md, PrintWriter out, DependencyArtifactDescriptor[] depArtifacts) {
        if (depArtifacts.length > 0) {
            for (DependencyArtifactDescriptor depArtifact : depArtifacts) {
                out.print(String.format("\t\t\t<artifact name=\"%s\" type=\"%s\" ext=\"%s\"", XMLHelper.escape(depArtifact.getName()), XMLHelper.escape(depArtifact.getType()), XMLHelper.escape(depArtifact.getExt())));
                String[] dadConfs = depArtifact.getConfigurations();
                if (dadConfs != null && dadConfs.length > 0 && !Arrays.asList(dadConfs).equals(Arrays.asList(md.getConfigurationsNames()))) {
                    out.print(XmlModuleDescriptorWriter.listToPrefixedString(dadConfs, " conf=\""));
                }
                XmlModuleDescriptorWriter.printExtraAttributes(depArtifact, out, " ");
                out.println("/>");
            }
        }
    }

    private static String listToPrefixedString(String[] confs, String prefix) {
        StringBuilder sb = new StringBuilder(prefix);
        for (String conf : confs) {
            if (sb.length() > prefix.length()) {
                sb.append(",");
            }
            sb.append(XMLHelper.escape(conf));
        }
        if (prefix.endsWith("\"")) {
            sb.append("\"");
        }
        return sb.toString();
    }

    private static void printExtraAttributes(ExtendableItem item, PrintWriter out, String prefix) {
        XmlModuleDescriptorWriter.printExtraAttributes(item.getQualifiedExtraAttributes(), out, prefix);
    }

    private static void printExtraAttributes(Map<String, String> extra, PrintWriter out, String prefix) {
        if (extra == null) {
            return;
        }
        String delim = prefix;
        for (Map.Entry<String, String> entry : extra.entrySet()) {
            out.print(String.format("%s%s=\"%s\"", delim, entry.getKey(), XMLHelper.escape(entry.getValue())));
            delim = " ";
        }
    }

    private static void printPublications(ModuleDescriptor md, PrintWriter out) {
        out.println("\t<publications>");
        for (Artifact artifact : md.getAllArtifacts()) {
            out.print(String.format("\t\t<artifact name=\"%s\" type=\"%s\" ext=\"%s\" conf=\"%s\"", XMLHelper.escape(artifact.getName()), XMLHelper.escape(artifact.getType()), XMLHelper.escape(artifact.getExt()), XMLHelper.escape(XmlModuleDescriptorWriter.getConfs(md, artifact))));
            XmlModuleDescriptorWriter.printExtraAttributes(artifact, out, " ");
            out.println("/>");
        }
        out.println("\t</publications>");
    }

    private static void printConfigurations(ModuleDescriptor md, PrintWriter out) {
        Configuration[] confs = md.getConfigurations();
        if (confs.length > 0) {
            out.println("\t<configurations>");
            for (Configuration conf : confs) {
                out.print("\t\t");
                XmlModuleDescriptorWriter.printConfiguration(conf, out);
            }
            out.println("\t</configurations>");
        }
    }

    protected static void printConfiguration(Configuration conf, PrintWriter out) {
        String[] exts;
        out.print("<conf");
        out.print(" name=\"" + XMLHelper.escape(conf.getName()) + "\"");
        out.print(" visibility=\"" + XMLHelper.escape(conf.getVisibility().toString()) + "\"");
        if (conf.getDescription() != null) {
            out.print(" description=\"" + XMLHelper.escape(conf.getDescription()) + "\"");
        }
        if ((exts = conf.getExtends()).length > 0) {
            out.print(XmlModuleDescriptorWriter.listToPrefixedString(exts, " extends=\""));
        }
        if (!conf.isTransitive()) {
            out.print(" transitive=\"false\"");
        }
        if (conf.getDeprecated() != null) {
            out.print(" deprecated=\"" + XMLHelper.escape(conf.getDeprecated()) + "\"");
        }
        XmlModuleDescriptorWriter.printExtraAttributes(conf, out, " ");
        out.println("/>");
    }

    private static void printInfoTag(ModuleDescriptor md, PrintWriter out) {
        ExtendsDescriptor[] dmd;
        String revision;
        out.println("\t<info organisation=\"" + XMLHelper.escape(md.getModuleRevisionId().getOrganisation()) + "\"");
        out.println("\t\tmodule=\"" + XMLHelper.escape(md.getModuleRevisionId().getName()) + "\"");
        String branch = md.getResolvedModuleRevisionId().getBranch();
        if (branch != null) {
            out.println("\t\tbranch=\"" + XMLHelper.escape(branch) + "\"");
        }
        if ((revision = md.getResolvedModuleRevisionId().getRevision()) != null) {
            out.println("\t\trevision=\"" + XMLHelper.escape(revision) + "\"");
        }
        out.println("\t\tstatus=\"" + XMLHelper.escape(md.getStatus()) + "\"");
        out.println("\t\tpublication=\"" + DateUtil.format(md.getResolvedPublicationDate()) + "\"");
        if (md.isDefault()) {
            out.println("\t\tdefault=\"true\"");
        }
        if (md instanceof DefaultModuleDescriptor && (dmd = (ExtendsDescriptor[])md).getNamespace() != null && !dmd.getNamespace().getName().equals("system")) {
            out.println("\t\tnamespace=\"" + XMLHelper.escape(dmd.getNamespace().getName()) + "\"");
        }
        if (!md.getExtraAttributes().isEmpty()) {
            XmlModuleDescriptorWriter.printExtraAttributes(md, out, "\t\t");
            out.println();
        }
        if (XmlModuleDescriptorWriter.requireInnerInfoElement(md)) {
            out.println("\t>");
            for (ExtendsDescriptor parent : md.getInheritedDescriptors()) {
                ModuleRevisionId mrid = parent.getParentRevisionId();
                out.print(String.format("\t\t<extends organisation=\"%s\" module=\"%s\" revision=\"%s\"", XMLHelper.escape(mrid.getOrganisation()), XMLHelper.escape(mrid.getName()), XMLHelper.escape(mrid.getRevision())));
                String location = parent.getLocation();
                if (location != null) {
                    out.print(" location=\"" + XMLHelper.escape(location) + "\"");
                }
                out.print(" extendType=\"" + StringUtils.joinArray(parent.getExtendsTypes(), ",") + "\"");
                out.println("/>");
            }
            License[] licenses = md.getLicenses();
            for (License license : licenses) {
                out.print("\t\t<license ");
                if (license.getName() != null) {
                    out.print("name=\"" + XMLHelper.escape(license.getName()) + "\" ");
                }
                if (license.getUrl() != null) {
                    out.print("url=\"" + XMLHelper.escape(license.getUrl()) + "\" ");
                }
                out.println("/>");
            }
            if (md.getHomePage() != null || md.getDescription() != null) {
                out.print("\t\t<description");
                if (md.getHomePage() != null) {
                    out.print(" homepage=\"" + XMLHelper.escape(md.getHomePage()) + "\"");
                }
                if (StringUtils.isNullOrEmpty(md.getDescription())) {
                    out.println(" />");
                } else {
                    out.println(">");
                    out.println("\t\t" + XMLHelper.escape(md.getDescription()));
                    out.println("\t\t</description>");
                }
            }
            for (ExtraInfoHolder extraInfo : md.getExtraInfos()) {
                XmlModuleDescriptorWriter.printExtraInfoElement(out, extraInfo, 2);
            }
            out.println("\t</info>");
        } else {
            out.println("\t/>");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void printExtraInfoElement(PrintWriter out, ExtraInfoHolder extraInfo, int indent) {
        for (int i = 1; i <= indent; ++i) {
            out.print("\t");
        }
        out.print("<");
        out.print(extraInfo.getName());
        for (Map.Entry<String, String> entry : extraInfo.getAttributes().entrySet()) {
            out.print(String.format(" %s=\"%s\"", entry.getKey(), entry.getValue()));
        }
        boolean requireClosingTag = false;
        if (!StringUtils.isNullOrEmpty(extraInfo.getContent())) {
            out.print(">");
            out.print(XMLHelper.escape(extraInfo.getContent()));
            requireClosingTag = true;
        }
        if (!extraInfo.getNestedExtraInfoHolder().isEmpty()) {
            void var4_9;
            out.println(">");
            for (ExtraInfoHolder nestedElement : extraInfo.getNestedExtraInfoHolder()) {
                XmlModuleDescriptorWriter.printExtraInfoElement(out, nestedElement, indent + 1);
            }
            requireClosingTag = true;
            boolean bl = true;
            while (var4_9 <= indent) {
                out.print("\t");
                ++var4_9;
            }
        }
        if (requireClosingTag) {
            out.print("</");
            out.print(extraInfo.getName());
            out.println(">");
        } else {
            out.println("/>");
        }
    }

    private static boolean requireInnerInfoElement(ModuleDescriptor md) {
        return md.getExtraInfos().size() > 0 || md.getHomePage() != null || !StringUtils.isNullOrEmpty(md.getDescription()) || md.getLicenses().length > 0 || md.getInheritedDescriptors().length > 0;
    }

    private static String getConfs(ModuleDescriptor md, Artifact artifact) {
        StringBuilder ret = new StringBuilder();
        for (String conf : md.getConfigurationsNames()) {
            if (!Arrays.asList(md.getArtifacts(conf)).contains(artifact)) continue;
            ret.append(conf).append(",");
        }
        if (ret.length() > 0) {
            ret.setLength(ret.length() - 1);
        }
        return ret.toString();
    }
}

