/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.CfgContainingDeclarationUtilsKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.types.expressions.AssignedVariablesSearcher;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a$\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u001a.\u0010\r\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001e\u0010\u0011\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\f\u0010\u0012\u001a\u00020\u0001*\u00020\u0013H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\u0015H\u0002\u001a\u0016\u0010\u0016\u001a\u00020\u0017*\u00020\u00132\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a.\u0010\u0018\u001a\u00020\u0017*\u00020\u00192\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a8\u0006\u001c"}, d2={"areCompiledTogether", "", "usageModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "declarationModule", "hasNoWritersInClosures", "variableContainingDeclaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "writers", "", "Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher$Writer;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isAccessedBeforeAllClosureWriters", "accessElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isAccessedInsideClosure", "isAccessedInsideClosureAfterAllWriters", "hasDefaultGetter", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isInvisibleFromOtherModules", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "propertyKind", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "variableKind", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
public final class DataFlowValueKindUtilsKt {
    @NotNull
    public static final DataFlowValue.Kind propertyKind(@NotNull PropertyDescriptor $this$propertyKind, @Nullable ModuleDescriptor usageModule) {
        Intrinsics.checkNotNullParameter($this$propertyKind, "<this>");
        if ($this$propertyKind.isVar()) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        if (ModalityUtilsKt.isOverridable($this$propertyKind)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!DataFlowValueKindUtilsKt.hasDefaultGetter($this$propertyKind)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!DataFlowValueKindUtilsKt.isInvisibleFromOtherModules($this$propertyKind)) {
            ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($this$propertyKind);
            Intrinsics.checkNotNullExpressionValue(moduleDescriptor, "getContainingModule(this)");
            ModuleDescriptor declarationModule = moduleDescriptor;
            if (!DataFlowValueKindUtilsKt.areCompiledTogether(usageModule, declarationModule)) {
                return DataFlowValue.Kind.ALIEN_PUBLIC_PROPERTY;
            }
        }
        return DataFlowValue.Kind.STABLE_VALUE;
    }

    public static final boolean areCompiledTogether(@Nullable ModuleDescriptor usageModule, @NotNull ModuleDescriptor declarationModule) {
        Intrinsics.checkNotNullParameter(declarationModule, "declarationModule");
        if (usageModule == null) {
            return false;
        }
        if (Intrinsics.areEqual(usageModule, declarationModule)) {
            return true;
        }
        return usageModule.getAllExpectedByModules().contains(declarationModule);
    }

    @NotNull
    public static final DataFlowValue.Kind variableKind(@NotNull VariableDescriptor $this$variableKind, @Nullable ModuleDescriptor usageModule, @NotNull BindingContext bindingContext, @NotNull KtElement accessElement, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter($this$variableKind, "<this>");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(accessElement, "accessElement");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if ($this$variableKind instanceof PropertyDescriptor) {
            return DataFlowValueKindUtilsKt.propertyKind((PropertyDescriptor)$this$variableKind, usageModule);
        }
        if ($this$variableKind instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)$this$variableKind).isDelegated()) {
            return languageVersionSettings.supportsFeature(LanguageFeature.ProhibitSmartcastsOnLocalDelegatedProperty) ? DataFlowValue.Kind.PROPERTY_WITH_GETTER : DataFlowValue.Kind.LEGACY_STABLE_LOCAL_DELEGATED_PROPERTY;
        }
        if (!($this$variableKind instanceof LocalVariableDescriptor) && !($this$variableKind instanceof ParameterDescriptor)) {
            return DataFlowValue.Kind.OTHER;
        }
        if (!$this$variableKind.isVar()) {
            return DataFlowValue.Kind.STABLE_VALUE;
        }
        if ($this$variableKind instanceof SyntheticFieldDescriptor) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        PreliminaryDeclarationVisitor preliminaryDeclarationVisitor = PreliminaryDeclarationVisitor.Companion.getVisitorByVariable($this$variableKind, bindingContext);
        if (preliminaryDeclarationVisitor == null) {
            return DataFlowValue.Kind.CAPTURED_VARIABLE;
        }
        PreliminaryDeclarationVisitor preliminaryVisitor = preliminaryDeclarationVisitor;
        Set<AssignedVariablesSearcher.Writer> writers = preliminaryVisitor.writers($this$variableKind);
        if (writers.isEmpty()) {
            return DataFlowValue.Kind.STABLE_VARIABLE;
        }
        DeclarationDescriptor declarationDescriptor = $this$variableKind.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "this.containingDeclaration");
        DeclarationDescriptor variableContainingDeclaration = declarationDescriptor;
        if (DataFlowValueKindUtilsKt.isAccessedInsideClosure(variableContainingDeclaration, bindingContext, accessElement)) {
            return preliminaryVisitor.getLanguageVersionSettings().supportsFeature(LanguageFeature.CapturedInClosureSmartCasts) && DataFlowValueKindUtilsKt.hasNoWritersInClosures(variableContainingDeclaration, writers, bindingContext) && DataFlowValueKindUtilsKt.isAccessedInsideClosureAfterAllWriters(writers, accessElement) ? DataFlowValue.Kind.STABLE_VARIABLE : DataFlowValue.Kind.CAPTURED_VARIABLE;
        }
        return DataFlowValueKindUtilsKt.isAccessedBeforeAllClosureWriters(variableContainingDeclaration, writers, bindingContext, accessElement) ? DataFlowValue.Kind.STABLE_VARIABLE : DataFlowValue.Kind.CAPTURED_VARIABLE;
    }

    public static final boolean hasNoWritersInClosures(@NotNull DeclarationDescriptor variableContainingDeclaration, @NotNull Set<AssignedVariablesSearcher.Writer> writers, @NotNull BindingContext bindingContext) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(variableContainingDeclaration, "variableContainingDeclaration");
            Intrinsics.checkNotNullParameter(writers, "writers");
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            Iterable $this$none$iv = writers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    AssignedVariablesSearcher.Writer $dstr$_u24__u24$writerDeclaration = (AssignedVariablesSearcher.Writer)element$iv;
                    boolean bl2 = false;
                    KtDeclaration writerDeclaration = $dstr$_u24__u24$writerDeclaration.component2();
                    boolean bl3 = writerDeclaration != null && !Intrinsics.areEqual(variableContainingDeclaration, CfgContainingDeclarationUtilsKt.getDeclarationDescriptorIncludingConstructors(writerDeclaration, bindingContext));
                    if (!bl3) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isAccessedInsideClosureAfterAllWriters(Set<AssignedVariablesSearcher.Writer> writers, KtElement accessElement) {
        boolean bl;
        block4: {
            KtDeclaration ktDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(accessElement);
            if (ktDeclaration == null) {
                return false;
            }
            KtDeclaration parent2 = ktDeclaration;
            Iterable $this$none$iv = writers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    AssignedVariablesSearcher.Writer $dstr$assignment = (AssignedVariablesSearcher.Writer)element$iv;
                    boolean bl2 = false;
                    KtBinaryExpression assignment = $dstr$assignment.component1();
                    if (!(!PsiUtilsKt.before(assignment, parent2))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isAccessedBeforeAllClosureWriters(DeclarationDescriptor variableContainingDeclaration, Set<AssignedVariablesSearcher.Writer> writers, BindingContext bindingContext, KtElement accessElement) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = writers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtDeclaration ktDeclaration;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            AssignedVariablesSearcher.Writer it = (AssignedVariablesSearcher.Writer)element$iv$iv;
            boolean bl2 = false;
            if (it.getDeclaration() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            KtDeclaration it$iv$iv = ktDeclaration;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            KtDeclaration writerDeclaration = (KtDeclaration)element$iv;
            boolean bl = false;
            DeclarationDescriptor writerDescriptor = CfgContainingDeclarationUtilsKt.getDeclarationDescriptorIncludingConstructors(writerDeclaration, bindingContext);
            if (Intrinsics.areEqual(variableContainingDeclaration, writerDescriptor) || PsiUtilsKt.before(accessElement, writerDeclaration)) continue;
            return false;
        }
        return true;
    }

    private static final boolean isInvisibleFromOtherModules(DeclarationDescriptorWithVisibility $this$isInvisibleFromOtherModules) {
        if (DescriptorVisibilities.INVISIBLE_FROM_OTHER_MODULES.contains($this$isInvisibleFromOtherModules.getVisibility())) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = $this$isInvisibleFromOtherModules.getContainingDeclaration();
        return containingDeclaration instanceof DeclarationDescriptorWithVisibility && DataFlowValueKindUtilsKt.isInvisibleFromOtherModules((DeclarationDescriptorWithVisibility)containingDeclaration);
    }

    private static final boolean hasDefaultGetter(PropertyDescriptor $this$hasDefaultGetter) {
        PropertyGetterDescriptor getter2 = $this$hasDefaultGetter.getGetter();
        return getter2 == null || getter2.isDefault();
    }

    private static final boolean isAccessedInsideClosure(DeclarationDescriptor variableContainingDeclaration, BindingContext bindingContext, KtElement accessElement) {
        KtDeclaration parent2 = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(accessElement);
        return parent2 != null ? !Intrinsics.areEqual(CfgContainingDeclarationUtilsKt.getDeclarationDescriptorIncludingConstructors(parent2, bindingContext), variableContainingDeclaration) : false;
    }
}

